/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import com.sun.media.sound.MidiUtils;
import java.util.ArrayList;
import java.util.HashSet;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;

public class Track {
    private ArrayList eventsList = new ArrayList();
    private HashSet set = new HashSet();
    private MidiEvent eotEvent;

    Track() {
        ImmutableEndOfTrack eot = new ImmutableEndOfTrack();
        this.eotEvent = new MidiEvent(eot, 0L);
        this.eventsList.add(this.eotEvent);
        this.set.add(this.eotEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(MidiEvent event) {
        if (event == null) {
            return false;
        }
        ArrayList arrayList = this.eventsList;
        synchronized (arrayList) {
            if (!this.set.contains(event)) {
                int i;
                int eventsCount = this.eventsList.size();
                MidiEvent lastEvent = null;
                if (eventsCount > 0) {
                    lastEvent = (MidiEvent)this.eventsList.get(eventsCount - 1);
                }
                if (lastEvent != this.eotEvent) {
                    if (lastEvent != null) {
                        this.eotEvent.setTick(lastEvent.getTick());
                    } else {
                        this.eotEvent.setTick(0L);
                    }
                    this.eventsList.add(this.eotEvent);
                    this.set.add(this.eotEvent);
                    eventsCount = this.eventsList.size();
                }
                if (MidiUtils.isMetaEndOfTrack(event.getMessage())) {
                    if (event.getTick() > this.eotEvent.getTick()) {
                        this.eotEvent.setTick(event.getTick());
                    }
                    return true;
                }
                this.set.add(event);
                for (i = eventsCount; i > 0 && event.getTick() < ((MidiEvent)this.eventsList.get(i - 1)).getTick(); --i) {
                }
                if (i == eventsCount) {
                    this.eventsList.set(eventsCount - 1, event);
                    if (this.eotEvent.getTick() < event.getTick()) {
                        this.eotEvent.setTick(event.getTick());
                    }
                    this.eventsList.add(this.eotEvent);
                } else {
                    this.eventsList.add(i, event);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(MidiEvent event) {
        ArrayList arrayList = this.eventsList;
        synchronized (arrayList) {
            int i;
            if (this.set.remove(event) && (i = this.eventsList.indexOf(event)) >= 0) {
                this.eventsList.remove(i);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiEvent get(int index) throws ArrayIndexOutOfBoundsException {
        try {
            ArrayList arrayList = this.eventsList;
            synchronized (arrayList) {
                return (MidiEvent)this.eventsList.get(index);
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new ArrayIndexOutOfBoundsException(ioobe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ArrayList arrayList = this.eventsList;
        synchronized (arrayList) {
            return this.eventsList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long ticks() {
        long ret = 0L;
        ArrayList arrayList = this.eventsList;
        synchronized (arrayList) {
            if (this.eventsList.size() > 0) {
                ret = ((MidiEvent)this.eventsList.get(this.eventsList.size() - 1)).getTick();
            }
        }
        return ret;
    }

    private static class ImmutableEndOfTrack
    extends MetaMessage {
        private ImmutableEndOfTrack() {
            super(new byte[3]);
            this.data[0] = -1;
            this.data[1] = 47;
            this.data[2] = 0;
        }

        @Override
        public void setMessage(int type, byte[] data, int length) throws InvalidMidiDataException {
            throw new InvalidMidiDataException("cannot modify end of track message");
        }
    }
}

