/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_kn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MRU", "MRU" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "USD", "$" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VES", "VES" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "aed", "\u0cb8\u0c82\u0caf\u0cc1\u0c95\u0ccd\u0ca4 \u0c85\u0cb0\u0cac\u0ccd\u200c \u0c8e\u0cae\u0cbf\u0cb0\u0cc7\u0c9f\u0ccd\u200c\u200c\u0c97\u0cb3 \u0ca6\u0cbf\u0cb0\u0cbe\u0cae\u0ccd\u200c\u200c" },
            { "afn", "\u0c85\u0cab\u0ccd\u200c\u0c98\u0ca8\u0ccd \u0c85\u0cab\u0c98\u0cbe\u0ca8\u0cbf" },
            { "all", "\u0c85\u0cb2\u0ccd\u200c\u0cac\u0cc7\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0cb2\u0cc6\u0c95\u0ccd" },
            { "amd", "\u0c85\u0cb0\u0ccd\u0cae\u0cc6\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0ca1\u0ccd\u0cb0\u0cbe\u0cae\u0ccd" },
            { "ang", "\u0ca8\u0cc6\u0ca6\u0cb0\u0ccd\u0cb2\u0cc6\u0c82\u0ca1\u0ccd\u0cb8\u0ccd \u0c86\u0c82\u0c9f\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd \u0c97\u0cbf\u0cb2\u0ccd\u0ca1\u0cb0\u0ccd" },
            { "aoa", "\u0c85\u0c82\u0c97\u0ccb\u0cb2\u0cbe\u0ca6 \u0c95\u0ccd\u0cb5\u0cbe\u0ca8\u0ccd\u0c9d\u0cbe" },
            { "ars", "\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0caa\u0cc6\u0cb8\u0cca" },
            { "aud", "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0ca8\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd\u200c" },
            { "awg", "\u0c85\u0cb0\u0cc1\u0cac\u0ca8\u0ccd \u0cab\u0ccd\u0cb2\u0cca\u0cb0\u0cc0\u0ca8\u0ccd\u200c\u200c" },
            { "azn", "\u0c85\u0c9d\u0cb0\u0ccd\u200c\u0cac\u0cc8\u0c9c\u0cbe\u0ca8\u0cbf \u0cae\u0ca8\u0cbe\u0ca4\u0ccd" },
            { "bam", "\u0cac\u0ccb\u0cb8\u0ccd\u0ca8\u0cbf\u0caf\u0cbe-\u0cb9\u0cb0\u0ccd\u0c9c\u0ccd\u200c\u0c97\u0ccb\u0cb5\u0cbf\u0ca8 \u0caa\u0cb0\u0cbf\u0cb5\u0cb0\u0ccd\u0ca4\u0ca8\u0cc0\u0caf \u0c97\u0cc1\u0cb0\u0cc1\u0ca4\u0cc1" },
            { "bbd", "\u0cac\u0cb0\u0ccd\u0cac\u0cbe\u0ca1\u0cbf\u0caf\u0ca8\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "bdt", "\u0cac\u0cbe\u0c82\u0c97\u0ccd\u0cb2\u0cbe\u0ca6\u0cc7\u0cb6\u0ca6 \u0c9f\u0cbe\u0c95\u0cbe" },
            { "bgn", "\u0cac\u0cb2\u0ccd\u0c97\u0cc7\u0cb0\u0cbf\u0caf\u0ca8\u0ccd \u0cb2\u0cc6\u0cb5\u0ccd" },
            { "bhd", "\u0cac\u0cb9\u0ccd\u200c\u200c\u0cb0\u0cc8\u0ca8\u0cbf \u0ca6\u0cbf\u0ca8\u0cbe\u0cb0\u0ccd" },
            { "bif", "\u0cac\u0cc1\u0cb0\u0cc1\u0c82\u0ca6\u0cbf\u0caf\u0ca8\u0ccd \u0cab\u0ccd\u0cb0\u0cbe\u0c82\u0c95\u0ccd" },
            { "bmd", "\u0cac\u0cb0\u0ccd\u0cae\u0cc1\u0ca1\u0ca8\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "bnd", "\u0cac\u0ccd\u0cb0\u0cc2\u0ca8\u0cbf \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "bob", "\u0cac\u0cca\u0cb2\u0cbf\u0cb5\u0cbf\u0caf\u0cbe\u0ca6 \u0cac\u0cca\u0cb2\u0cbf\u0cb5\u0cbf\u0caf\u0cbe\u0ca8\u0cca" },
            { "brl", "\u0cac\u0ccd\u0cb0\u0cc6\u0c9c\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd\u200c \u0cb0\u0cbf\u0caf\u0cb2\u0ccd" },
            { "bsd", "\u0cac\u0cb9\u0cbe\u0cae\u0cbf\u0caf\u0ca8\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "btn", "\u0cad\u0cc2\u0ca4\u0cbe\u0ca8\u0cc0\u0cb8\u0ccd \u0ca8\u0cc1\u0cb2\u0ccd\u0ca4\u0cb0\u0cae\u0ccd" },
            { "bwp", "\u0cac\u0ccb\u0c9f\u0ccd\u0cb8\u0ccd\u200c\u0cb5\u0cbe\u0ca8\u0ca8\u0ccd \u0caa\u0cc1\u0cb2\u0cbe" },
            { "byn", "\u0cac\u0cc6\u0cb2\u0cbe\u0cb0\u0cc1\u0cb8\u0cbf\u0caf\u0ca8\u0ccd \u0cb0\u0cc2\u0cac\u0cb2\u0ccd" },
            { "byr", "\u0cac\u0cc6\u0cb2\u0cbe\u0cb0\u0cc1\u0cb8\u0cbf\u0caf\u0ca8\u0ccd \u0cb0\u0cc2\u0cac\u0cb2\u0ccd (2000\u20132016)" },
            { "bzd", "\u0cac\u0cc6\u0cb2\u0cc0\u0c9c\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "cad", "\u0c95\u0cc6\u0ca8\u0ca1\u0cbe\u0ca6 \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "cdf", "\u0c95\u0cbe\u0c82\u0c97\u0ccb\u0cb2\u0cc0\u0cb8\u0ccd \u0cab\u0ccd\u0cb0\u0cbe\u0c82\u0c95\u0ccd" },
            { "chf", "\u0cb8\u0ccd\u0cb5\u0cbf\u0cb8\u0ccd \u0cab\u0ccd\u0cb0\u0cbe\u0c82\u0c95\u0ccd" },
            { "clp", "\u0c9a\u0cbf\u0cb2\u0cbf\u0caf \u0caa\u0cc6\u0cb8\u0cca" },
            { "cnh", "\u0c9a\u0cc8\u0ca8\u0cc0\u0cb8\u0ccd \u0caf\u0cc1\u0cb5\u0cbe\u0ca8\u0ccd (\u0c86\u0cab\u0ccd\u200c\u0cb6\u0ccb\u0cb0\u0ccd)" },
            { "cny", "\u0c9a\u0cc8\u0ca8\u0cc0\u0cb8\u0ccd \u0caf\u0cc1\u0cb5\u0cbe\u0ca8\u0ccd" },
            { "cop", "\u0c95\u0cca\u0cb2\u0cca\u0c82\u0cac\u0cbf\u0caf\u0ccb\u0ca6 \u0caa\u0cc6\u0cb8\u0cca" },
            { "crc", "\u0c95\u0ccb\u0cb8\u0ccd\u0c9f \u0cb0\u0cbf\u0c95\u0ca8\u0ccd \u0c95\u0cca\u0cb2\u0ca8\u0ccd" },
            { "cuc", "\u0c95\u0ccd\u0caf\u0cc1\u0cac\u0cbe\u0ca6 \u0caa\u0cb0\u0cbf\u0cb5\u0cb0\u0ccd\u0ca4\u0ca8\u0cc0\u0caf \u0caa\u0cc6\u0cb8\u0cca" },
            { "cup", "\u0c95\u0ccd\u0caf\u0cc2\u0cac\u0cbe\u0ca6 \u0caa\u0cc6\u0cb8\u0cca" },
            { "cve", "\u0c95\u0cc7\u0caa\u0ccd \u0cb5\u0cb0\u0ccd\u0ca1\u0cbf\u0ca8\u0ccd \u0c8e\u0cb8\u0ccd\u200c\u0c95\u0cc2\u0ca1\u0cca" },
            { "czk", "\u0c9d\u0cc6\u0c95\u0ccd \u0c97\u0ca3\u0cb0\u0cbe\u0c9c\u0ccd\u0caf \u0c95\u0cca\u0cb0\u0cc2\u0ca8" },
            { "djf", "\u0c9c\u0cbf\u0cac\u0cca\u0c9f\u0cbf\u0caf\u0ca8\u0ccd \u0cab\u0ccd\u0cb0\u0cbe\u0c82\u0c95\u0ccd" },
            { "dkk", "\u0ca1\u0ccd\u0caf\u0cbe\u0ca8\u0cbf\u0cb6\u0ccd \u0c95\u0ccd\u0cb0\u0ccb\u0ca8\u0ccd" },
            { "dop", "\u0ca1\u0cca\u0cae\u0cbf\u0ca8\u0cbf\u0c95\u0ca8\u0ccd \u0caa\u0cc6\u0cb8\u0cca" },
            { "dzd", "\u0c85\u0cb2\u0ccd\u0c9c\u0cc0\u0cb0\u0cbf\u0caf\u0ca8\u0ccd \u0ca6\u0cbf\u0ca8\u0cbe\u0cb0\u0ccd" },
            { "egp", "\u0c88\u0c9c\u0cbf\u0caa\u0ccd\u0cb7\u0cbf\u0caf\u0ca8\u0ccd \u0caa\u0ccc\u0c82\u0ca1\u0ccd\u200d" },
            { "ern", "\u0c8e\u0cb0\u0cbf\u0ca4\u0ccd\u0cb0\u0cbf\u0caf\u0ca8\u0ccd \u0ca8\u0c95\u0ccd\u0cab\u0cbe" },
            { "etb", "\u0c87\u0ca5\u0cbf\u0caf\u0ccb\u0caa\u0cbf\u0caf\u0ca8\u0ccd \u0cac\u0cbf\u0cb0\u0ccd" },
            { "eur", "\u0caf\u0cc2\u0cb0\u0cca" },
            { "fjd", "\u0cab\u0cbf\u0c9c\u0cbf\u0caf\u0ca8\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "fkp", "\u0cab\u0cbe\u0cb2\u0ccd\u0c95\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3 \u0caa\u0ccc\u0c82\u0ca1\u0ccd" },
            { "gbp", "\u0cac\u0ccd\u0cb0\u0cbf\u0c9f\u0cc0\u0cb7\u0ccd \u0caa\u0ccc\u0c82\u0ca1\u0ccd" },
            { "gel", "\u0c9c\u0cbe\u0cb0\u0ccd\u0c9c\u0cbf\u0caf\u0cbe\u0ca6 \u0cb2\u0cbe\u0cb0\u0cbf" },
            { "ghs", "\u0c98\u0cbe\u0ca8\u0cbe\u0ca6 \u0cb8\u0cc6\u0ca6\u0cbf" },
            { "gip", "\u0c97\u0cbf\u0cac\u0ccd\u0cb0\u0cbe\u0cb2\u0ccd\u0c9f\u0cb0\u0ccd \u0caa\u0ccc\u0c82\u0ca1\u0ccd" },
            { "gmd", "\u0c97\u0ccd\u0caf\u0cbe\u0c82\u0cac\u0cbf\u0caf\u0cbe\u0ca6 \u0ca6\u0cb2\u0cbe\u0cb8\u0cbf" },
            { "gnf", "\u0c97\u0cbf\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0cab\u0ccd\u0cb0\u0cbe\u0c82\u0c95\u0ccd" },
            { "gtq", "\u0c97\u0ccd\u0cb5\u0cbe\u0c9f\u0cc6\u0cae\u0cbe\u0cb2\u0cbe\u0ca6 \u0c95\u0cc1\u0caf\u0cbf\u0c9f\u0ccd\u0cb8\u0cb2\u0ccd\u200c\u200c" },
            { "gyd", "\u0c97\u0cc1\u0caf\u0cbe\u0ca8\u0cc0\u0cb8\u0ccd\u200c \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd\u200c" },
            { "hkd", "\u0cb9\u0cbe\u0c82\u0c97\u0ccd \u0c95\u0cbe\u0c82\u0c97\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "hnl", "\u0cb9\u0cca\u0c82\u0ca1\u0cc1\u0cb0\u0cbe\u0ca8\u0ccd\u200c \u0cb2\u0cc6\u0c82\u0caa\u0cbf\u0cb0\u0cbe" },
            { "hrk", "\u0c95\u0ccd\u0cb0\u0cca\u0caf\u0cc6\u0cb7\u0ccd\u0caf\u0cbe\u0ca6 \u0c95\u0cc2\u0ca8\u0cbe" },
            { "htg", "\u0cb9\u0cc8\u0c9f\u0cbf\u0caf \u0c97\u0ccb\u0cb0\u0ccd\u0ca6\u0cc6" },
            { "huf", "\u0cb9\u0c82\u0c97\u0cc7\u0cb0\u0cbf\u0caf\u0ca8\u0ccd \u0cab\u0ccb\u0cb0\u0cbf\u0c82\u0c9f\u0ccd" },
            { "idr", "\u0c87\u0c82\u0ca1\u0cca\u0ca8\u0cc7\u0cb7\u0ccd\u0caf\u0cbe \u0cb0\u0cc1\u0caa\u0cc8" },
            { "ils", "\u0c87\u0cb8\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf \u0ca8\u0ccd\u0caf\u0cc2 \u0cb6\u0cc7\u0c96\u0cb2\u0ccd" },
            { "inr", "\u0cad\u0cbe\u0cb0\u0ca4\u0cc0\u0caf \u0cb0\u0cc2\u0caa\u0cbe\u0caf\u0cbf" },
            { "iqd", "\u0c87\u0cb0\u0cbe\u0c95\u0cbf \u0ca6\u0cbf\u0ca8\u0cbe\u0cb0\u0ccd" },
            { "irr", "\u0c87\u0cb0\u0cbe\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0cb0\u0cbf\u0caf\u0cb2\u0ccd" },
            { "isk", "\u0c90\u0cb8\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0cbf\u0c95\u0ccd \u0c95\u0ccd\u0cb0\u0ccb\u0ca8\u0cbe" },
            { "jmd", "\u0c9c\u0cae\u0cc8\u0c95\u0ca8\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "jod", "\u0c9c\u0ccb\u0cb0\u0ccd\u0ca1\u0cbe\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0ca6\u0cbf\u0ca8\u0cbe\u0cb0\u0ccd" },
            { "jpy", "\u0c9c\u0caa\u0cbe\u0ca8\u0cc0\u0cb8\u0ccd \u0caf\u0cc6\u0ca8\u0ccd" },
            { "kes", "\u0c95\u0cc0\u0ca8\u0ccd\u0caf\u0cbe\u0ca6 \u0cb6\u0cbf\u0cb2\u0ccd\u0cb2\u0cbf\u0c82\u0c97\u0ccd\u200c" },
            { "kgs", "\u0c95\u0cbf\u0cb0\u0ccd\u0c97\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0cbf \u0cb8\u0ccb\u0cae\u0ccd" },
            { "khr", "\u0c95\u0cbe\u0c82\u0cac\u0ccb\u0ca1\u0cbf\u0caf\u0ca8\u0ccd \u0cb0\u0cbf\u0caf\u0cb2\u0ccd" },
            { "kmf", "\u0c95\u0cca\u0cae\u0cca\u0cb0\u0cbf\u0caf\u0ca8\u0ccd \u0cab\u0ccd\u0cb0\u0cbe\u0c82\u0c95\u0ccd" },
            { "kpw", "\u0c89\u0ca4\u0ccd\u0ca4\u0cb0 \u0c95\u0cca\u0cb0\u0cbf\u0caf\u0ca8\u0ccd \u0cb5\u0ccb\u0ca8\u0ccd" },
            { "krw", "\u0ca6\u0c95\u0ccd\u0cb7\u0cbf\u0ca3 \u0c95\u0cca\u0cb0\u0cbf\u0caf\u0ca8\u0ccd \u0cb5\u0cca\u0ca8\u0ccd" },
            { "kwd", "\u0c95\u0cc1\u0cb5\u0cc8\u0ca4\u0cc0 \u0ca6\u0cbf\u0ca8\u0cbe\u0cb0\u0ccd" },
            { "kyd", "\u0c95\u0cc6\u0cae\u0ccd\u0caf\u0cbe\u0ca8\u0ccd\u200c \u0c90\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd\u200c\u0ca8 \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd\u200c" },
            { "kzt", "\u0c95\u0c9c\u0cbe\u0c95\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0cbf \u0ca4\u0cc6\u0c82\u0c97\u0cc6" },
            { "lak", "\u0cb2\u0ccb\u0c9f\u0cbf\u0caf\u0ca8\u0ccd \u0c95\u0cbf\u0caa\u0ccd" },
            { "lbp", "\u0cb2\u0cc6\u0cac\u0cc6\u0ca8\u0cc0\u0cb8\u0ccd \u0caa\u0ccc\u0c82\u0ca1\u0ccd" },
            { "lkr", "\u0cb6\u0ccd\u0cb0\u0cc0\u0cb2\u0c82\u0c95\u0cbe\u0ca6 \u0cb0\u0cc1\u0caa\u0cc0" },
            { "lrd", "\u0cb2\u0cbf\u0cac\u0cc7\u0cb0\u0cbf\u0caf\u0ca8\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "lsl", "\u0cb2\u0cc6\u0cb8\u0cca\u0ca4\u0cca \u0cb2\u0cca\u0ca4\u0cbf" },
            { "ltl", "\u0cb2\u0cbf\u0ca5\u0cc1\u0ca8\u0cbf\u0caf\u0ca8\u0ccd\u200c \u0cb2\u0cbf\u0ca4\u0cbe\u0cb8\u0ccd\u200c" },
            { "lvl", "\u0cb2\u0ccd\u0caf\u0cbe\u0c9f\u0ccd\u0cb5\u0cbf\u0caf\u0ca8\u0ccd \u0cb2\u0ccd\u0caf\u0cbe\u0c9f\u0ccd\u0cb8\u0ccd" },
            { "lyd", "\u0cb2\u0cbf\u0cac\u0cbf\u0caf\u0cbe\u0ca6 \u0ca6\u0cbf\u0ca8\u0cbe\u0cb0\u0ccd\u200c" },
            { "mad", "\u0cae\u0cca\u0cb0\u0cca\u0c95\u0ca8\u0ccd \u0ca6\u0cbf\u0cb0\u0ccd\u200c\u0cb9\u0cae\u0ccd" },
            { "mdl", "\u0cae\u0cb2\u0ccd\u0ca6\u0ccb\u0cb5\u0cbe\u0ca6 \u0cb2\u0cc6\u0cb5\u0cc2" },
            { "mga", "\u0cae\u0cb2\u0c97\u0cbe\u0cb8\u0cbf \u0c85\u0cb0\u0cbf\u0caf\u0cbe\u0cb0\u0cbf" },
            { "mkd", "\u0cae\u0cc6\u0cb8\u0ca1\u0ccb\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0ca6\u0cbf\u0ca8\u0cbe\u0cb0\u0ccd" },
            { "mmk", "\u0cae\u0ccd\u0caf\u0cbe\u0ca8\u0ccd\u0cae\u0cbe\u0cb0\u0ccd \u0c95\u0ccd\u0caf\u0cbe\u0c9f\u0ccd" },
            { "mnt", "\u0cae\u0c82\u0c97\u0ccb\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0ca4\u0cc1\u0c97\u0ccd\u0cb0\u0cbf\u0c95\u0ccd\u200c\u200c" },
            { "mop", "\u0cae\u0c95\u0cbe\u0ca8\u0cbf\u0cb8\u0ccd \u0caa\u0c9f\u0cbe\u0c95\u0cbe" },
            { "mro", "\u0cae\u0ccc\u0cb0\u0cc0\u0cb6\u0cbf\u0caf\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0c92\u0c97\u0cbf\u0caf (1973\u20132017)" },
            { "mru", "\u0cae\u0ccc\u0cb0\u0cc0\u0cb6\u0cbf\u0caf\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0c92\u0c97\u0cbf\u0caf" },
            { "mur", "\u0cae\u0cbe\u0cb0\u0cbf\u0cb7\u0cbf\u0caf\u0ca8\u0ccd \u0cb0\u0cc1\u0caa\u0cbf" },
            { "mvr", "\u0cae\u0cbe\u0cb2\u0ccd\u0ca1\u0cc0\u0cb5\u0cbf\u0caf\u0ca8\u0ccd \u0cb0\u0cc1\u0cab\u0cbf\u0caf\u0cbe" },
            { "mwk", "\u0cae\u0cb2\u0cbe\u0cb5\u0cbf\u0caf \u0c95\u0ccd\u0cb5\u0cbe\u0c9a" },
            { "mxn", "\u0cae\u0cc6\u0c95\u0ccd\u0cb8\u0cbf\u0c95\u0cca\u0ca6 \u0caa\u0cc6\u0cb8\u0cca" },
            { "myr", "\u0cae\u0cb2\u0cc7\u0cb6\u0cbf\u0caf\u0ca8\u0ccd \u0cb0\u0cbf\u0c82\u0c97\u0cbf\u0c9f\u0ccd" },
            { "mzn", "\u0cae\u0cca\u0c9d\u0cbe\u0c82\u0cac\u0cbf\u0c95\u0ca8\u0ccd \u0cae\u0cc6\u0c9f\u0cbf\u0c95\u0cb2\u0ccd" },
            { "nad", "\u0ca8\u0cae\u0cc0\u0cac\u0cbf\u0caf\u0ca8\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "ngn", "\u0ca8\u0cc8\u0c9c\u0cc0\u0cb0\u0cbf\u0caf\u0cbe\u0ca6 \u0ca8\u0cc7\u0cb0\u0cbe" },
            { "nio", "\u0ca8\u0cbf\u0c95\u0cbe\u0cb0\u0c97\u0ccd\u0cb5\u0cbe\u0ca6 \u0c95\u0cb0\u0ccd\u0ca6\u0cca\u0cac\u0cbe" },
            { "nok", "\u0ca8\u0cbe\u0cb0\u0ccd\u0cb5\u0cc7\u0caf \u0c95\u0ccd\u0cb0\u0ccb\u0ca8\u0ccd" },
            { "npr", "\u0ca8\u0cc7\u0caa\u0cbe\u0cb3\u0ca6 \u0cb0\u0cc1\u0caa\u0cc0" },
            { "nzd", "\u0ca8\u0ccd\u0caf\u0cc2\u0c9c\u0cbf\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "omr", "\u0c92\u0cae\u0cbe\u0ca8\u0cbf \u0cb0\u0cbf\u0caf\u0cb2\u0ccd" },
            { "pab", "\u0caa\u0ca8\u0cbe\u0cae\u0cbe\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0cac\u0cb2\u0ccd\u0cac\u0ccb\u0cb5\u0cbe" },
            { "pen", "\u0caa\u0cc6\u0cb0\u0cc1\u0cb5\u0cbf\u0caf\u0ca8\u0ccd \u0cb8\u0cca\u0cb2\u0ccd" },
            { "pgk", "\u0caa\u0caa\u0cc1\u0cb5\u0cbe \u0ca8\u0ccd\u0caf\u0cc2 \u0c97\u0cbf\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0c95\u0cbf\u0ca8\u0cbe" },
            { "php", "\u0cab\u0cbf\u0cb2\u0cbf\u0caa\u0ccd\u0caa\u0cc8\u0ca8\u0ccd \u0caa\u0cbf\u0cb8\u0cca" },
            { "pkr", "\u0caa\u0cbe\u0c95\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ca6 \u0cb0\u0cc1\u0caa\u0cc0" },
            { "pln", "\u0caa\u0cca\u0cb2\u0cbf\u0cb6\u0ccd \u0c9d\u0ccd\u0cb2\u0ccb\u0c9f\u0cbf" },
            { "pyg", "\u0caa\u0cc6\u0cb0\u0cc1\u0c97\u0ccd\u0cb5\u0cc7\u0caf \u0c97\u0ccd\u0cb5\u0cbe\u0cb0\u0ca8\u0cc0" },
            { "qar", "\u0c96\u0ca4\u0cbe\u0cb0\u0cbf \u0cb0\u0cbf\u0caf\u0cb2\u0ccd" },
            { "ron", "\u0cb0\u0cca\u0cae\u0cc7\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0cb2\u0cc6\u0cb5\u0cc1" },
            { "rsd", "\u0cb8\u0cc6\u0cb0\u0ccd\u0cac\u0cbf\u0caf\u0ca8\u0ccd \u0ca6\u0cbf\u0ca8\u0cbe\u0cb0\u0ccd" },
            { "rub", "\u0cb0\u0cb6\u0cbf\u0caf\u0ca8\u0ccd \u0cb0\u0cc2\u0cac\u0cb2\u0ccd" },
            { "rwf", "\u0cb0\u0cc1\u0cb5\u0cbe\u0c82\u0ca1\u0ca8\u0ccd \u0cab\u0ccd\u0cb0\u0cbe\u0c82\u0c95\u0ccd" },
            { "sar", "\u0cb8\u0ccc\u0ca6\u0cbf \u0cb0\u0cbf\u0caf\u0cbe\u0cb2\u0ccd" },
            { "sbd", "\u0cb8\u0cca\u0cb2\u0cca\u0cae\u0ca8\u0ccd \u0ca6\u0ccd\u0cb5\u0cc0\u0caa\u0c97\u0cb3 \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "scr", "\u0cb8\u0cc6\u0c9a\u0cca\u0cb2\u0cbf\u0caf\u0cca\u0cb8\u0ccd \u0cb0\u0cc1\u0caa\u0cbf" },
            { "sdg", "\u0cb8\u0cc1\u0ca1\u0cbe\u0ca8\u0cc0\u0cb8\u0ccd \u0caa\u0ccc\u0c82\u0ca1\u0ccd" },
            { "sek", "\u0cb8\u0ccd\u0cb5\u0cc0\u0ca1\u0cbf\u0cb7\u0ccd \u0c95\u0ccd\u0cb0\u0ccb\u0ca8\u0cbe" },
            { "sgd", "\u0cb8\u0cbf\u0c82\u0c97\u0cbe\u0caa\u0cc1\u0cb0\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd\u200c" },
            { "shp", "\u0cb8\u0cc7\u0c82\u0c9f\u0ccd \u0cb9\u0cc6\u0cb2\u0cc7\u0ca8\u0cbe \u0caa\u0ccc\u0c82\u0ca1\u0ccd" },
            { "sll", "\u0cb8\u0cbf\u0caf\u0cc6\u0cb0\u0cbe \u0cb2\u0cbf\u0caf\u0ccb\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0cb2\u0cbf\u0caf\u0ccb\u0ca8\u0ccd" },
            { "sos", "\u0cb8\u0cca\u0cae\u0cbe\u0cb2\u0cbf \u0cb6\u0cbf\u0cb2\u0ccd\u0cb2\u0cbf\u0c82\u0c97\u0ccd" },
            { "srd", "\u0cb8\u0cc1\u0cb0\u0cbf\u0ca8\u0cbe\u0cae\u0cc0\u0cb8\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "ssp", "\u0ca6\u0c95\u0ccd\u0cb7\u0cbf\u0ca3 \u0cb8\u0cc2\u0ca1\u0cbe\u0ca8\u0cc0\u0cb8\u0ccd \u0caa\u0ccc\u0c82\u0ca1\u0ccd\u200d" },
            { "std", "\u0cb8\u0cbe\u0cb5\u0cca \u0c9f\u0ccb\u0cae\u0ccd \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0caa\u0ccd\u0cb0\u0cbf\u0ca8\u0ccd\u0cb8\u0cbf\u0caa\u0ccd \u0ca6\u0cca\u0cac\u0ccd\u0cb0\u0cbe (1977\u20132017)" },
            { "stn", "\u0cb8\u0cbe\u0cb5\u0cca \u0c9f\u0ccb\u0cae\u0ccd \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0caa\u0ccd\u0cb0\u0cbf\u0ca8\u0ccd\u0cb8\u0cbf\u0caa\u0ccd \u0ca6\u0cca\u0cac\u0ccd\u0cb0\u0cbe" },
            { "syp", "\u0cb8\u0cbf\u0cb0\u0cbf\u0caf\u0ca8\u0ccd \u0caa\u0ccc\u0c82\u0ca1\u0ccd" },
            { "szl", "\u0cb8\u0ccd\u0cb5\u0cbe\u0c9c\u0cbf \u0cb2\u0cbf\u0cb2\u0c82\u0c97\u0cc6\u0ca8\u0cbf" },
            { "thb", "\u0ca5\u0cbe\u0caf\u0ccd \u0cac\u0cb9\u0ccd\u0ca4\u0ccd" },
            { "tjs", "\u0ca4\u0c9c\u0c95\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0cbf \u0cb8\u0cca\u0cae\u0ccb\u0ca8\u0cbf" },
            { "tmt", "\u0c9f\u0cb0\u0ccd\u0c95\u0ccd\u200d\u0cae\u0cc6\u0ca8\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd \u0cae\u0ca8\u0cbe\u0ca4\u0ccd" },
            { "tnd", "\u0c9f\u0ccd\u0caf\u0cc1\u0ca8\u0cc0\u0cb7\u0cbf\u0caf\u0ca8\u0ccd\u200c \u0ca6\u0cbf\u0ca8\u0cbe\u0cb0\u0ccd" },
            { "top", "\u0c9f\u0cca\u0c82\u0c97\u0cbe \u0caa\u0cbe\u0c82\u0c97" },
            { "try", "\u0c9f\u0cb0\u0ccd\u0c95\u0cbf\u0cb6\u0ccd \u0cb2\u0cbf\u0cb0\u0cbe" },
            { "ttd", "\u0c9f\u0ccd\u0cb0\u0cbf\u0ca8\u0cbf\u0ca1\u0cbe\u0ca1\u0ccd \u0cae\u0ca4\u0ccd\u0ca4\u0cc1 \u0c9f\u0cca\u0cac\u0cbe\u0c97\u0cca \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "twd", "\u0ca8\u0ccd\u0caf\u0cc2 \u0ca4\u0cc8\u0cb5\u0cbe\u0ca8\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "tzs", "\u0ca4\u0cbe\u0ca8\u0ccd\u200c\u0c9c\u0cc7\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0cb6\u0cbf\u0cb2\u0ccd\u0cb2\u0cbf\u0c82\u0c97\u0ccd" },
            { "uah", "\u0c89\u0c95\u0ccd\u0cb0\u0cc7\u0ca8\u0cbf\u0caf\u0ca8\u0ccd \u0cb9\u0ccd\u0cb0\u0cbf\u0cb5\u0ccd\u0ca8\u0cc0\u0caf" },
            { "ugx", "\u0c89\u0c97\u0cbe\u0c82\u0ca1\u0ca8\u0ccd \u0cb6\u0cbf\u0cb2\u0ccd\u0cb2\u0cbf\u0c82\u0c97\u0ccd" },
            { "usd", "\u0c85\u0cae\u0cc6\u0cb0\u0cbf\u0c95\u0ca6 \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd\u200c" },
            { "uyu", "\u0c89\u0cb0\u0cc1\u0c97\u0ccd\u0cb5\u0cc6\u0caf \u0caa\u0cc6\u0cb8\u0cca" },
            { "uzs", "\u0c89\u0c9c\u0ccd\u0cac\u0cc7\u0c95\u0cbf\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd \u0cb8\u0cca\u0cae\u0ccd" },
            { "vef", "\u0cb5\u0cc6\u0ca8\u0cbf\u0c9c\u0cc1\u0cb2\u0cbf\u0caf\u0ca8\u0ccd \u0cac\u0cca\u0cb2\u0cbf\u0cb5\u0cb0\u0ccd (2008\u20132018)" },
            { "ves", "\u0cb5\u0cc6\u0ca8\u0cbf\u0c9c\u0cc1\u0cb2\u0cbf\u0caf\u0ca8\u0ccd \u0cac\u0cca\u0cb2\u0cbf\u0cb5\u0cb0\u0ccd" },
            { "vnd", "\u0cb5\u0cbf\u0caf\u0cc6\u0c9f\u0ccd\u0ca8\u0cbe\u0cae\u0cc0\u0cb8\u0ccd \u0ca1\u0cbe\u0c82\u0c97\u0ccd" },
            { "vuv", "\u0cb5\u0ca8\u0cc2\u0ca4\u0cc1 \u0cb5\u0ca4\u0cc1" },
            { "wst", "\u0cb8\u0cae\u0ccb\u0ca8\u0ccd \u0ca4\u0cb2\u0cbe" },
            { "xaf", "\u0cae\u0ca7\u0ccd\u0caf \u0c86\u0cab\u0ccd\u0cb0\u0cbf\u0c95\u0ca8\u0ccd CFA \u0cab\u0ccd\u0cb0\u0cbe\u0c82\u0c95\u0ccd" },
            { "xcd", "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c95\u0cc6\u0cb0\u0cc0\u0cac\u0cbf\u0caf\u0ca8\u0ccd \u0ca1\u0cbe\u0cb2\u0cb0\u0ccd" },
            { "xof", "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c86\u0cab\u0ccd\u0cb0\u0cbf\u0c95\u0cbe\u0ca6 CFA \u0cab\u0ccd\u0cb0\u0cbe\u0c82\u0c95\u0ccd" },
            { "xpf", "[CFP] \u0cab\u0ccd\u0cb0\u0cbe\u0c82\u0c95\u0ccd" },
            { "xxx", "\u0c85\u0caa\u0cb0\u0cbf\u0c9a\u0cbf\u0ca4 \u0c95\u0cb0\u0cc6\u0ca8\u0ccd\u0cb8\u0cbf" },
            { "yer", "\u0caf\u0cc6\u0cae\u0cc6\u0ca8\u0cbf \u0cb0\u0cbf\u0caf\u0cb2\u0ccd" },
            { "zar", "\u0ca6\u0c95\u0ccd\u0cb7\u0cbf\u0ca3 \u0c86\u0cab\u0ccd\u0cb0\u0cbf\u0c95\u0ca8\u0ccd \u0cb0\u0cbe\u0c82\u0ca1\u0ccd" },
            { "zmk", "\u0c9c\u0cbe\u0c82\u0cac\u0cbf\u0caf\u0cbe \u0c95\u0ccd\u0cb5\u0cbe\u0c9a (1968\u20132012)" },
            { "zmw", "\u0c9c\u0cbe\u0c82\u0cac\u0cbf\u0caf\u0cbe \u0c95\u0ccd\u0cb5\u0cbe\u0c9a" },
        };
        return data;
    }
}
