/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.catalina.connector.OutputBuffer;

public class CoyoteWriter
extends PrintWriter {
    private static final char[] LINE_SEP = System.getProperty("line.separator").toCharArray();
    protected OutputBuffer ob;
    protected boolean error = false;

    public CoyoteWriter(OutputBuffer outputBuffer) {
        super(outputBuffer);
        this.ob = outputBuffer;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    void clear() {
        this.ob = null;
    }

    void recycle() {
        this.error = false;
    }

    @Override
    public void flush() {
        if (this.error) {
            return;
        }
        try {
            this.ob.flush();
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    @Override
    public void close() {
        try {
            this.ob.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.error = false;
    }

    @Override
    public boolean checkError() {
        this.flush();
        return this.error;
    }

    @Override
    public void write(int n) {
        if (this.error) {
            return;
        }
        try {
            this.ob.write(n);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        if (this.error) {
            return;
        }
        try {
            this.ob.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    @Override
    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public void write(String string, int n, int n2) {
        if (this.error) {
            return;
        }
        try {
            this.ob.write(string, n, n2);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    @Override
    public void write(String string) {
        this.write(string, 0, string.length());
    }

    @Override
    public void print(boolean bl) {
        if (bl) {
            this.write("true");
        } else {
            this.write("false");
        }
    }

    @Override
    public void print(char c) {
        this.write(c);
    }

    @Override
    public void print(int n) {
        this.write(String.valueOf(n));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] cArray) {
        this.write(cArray);
    }

    @Override
    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    @Override
    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    @Override
    public void println() {
        this.write(LINE_SEP);
    }

    @Override
    public void println(boolean bl) {
        this.print(bl);
        this.println();
    }

    @Override
    public void println(char c) {
        this.print(c);
        this.println();
    }

    @Override
    public void println(int n) {
        this.print(n);
        this.println();
    }

    @Override
    public void println(long l) {
        this.print(l);
        this.println();
    }

    @Override
    public void println(float f) {
        this.print(f);
        this.println();
    }

    @Override
    public void println(double d) {
        this.print(d);
        this.println();
    }

    @Override
    public void println(char[] cArray) {
        this.print(cArray);
        this.println();
    }

    @Override
    public void println(String string) {
        this.print(string);
        this.println();
    }

    @Override
    public void println(Object object) {
        this.print(object);
        this.println();
    }
}

