/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanInfo;
import io.micronaut.core.beans.PropertyDescriptor;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
@Deprecated
class SimpleBeanInfo
implements BeanInfo {
    private static final Set<String> EXCLUDED_PROPERTIES = CollectionUtils.setOf("class", "metaClass");
    private static final String PREFIX_IS = "is";
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_SET = "set";
    private static final String STR_GETTERS = "getters";
    private static final String STR_SETTERS = "setters";
    private static final String STR_NORMAL = "normal";
    private static final String STR_VALID = "valid";
    private static final String STR_PROPERTY_TYPE = "PropertyType";
    private static final String STR_INVALID = "invalid";
    private final Class<?> beanClass;
    private final Map<String, PropertyDescriptor> properties;

    SimpleBeanInfo(Class<?> beanClass) {
        this.beanClass = beanClass;
        List<PropertyDescriptor> propertyList = this.introspectProperties(SimpleBeanInfo.introspectMethods(beanClass));
        if (CollectionUtils.isEmpty(propertyList)) {
            this.properties = Collections.emptyMap();
        } else {
            HashMap<String, PropertyDescriptor> propertyMap = new HashMap<String, PropertyDescriptor>(propertyList.size());
            for (PropertyDescriptor propertyDescriptor : propertyList) {
                propertyMap.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            this.properties = Collections.unmodifiableMap(propertyMap);
        }
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Map<String, PropertyDescriptor> getPropertyDescriptors() {
        return this.properties;
    }

    private List<PropertyDescriptor> introspectProperties(Method[] methodDescriptors) {
        if (methodDescriptors == null) {
            return null;
        }
        HashMap<String, HashMap> propertyTable = new HashMap<String, HashMap>(methodDescriptors.length);
        for (Method methodDescriptor : methodDescriptors) {
            SimpleBeanInfo.introspectGet(methodDescriptor, propertyTable);
            SimpleBeanInfo.introspectSet(methodDescriptor, propertyTable);
        }
        this.fixGetSet(propertyTable);
        ArrayList<PropertyDescriptor> propertyList = new ArrayList<PropertyDescriptor>();
        for (Map.Entry<String, HashMap> entry : propertyTable.entrySet()) {
            String normalTag;
            String propertyName = entry.getKey();
            HashMap table = entry.getValue();
            if (table == null || (normalTag = (String)table.get(STR_NORMAL)) == null) continue;
            Method get = (Method)table.get("normalget");
            Method set = (Method)table.get("normalset");
            PropertyDescriptor propertyDesc = new PropertyDescriptor(propertyName, get, set);
            propertyList.add(propertyDesc);
        }
        return Collections.unmodifiableList(propertyList);
    }

    private static void introspectGet(Method theMethod, HashMap<String, HashMap> propertyTable) {
        String methodName = theMethod.getName();
        int prefixLength = 0;
        if (methodName == null) {
            return;
        }
        if (methodName.startsWith(PREFIX_GET)) {
            prefixLength = PREFIX_GET.length();
        }
        if (methodName.startsWith(PREFIX_IS)) {
            prefixLength = PREFIX_IS.length();
        }
        if (prefixLength == 0) {
            return;
        }
        String propertyName = NameUtils.decapitalize(methodName.substring(prefixLength));
        if (SimpleBeanInfo.isInvalidProperty(propertyName)) {
            return;
        }
        Class<?> propertyType = theMethod.getReturnType();
        if (propertyType == null || propertyType == Void.TYPE) {
            return;
        }
        if (prefixLength == 2 && propertyType != Boolean.TYPE) {
            return;
        }
        Class<?>[] paramTypes = theMethod.getParameterTypes();
        if (paramTypes.length > 1 || paramTypes.length == 1 && paramTypes[0] != Integer.TYPE) {
            return;
        }
        HashMap table = propertyTable.computeIfAbsent(propertyName, k -> new HashMap());
        ArrayList<Method> getters = (ArrayList<Method>)table.get(STR_GETTERS);
        if (getters == null) {
            getters = new ArrayList<Method>();
            table.put(STR_GETTERS, getters);
        }
        getters.add(theMethod);
    }

    private static void introspectSet(Method theMethod, HashMap<String, HashMap> propertyTable) {
        String methodName = theMethod.getName();
        if (methodName == null) {
            return;
        }
        Class<?> returnType = theMethod.getReturnType();
        if (returnType != Void.TYPE) {
            return;
        }
        if (!methodName.startsWith(PREFIX_SET)) {
            return;
        }
        String propertyName = NameUtils.decapitalize(methodName.substring(PREFIX_SET.length()));
        if (SimpleBeanInfo.isInvalidProperty(propertyName)) {
            return;
        }
        Class<?>[] paramTypes = theMethod.getParameterTypes();
        if (paramTypes.length == 0 || paramTypes.length > 1) {
            return;
        }
        HashMap table = propertyTable.computeIfAbsent(propertyName, k -> new HashMap());
        ArrayList setters = (ArrayList)table.computeIfAbsent(STR_SETTERS, k -> new ArrayList());
        setters.add(theMethod);
    }

    private static Method[] introspectMethods(Class<?> beanClass) {
        Object[] basicMethods = beanClass.getMethods();
        if (ArrayUtils.isEmpty(basicMethods)) {
            return null;
        }
        ArrayList<Object> methodList = new ArrayList<Object>(basicMethods.length);
        for (Object basicMethod : basicMethods) {
            if (((Method)basicMethod).getDeclaringClass() == Object.class) break;
            int modifiers = ((Method)basicMethod).getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || ((Method)basicMethod).isBridge() || ((Method)basicMethod).isSynthetic() || ((Method)basicMethod).getName().indexOf(36) != -1) continue;
            methodList.add(basicMethod);
        }
        int methodCount = methodList.size();
        Method[] theMethods = null;
        if (methodCount > 0) {
            theMethods = new Method[methodCount];
            theMethods = methodList.toArray(theMethods);
        }
        return theMethods;
    }

    private void fixGetSet(HashMap<String, HashMap> propertyTable) {
        if (propertyTable == null) {
            return;
        }
        for (Map.Entry<String, HashMap> entry : propertyTable.entrySet()) {
            HashMap table = entry.getValue();
            ArrayList getters = (ArrayList)table.get(STR_GETTERS);
            ArrayList setters = (ArrayList)table.get(STR_SETTERS);
            Object normalGetter = null;
            Method normalSetter = null;
            Class<?> normalPropType = null;
            if (getters == null) {
                getters = new ArrayList();
            }
            if (setters == null) {
                setters = new ArrayList();
            }
            for (Object getter : getters) {
                Class<?>[] paramTypes = ((Method)getter).getParameterTypes();
                String methodName = ((Method)getter).getName();
                if (paramTypes != null && paramTypes.length != 0 || normalGetter != null && !methodName.startsWith(PREFIX_IS)) continue;
                normalGetter = getter;
            }
            if (normalGetter != null) {
                Object getter;
                Class<?> propertyType = ((Method)normalGetter).getReturnType();
                getter = setters.iterator();
                while (getter.hasNext()) {
                    Method setter = (Method)getter.next();
                    if (setter.getParameterTypes().length != 1 || !propertyType.equals(setter.getParameterTypes()[0])) continue;
                    normalSetter = setter;
                    break;
                }
            } else {
                for (Method setter : setters) {
                    if (setter.getParameterTypes().length != 1) continue;
                    normalSetter = setter;
                }
            }
            if (normalGetter != null) {
                normalPropType = ((Method)normalGetter).getReturnType();
            } else if (normalSetter != null) {
                normalPropType = normalSetter.getParameterTypes()[0];
            }
            if (normalGetter != null && normalSetter != null) {
                table.put(STR_NORMAL, STR_VALID);
                table.put("normalget", normalGetter);
                table.put("normalset", normalSetter);
                table.put("normalPropertyType", normalPropType);
                continue;
            }
            if (normalGetter != null || normalSetter != null) {
                table.put(STR_NORMAL, STR_VALID);
                table.put("normalget", normalGetter);
                table.put("normalset", normalSetter);
                table.put("normalPropertyType", normalPropType);
                continue;
            }
            table.put(STR_NORMAL, STR_INVALID);
        }
    }

    private static boolean isInvalidProperty(String propertyName) {
        return propertyName == null || propertyName.length() == 0 || EXCLUDED_PROPERTIES.contains(propertyName);
    }
}

