/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u000e\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSealedSupertypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkGlobalDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "checkLocalDeclaration", "checkers"})
public final class FirSealedSupertypeChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final FirSealedSupertypeChecker INSTANCE = new FirSealedSupertypeChecker();

    private FirSealedSupertypeChecker() {
    }

    @Override
    public void check(@NotNull FirMemberDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (declaration2 instanceof FirClass) {
            if (FirDeclarationUtilKt.getClassId((FirClass)((Object)declaration2)).isLocal()) {
                this.checkLocalDeclaration((FirClass)((Object)declaration2), context2, reporter);
            } else {
                this.checkGlobalDeclaration((FirClass)((Object)declaration2), context2, reporter);
            }
        } else if (declaration2 instanceof FirProperty) {
            FirClass firClass;
            FirExpression $this$safeAs$iv = ((FirProperty)declaration2).getInitializer();
            boolean $i$f$safeAs = false;
            FirExpression firExpression2 = $this$safeAs$iv;
            if (!(firExpression2 instanceof FirClass)) {
                firExpression2 = null;
            }
            if ((firClass = (FirClass)((Object)firExpression2)) == null) {
                return;
            }
            FirClass initializer2 = firClass;
            this.checkLocalDeclaration(initializer2, context2, reporter);
        }
    }

    private final void checkGlobalDeclaration(FirClass<?> declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirTypeRef it : declaration2.getSuperTypeRefs()) {
            FirRegularClass fir;
            FirRegularClass firRegularClass;
            ClassId classId;
            ClassId classId2 = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(it));
            if (classId2 == null || (classId = classId2).isLocal()) continue;
            FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName(classId);
            FirClassLikeDeclaration $this$safeAs$iv = firClassLikeSymbol == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir();
            boolean $i$f$safeAs = false;
            FirClassLikeDeclaration firClassLikeDeclaration = $this$safeAs$iv;
            if (!(firClassLikeDeclaration instanceof FirRegularClass)) {
                firClassLikeDeclaration = null;
            }
            if ((firRegularClass = (FirRegularClass)firClassLikeDeclaration) == null || (fir = firRegularClass).getStatus().getModality() != Modality.SEALED || Intrinsics.areEqual(FirDeclarationUtilKt.getClassId(declaration2).getPackageFqName(), FirDeclarationUtilKt.getClassId(fir).getPackageFqName())) continue;
            DiagnosticReporterKt.reportOn(reporter, it.getSource(), FirErrors.INSTANCE.getSEALED_SUPERTYPE(), context2);
        }
    }

    private final void checkLocalDeclaration(FirClass<?> declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirTypeRef it : declaration2.getSuperTypeRefs()) {
            FirRegularClass fir;
            FirRegularClass firRegularClass;
            ClassId classId;
            ClassId classId2 = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(it));
            if (classId2 == null || (classId = classId2).isLocal()) continue;
            FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName(classId);
            FirClassLikeDeclaration $this$safeAs$iv = firClassLikeSymbol == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir();
            boolean $i$f$safeAs = false;
            FirClassLikeDeclaration firClassLikeDeclaration = $this$safeAs$iv;
            if (!(firClassLikeDeclaration instanceof FirRegularClass)) {
                firClassLikeDeclaration = null;
            }
            if ((firRegularClass = (FirRegularClass)firClassLikeDeclaration) == null || (fir = firRegularClass).getStatus().getModality() != Modality.SEALED) continue;
            DiagnosticReporterKt.reportOn(reporter, it.getSource(), FirErrors.INSTANCE.getSEALED_SUPERTYPE_IN_LOCAL_CLASS(), context2);
            return;
        }
    }
}

