/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.osmand.Collator;
import net.osmand.OsmAndCollator;
import net.osmand.data.LatLon;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.sf.junidecode.Junidecode;

public abstract class MapObject
implements Comparable<MapObject> {
    protected String name = null;
    protected String enName = null;
    protected Map<String, String> names = null;
    protected LatLon location = null;
    protected int fileOffset = 0;
    protected Long id = null;

    public void setId(Long id2) {
        this.id = id2;
    }

    public Long getId() {
        if (this.id != null) {
            return this.id;
        }
        return null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setName(String lang, String name) {
        if (this.names == null) {
            this.names = new HashMap<String, String>();
        }
        this.names.put(lang, name);
    }

    public Map<String, String> getNamesMap(boolean includeEn) {
        if (!includeEn || Algorithms.isEmpty(this.enName)) {
            if (this.names == null) {
                return Collections.emptyMap();
            }
            return this.names;
        }
        HashMap<String, String> mp = new HashMap<String, String>();
        if (this.names != null) {
            mp.putAll(this.names);
        }
        mp.put("en", this.enName);
        return mp;
    }

    public List<String> getAllNames() {
        ArrayList<String> l = new ArrayList<String>();
        if (!Algorithms.isEmpty(this.enName)) {
            l.add(this.enName);
        }
        if (this.names != null) {
            l.addAll(this.names.values());
        }
        return l;
    }

    public void copyNames(MapObject s) {
        if (Algorithms.isEmpty(this.name)) {
            this.name = s.name;
        }
        if (Algorithms.isEmpty(this.enName)) {
            this.enName = s.enName;
        }
        this.copyNames(s.names);
    }

    public void copyNames(Map<String, String> snames) {
        if (snames != null && snames.containsKey("name:en")) {
            this.enName = snames.get("name:en");
        }
        if (snames != null && snames.containsKey("en")) {
            this.enName = snames.get("en");
        }
        if (snames != null) {
            for (Map.Entry<String, String> e : snames.entrySet()) {
                String key = e.getKey();
                if (key.startsWith("name:")) {
                    key = key.substring("name:".length());
                }
                if (this.names == null) {
                    this.names = new HashMap<String, String>();
                }
                if (!Algorithms.isEmpty(this.names.get(key))) continue;
                this.names.put(key, e.getValue());
            }
        }
    }

    public String getName(String lang) {
        return this.getName(lang, false);
    }

    public String getName(String lang, boolean transliterate) {
        if (lang != null) {
            if (lang.equals("en")) {
                return this.getEnName(true);
            }
            if (this.names != null) {
                String nm = this.names.get(lang);
                if (!Algorithms.isEmpty(nm)) {
                    return nm;
                }
                if (transliterate) {
                    return Junidecode.unidecode((String)this.getName());
                }
            }
        }
        return this.getName();
    }

    public String getEnName(boolean transliterate) {
        if (!Algorithms.isEmpty(this.enName)) {
            return this.enName;
        }
        if (!Algorithms.isEmpty(this.getName()) && transliterate) {
            return Junidecode.unidecode((String)this.getName());
        }
        return "";
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public LatLon getLocation() {
        return this.location;
    }

    public void setLocation(double latitude, double longitude) {
        this.location = new LatLon(latitude, longitude);
    }

    @Override
    public int compareTo(MapObject o) {
        return OsmAndCollator.primaryCollator().compare(this.getName(), o.getName());
    }

    public int getFileOffset() {
        return this.fileOffset;
    }

    public void setFileOffset(int fileOffset) {
        this.fileOffset = fileOffset;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.name + "(" + this.id + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapObject other = (MapObject)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public double getDistance(LatLon pCursorPosition) {
        return MapUtils.getDistance(this.getLocation(), pCursorPosition);
    }

    public static class MapObjectComparator
    implements Comparator<MapObject> {
        private final String l;
        Collator collator = OsmAndCollator.primaryCollator();

        public MapObjectComparator(String lang) {
            this.l = lang;
        }

        @Override
        public int compare(MapObject o1, MapObject o2) {
            return this.collator.compare(o1.getName(this.l), o2.getName(this.l));
        }
    }
}

