# This file has been autogenerated by the pywayland scanner

# Copyright 2015 Sean Vig
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from ..wayland import WlPointer
from .zwp_pointer_gesture_pinch_v1 import ZwpPointerGesturePinchV1
from .zwp_pointer_gesture_swipe_v1 import ZwpPointerGestureSwipeV1


class ZwpPointerGesturesV1(Interface):
    """Touchpad gestures

    A global interface to provide semantic touchpad gestures for a given
    pointer.

    Two gestures are currently supported: swipe and pinch. All gestures follow
    a three-stage cycle: begin, update, end and are identified by a unique id.

    Warning! The protocol described in this file is experimental and backward
    incompatible changes may be made. Backward compatible changes may be added
    together with the corresponding interface version bump. Backward
    incompatible changes are done by bumping the version number in the protocol
    and interface names and resetting the interface version. Once the protocol
    is to be declared stable, the 'z' prefix and the version number in the
    protocol and interface names are removed and the interface version number
    is reset.
    """

    name = "zwp_pointer_gestures_v1"
    version = 2


class ZwpPointerGesturesV1Proxy(Proxy):
    interface = ZwpPointerGesturesV1

    @ZwpPointerGesturesV1.request(
        Argument(ArgumentType.NewId, interface=ZwpPointerGestureSwipeV1),
        Argument(ArgumentType.Object, interface=WlPointer),
    )
    def get_swipe_gesture(self, pointer):
        """Get swipe gesture

        Create a swipe gesture object. See the wl_pointer_gesture_swipe
        interface for details.

        :param pointer:
        :type pointer:
            :class:`~pywayland.protocol.wayland.WlPointer`
        :returns:
            :class:`~pywayland.protocol.pointer_gestures_unstable_v1.ZwpPointerGestureSwipeV1`
        """
        id = self._marshal_constructor(0, ZwpPointerGestureSwipeV1, pointer)
        return id

    @ZwpPointerGesturesV1.request(
        Argument(ArgumentType.NewId, interface=ZwpPointerGesturePinchV1),
        Argument(ArgumentType.Object, interface=WlPointer),
    )
    def get_pinch_gesture(self, pointer):
        """Get pinch gesture

        Create a pinch gesture object. See the wl_pointer_gesture_pinch
        interface for details.

        :param pointer:
        :type pointer:
            :class:`~pywayland.protocol.wayland.WlPointer`
        :returns:
            :class:`~pywayland.protocol.pointer_gestures_unstable_v1.ZwpPointerGesturePinchV1`
        """
        id = self._marshal_constructor(1, ZwpPointerGesturePinchV1, pointer)
        return id

    @ZwpPointerGesturesV1.request(version=2)
    def release(self):
        """Destroy the pointer gesture object

        Destroy the pointer gesture object. Swipe and pinch objects created via
        this gesture object remain valid.
        """
        self._marshal(2)
        self._destroy()


class ZwpPointerGesturesV1Resource(Resource):
    interface = ZwpPointerGesturesV1


class ZwpPointerGesturesV1Global(Global):
    interface = ZwpPointerGesturesV1


ZwpPointerGesturesV1._gen_c()
ZwpPointerGesturesV1.proxy_class = ZwpPointerGesturesV1Proxy
ZwpPointerGesturesV1.resource_class = ZwpPointerGesturesV1Resource
ZwpPointerGesturesV1.global_class = ZwpPointerGesturesV1Global
