/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.rules.TestRuleAdapter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestRuleMarkFailure;

public class TestRuleLimitSysouts
extends TestRuleAdapter {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    public static final long DEFAULT_LIMIT = 8192L;
    public static final long DEFAULT_HARD_LIMIT = 0x80000000L;
    public static final int MAX_LIMIT = 0x100000;
    private static final AtomicLong bytesWritten = new AtomicLong();
    private static final PrintStream capturedSystemOut;
    private static final PrintStream capturedSystemErr;
    private static final AtomicLong hardLimit;
    private final TestRuleMarkFailure failureMarker;

    public TestRuleLimitSysouts(TestRuleMarkFailure failureMarker) {
        this.failureMarker = failureMarker;
    }

    protected void before() throws Throwable {
        if (this.isEnforced()) {
            TestRuleLimitSysouts.checkCaptureStreams();
        }
        this.resetCaptureState();
        this.applyClassAnnotations();
    }

    private void applyClassAnnotations() {
        Class target = RandomizedTest.getContext().getTargetClass();
        if (target.isAnnotationPresent(Limit.class)) {
            Limit limitAnn = target.getAnnotation(Limit.class);
            long bytes = limitAnn.bytes();
            if (bytes < 0L || bytes > 0x100000L) {
                throw new AssertionError((Object)("This sysout limit is very high: " + bytes + ". Did you want to use @" + LuceneTestCase.SuppressSysoutChecks.class.getName() + " annotation to avoid sysout checks entirely (this is discouraged)?"));
            }
            hardLimit.set(limitAnn.hardLimit());
        }
    }

    public static void checkCaptureStreams() {
        if (System.out != capturedSystemOut) {
            throw new AssertionError((Object)("Something has changed System.out to: " + System.out.getClass().getName()));
        }
        if (System.err != capturedSystemErr) {
            throw new AssertionError((Object)("Something has changed System.err to: " + System.err.getClass().getName()));
        }
    }

    protected boolean isEnforced() {
        Class target = RandomizedTest.getContext().getTargetClass();
        if (LuceneTestCase.VERBOSE || LuceneTestCase.INFOSTREAM || target.isAnnotationPresent(LuceneTestCase.Monster.class) || target.isAnnotationPresent(LuceneTestCase.SuppressSysoutChecks.class)) {
            return false;
        }
        return target.isAnnotationPresent(Limit.class);
    }

    protected void afterIfSuccessful() throws Throwable {
        if (this.isEnforced()) {
            TestRuleLimitSysouts.checkCaptureStreams();
            capturedSystemOut.flush();
            capturedSystemErr.flush();
            Limit ann = RandomizedTest.getContext().getTargetClass().getAnnotation(Limit.class);
            long limit = ann.bytes();
            long hardLimit = ann.hardLimit();
            long written = bytesWritten.get();
            if (written >= limit && this.failureMarker.wasSuccessful()) {
                throw new AssertionError((Object)String.format(Locale.ENGLISH, "The test or suite printed %d bytes to stdout and stderr, even though the limit was set to %d bytes.%s Increase the limit with @%s, ignore it completely with @%s or run with -Dtests.verbose=true", written, limit, written <= hardLimit ? "" : "Hard limit was enforced so output is truncated.", Limit.class.getSimpleName(), LuceneTestCase.SuppressSysoutChecks.class.getSimpleName()));
            }
        }
    }

    protected void afterAlways(List<Throwable> errors) throws Throwable {
        this.resetCaptureState();
    }

    private void resetCaptureState() {
        capturedSystemOut.flush();
        capturedSystemErr.flush();
        bytesWritten.set(0L);
        hardLimit.set(Integer.MAX_VALUE);
    }

    static {
        PrintStream sout = System.out;
        PrintStream serr = System.err;
        sout.flush();
        serr.flush();
        hardLimit = new AtomicLong(Integer.MAX_VALUE);
        LimitPredicate limitCheck = (before, after) -> {
            long limit = hardLimit.get();
            if (after > limit) {
                if (before < limit) {
                    serr.println("\nNOTE: Hard limit on sysout exceeded, further output truncated.\n");
                    serr.flush();
                }
                throw new IOException("Hard limit on sysout exceeded.");
            }
        };
        String csn = Charset.defaultCharset().name();
        try {
            capturedSystemOut = new PrintStream((OutputStream)new DelegateStream(sout, bytesWritten, limitCheck), true, csn);
            capturedSystemErr = new PrintStream((OutputStream)new DelegateStream(serr, bytesWritten, limitCheck), true, csn);
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
        System.setOut(capturedSystemOut);
        System.setErr(capturedSystemErr);
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Limit {
        public long bytes();

        public long hardLimit() default 0x80000000L;
    }

    static interface LimitPredicate {
        public void check(long var1, long var3) throws IOException;
    }

    static final class DelegateStream
    extends OutputStream {
        private final OutputStream delegate;
        private final LimitPredicate limitPredicate;
        private final AtomicLong bytesCounter;

        public DelegateStream(OutputStream delegate, AtomicLong bytesCounter, LimitPredicate limitPredicate) {
            this.delegate = delegate;
            this.bytesCounter = bytesCounter;
            this.limitPredicate = limitPredicate;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                this.checkLimit(len);
            }
            this.delegate.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.checkLimit(1);
            this.delegate.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        private void checkLimit(int bytes) throws IOException {
            long after = this.bytesCounter.addAndGet(bytes);
            long before = after - (long)bytes;
            this.limitPredicate.check(before, after);
        }
    }
}

