/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelkit;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.api.SC;
import org.jmol.i18n.GT;
import org.jmol.modelkit.ModelKitPopupResourceBundle;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.MeasurementPending;
import org.jmol.modelset.ModelSet;
import org.jmol.popup.JmolGenericPopup;
import org.jmol.popup.PopupResource;
import org.jmol.script.ScriptEval;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.viewer.MouseState;
import org.jmol.viewer.Viewer;

public abstract class ModelKitPopup
extends JmolGenericPopup {
    private boolean hasUnitCell;
    private String[] allOperators;
    private int currentModelIndex = -1;
    private boolean alertedNoEdit;
    private String atomHoverLabel = "C";
    private String bondHoverLabel = GT.$("increase order");
    private String xtalHoverLabel;
    private String activeMenu;
    protected ModelSet lastModelSet;
    private String pickAtomAssignType = "C";
    private String pickBondAssignType = "p";
    private boolean isPickAtomAssignCharge;
    private BS bsHighlight = new BS();
    private int bondIndex = -1;
    private int bondAtomIndex1 = -1;
    private int bondAtomIndex2 = -1;
    private BS bsRotateBranch;
    private int branchAtomIndex;
    private boolean isRotateBond;
    private int[] screenXY = new int[2];
    private Map<String, Object> mkdata = new Hashtable<String, Object>();
    private boolean showSymopInfo = true;
    private boolean addXtalHydrogens = true;
    private boolean clickToSetElement = true;
    private P3 centerPoint;
    private P3 spherePoint;
    private P3 viewOffset;
    private float centerDistance;
    private Object symop;
    private int centerAtomIndex = -1;
    private int secondAtomIndex = -1;
    private int atomIndexSphere = -1;
    private String drawData;
    private String drawScript;
    private int iatom0;
    private static final int MAX_LABEL = 32;
    private static PopupResource bundle = new ModelKitPopupResourceBundle(null, null);
    public static final int STATE_BITS_XTAL = 3;
    public static final int STATE_MOLECULAR = 0;
    public static final int STATE_XTALVIEW = 1;
    public static final int STATE_XTALEDIT = 2;
    public static final int STATE_BITS_SYM_VIEW = 28;
    public static final int STATE_SYM_NONE = 0;
    public static final int STATE_SYM_SHOW = 8;
    public static final int STATE_BITS_SYM_EDIT = 224;
    public static final int STATE_SYM_APPLYLOCAL = 32;
    public static final int STATE_SYM_RETAINLOCAL = 64;
    public static final int STATE_SYM_APPLYFULL = 128;
    public static final int STATE_BITS_UNITCELL = 1792;
    public static final int STATE_UNITCELL_PACKED = 0;
    public static final int STATE_UNITCELL_EXTEND = 256;
    public static final String MODE_OPTIONS = ";view;edit;molecular;";
    public static final String SYMMETRY_OPTIONS = ";none;applylocal;retainlocal;applyfull;";
    public static final String UNITCELL_OPTIONS = ";packed;extend;";
    public static final String BOOLEAN_OPTIONS = ";showsymopinfo;clicktosetelement;addhydrogen;addhydrogens;";
    public static final String SET_OPTIONS = ";element;";
    private static final P3 Pt000 = new P3();
    private int state = 0;
    private float rotationDeg;
    private String lastCenter = "0 0 0";
    private String lastOffset = "0 0 0";

    protected void initialize(Viewer vwr, PopupResource bundle, String title) {
        super.initialize(vwr, bundle, title);
        this.initializeForModel();
    }

    protected PopupResource getBundle(String menu) {
        return bundle;
    }

    public void initializeForModel() {
        this.resetBondFields("init");
        this.allOperators = null;
        this.currentModelIndex = -999;
        this.iatom0 = 0;
        this.secondAtomIndex = -1;
        this.centerAtomIndex = -1;
        this.atomIndexSphere = -1;
        this.spherePoint = null;
        this.centerPoint = null;
        this.hasUnitCell = this.vwr.getCurrentUnitCell() != null;
        this.symop = null;
        this.setDefaultState(this.hasUnitCell ? 1 : 0);
    }

    public void jpiUpdateComputedMenus() {
        this.hasUnitCell = this.vwr.getCurrentUnitCell() != null;
        ((SC)this.htMenus.get("xtalMenu")).setEnabled(this.hasUnitCell);
        boolean isOK = true;
        if (this.vwr.ms != this.lastModelSet) {
            this.lastModelSet = this.vwr.ms;
            isOK = false;
        } else if (this.currentModelIndex == -1 || this.currentModelIndex != this.vwr.am.cmi) {
            isOK = false;
        }
        this.currentModelIndex = Math.max(this.vwr.am.cmi, 0);
        this.iatom0 = this.vwr.ms.am[this.currentModelIndex].firstAtomIndex;
        if (!isOK) {
            this.allOperators = null;
            this.updateOperatorMenu();
        }
        this.updateAllXtalMenuOptions();
    }

    protected void appUpdateForShow() {
        this.jpiUpdateComputedMenus();
    }

    protected void updateOperatorMenu() {
        if (this.allOperators != null) {
            return;
        }
        String data = this.runScriptBuffered("show symop");
        this.allOperators = PT.split(data.trim().replace('\t', ' '), "\n");
        SC menu = (SC)this.htMenus.get("xtalOp!PersistMenu");
        if (menu != null) {
            this.addAllCheckboxItems(menu, this.allOperators);
        }
    }

    private void addAllCheckboxItems(SC menu, String[] labels) {
        this.menuRemoveAll(menu, 0);
        SC subMenu = menu;
        int pt = labels.length > 32 ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < labels.length; ++i) {
            if (pt >= 0 && pt++ % 32 == 0) {
                String id = "mtsymop" + pt + "Menu";
                subMenu = this.menuNewSubMenu(i + 1 + "..." + Math.min(i + 32, labels.length), this.menuGetId(menu) + "." + id);
                this.menuAddSubMenu(menu, subMenu);
                this.htMenus.put(id, subMenu);
                pt = 1;
            }
            if (i == 0) {
                this.menuEnable(this.menuCreateItem(subMenu, GT.$("none"), "draw sym_* delete", null), true);
            }
            String sym = labels[i];
            this.menuEnable(this.menuCreateItem(subMenu, sym, sym, subMenu.getName() + ".mkop_" + (i + 1)), true);
        }
    }

    protected void updateAllXtalMenuOptions() {
        String text = "";
        switch (this.getMKState()) {
            case 0: {
                text = " (not enabled)";
                break;
            }
            case 1: {
                text = " (view)";
                break;
            }
            case 2: {
                text = " (edit)";
            }
        }
        this.setLabel("xtalModePersistMenu", "Crystal Mode: " + text);
        text = this.centerAtomIndex < 0 && this.centerPoint == null ? "(not selected)" : (this.centerAtomIndex >= 0 ? this.vwr.getAtomInfo(this.centerAtomIndex) : this.centerPoint.toString());
        this.setLabel("xtalSelPersistMenu", "Center: " + text);
        text = this.symop == null || this.allOperators == null ? "(no operator selected)" : (this.symop instanceof Integer ? this.allOperators[(Integer)this.symop - 1] : this.symop.toString());
        this.setLabel("operator", text);
        switch (this.getSymEditState()) {
            case 0: {
                text = "do not apply symmetry";
                break;
            }
            case 64: {
                text = "retain local symmetry";
                break;
            }
            case 32: {
                text = "apply local symmetry";
                break;
            }
            case 128: {
                text = "apply full symmetry";
            }
        }
        this.setLabel("xtalEditOptPersistMenu", "Edit option: " + text);
        switch (this.getUnitCellState()) {
            case 0: {
                text = "packed";
                break;
            }
            case 256: {
                text = "unpacked" + (this.viewOffset == null ? "(no view offset)" : "(view offset=" + this.viewOffset + ")");
            }
        }
        this.setLabel("xtalPackingPersistMenu", "Packing: " + text);
    }

    private void setLabel(String key, String label) {
        this.menuSetLabel((SC)this.htMenus.get(key), label);
    }

    public String getActiveMenu() {
        return this.activeMenu;
    }

    public String setActiveMenu(String name) {
        String active;
        String string = name.indexOf("xtalMenu") >= 0 ? "xtalMenu" : (name.indexOf("atomMenu") >= 0 ? "atomMenu" : (active = name.indexOf("bondMenu") >= 0 ? "bondMenu" : null));
        if (active != null) {
            this.activeMenu = active;
            if (active == "xtalMenu" == (this.getMKState() == 0)) {
                this.setMKState(active == "xtalMenu" ? 1 : 0);
            }
            this.vwr.refresh(1, "modelkit");
        }
        return active;
    }

    protected void appUpdateSpecialCheckBoxValue(SC source, String actionCommand, boolean selected) {
        String name = source.getName();
        if (!this.updatingForShow && this.setActiveMenu(name) != null) {
            String text = source.getText();
            if (name.indexOf("Bond") >= 0) {
                this.bondHoverLabel = text;
            } else if (name.indexOf("assignAtom") >= 0) {
                this.atomHoverLabel = text;
            } else if (this.activeMenu == "xtalMenu") {
                this.xtalHoverLabel = this.atomHoverLabel = text;
            }
        }
    }

    private boolean isXtalState() {
        return (this.state & 3) != 0;
    }

    private void setMKState(int bits) {
        this.state = this.state & 0xFFFFFFFC | (this.hasUnitCell ? bits : 0);
    }

    private int getMKState() {
        return this.state & 3;
    }

    private void setSymEdit(int bits) {
        this.state = this.state & 0xFFFFFF1F | bits;
    }

    private int getSymEditState() {
        return this.state & 0xE0;
    }

    private int getViewState() {
        return this.state & 0x1C;
    }

    private void setSymViewState(int bits) {
        this.state = this.state & 0xFFFFFFE3 | bits;
    }

    private int getSymViewState() {
        return this.state & 0x1C;
    }

    private void setUnitCell(int bits) {
        this.state = this.state & 0xFFFFF8FF | bits;
    }

    private int getUnitCellState() {
        return this.state & 0x700;
    }

    public boolean isPickAtomAssignCharge() {
        return this.isPickAtomAssignCharge;
    }

    public Object getProperty(Object data) {
        String key = (data instanceof String ? data : ((Object[])data)[0]).toString();
        Object value = data instanceof String ? null : ((Object[])data)[1];
        return this.setProperty(key, value);
    }

    public synchronized Object setProperty(String name, Object value) {
        if ((name = name.toLowerCase().intern()) == "ismolecular") {
            return this.getMKState() == 0;
        }
        if (name == "hoverlabel") {
            return this.getHoverLabel((Integer)value);
        }
        if (name == "alloperators") {
            return this.allOperators;
        }
        if (name == "data") {
            return this.getData(value == null ? null : value.toString());
        }
        if (name == "invariant") {
            int iatom = value instanceof BS ? ((BS)value).nextSetBit(0) : -1;
            Atom atom = this.vwr.ms.getAtom(iatom);
            if (atom == null) {
                return null;
            }
            return this.vwr.getSymmetryInfo(iatom, null, -1, atom, atom, 1275068418, null, 0.0f, 0, 0);
        }
        if (name == "assignatom") {
            Object[] o = (Object[])value;
            String type = (String)o[0];
            int[] data = (int[])o[1];
            int atomIndex = data[0];
            if (this.isVwrRotateBond()) {
                this.bondAtomIndex1 = atomIndex;
            } else if (!this.processAtomClick(data[0]) && (this.clickToSetElement || this.vwr.ms.getAtom(atomIndex).getElementNumber() == 1)) {
                this.assignAtom(atomIndex, type, data[1] >= 0, data[2] >= 0);
            }
            return null;
        }
        if (name == "bondatomindex") {
            int i = (Integer)value;
            if (i != this.bondAtomIndex2) {
                this.bondAtomIndex1 = i;
            }
            this.bsRotateBranch = null;
            return null;
        }
        if (name == "highlight") {
            this.bsHighlight = value == null ? new BS() : (BS)value;
            return null;
        }
        if (name == "mode") {
            boolean isEdit = "edit".equals(value);
            this.setMKState("view".equals(value) ? 1 : (isEdit ? 2 : 0));
            if (isEdit) {
                this.addXtalHydrogens = false;
            }
            return null;
        }
        if (name == "symmetry") {
            this.setDefaultState(2);
            name = ((String)value).toLowerCase().intern();
            this.setSymEdit(name == "applylocal" ? 32 : (name == "retainlocal" ? 64 : (name == "applyfull" ? 128 : 0)));
            this.showXtalSymmetry();
            return null;
        }
        if (name == "unitcell") {
            boolean isPacked = "packed".equals(value);
            this.setUnitCell(isPacked ? 0 : 256);
            this.viewOffset = isPacked ? Pt000 : null;
            return null;
        }
        if (name == "symop") {
            this.setDefaultState(1);
            if (value != null) {
                this.symop = value;
                this.showSymop(this.symop);
            }
            return this.symop;
        }
        if (name == "center") {
            this.setDefaultState(1);
            P3 centerAtom = (P3)value;
            this.lastCenter = centerAtom.x + " " + centerAtom.y + " " + centerAtom.z;
            this.centerAtomIndex = centerAtom instanceof Atom ? ((Atom)centerAtom).i : -1;
            this.atomIndexSphere = -1;
            this.secondAtomIndex = -1;
            this.processAtomClick(this.centerAtomIndex);
            return null;
        }
        if (name == "scriptassignbond") {
            this.appRunScript("assign bond [{" + value + "}] \"" + this.pickBondAssignType + "\"");
            return null;
        }
        if (name == "assignbond") {
            int[] data = (int[])value;
            return this.assignBond(data[0], (char)data[1]);
        }
        if (name == "atomtype") {
            if (value != null) {
                this.pickAtomAssignType = (String)value;
                this.isPickAtomAssignCharge = this.pickAtomAssignType.equals("pl") || this.pickAtomAssignType.equals("mi");
            }
            return this.pickAtomAssignType;
        }
        if (name == "bondtype") {
            if (value != null) {
                this.pickBondAssignType = ((String)value).substring(0, 1).toLowerCase();
            }
            return this.pickBondAssignType;
        }
        if (name == "bondindex") {
            if (value != null) {
                this.setBondIndex((Integer)value, false);
            }
            return this.bondIndex < 0 ? null : Integer.valueOf(this.bondIndex);
        }
        if (name == "rotatebondindex") {
            if (value != null) {
                this.setBondIndex((Integer)value, true);
            }
            return this.bondIndex < 0 ? null : Integer.valueOf(this.bondIndex);
        }
        if (name == "addhydrogen" || name == "addhydrogens") {
            if (value != null) {
                this.addXtalHydrogens = ModelKitPopup.isTrue(value);
            }
            return this.addXtalHydrogens;
        }
        if (name == "clicktosetelement") {
            if (value != null) {
                this.clickToSetElement = ModelKitPopup.isTrue(value);
            }
            return this.clickToSetElement;
        }
        if (name == "showsymopinfo") {
            if (value != null) {
                this.showSymopInfo = ModelKitPopup.isTrue(value);
            }
            return this.showSymopInfo;
        }
        if (name == "offset") {
            if (value == "none") {
                this.viewOffset = null;
            } else if (value != null) {
                P3 p3 = this.viewOffset = value instanceof P3 ? (P3)value : ModelKitPopup.pointFromTriad(value.toString());
                if (this.viewOffset != null) {
                    this.setSymViewState(8);
                }
            }
            this.showXtalSymmetry();
            return this.viewOffset;
        }
        if (name == "distance") {
            float d;
            this.setDefaultState(2);
            float f = value == null ? Float.NaN : (d = value instanceof Float ? ((Float)value).floatValue() : PT.parseFloat((String)value));
            if (!Float.isNaN(d)) {
                ModelKitPopup.notImplemented("setProperty: distance");
                this.centerDistance = d;
            }
            return Float.valueOf(this.centerDistance);
        }
        if (name == "point") {
            if (value != null) {
                ModelKitPopup.notImplemented("setProperty: point");
                this.setDefaultState(2);
                this.spherePoint = (P3)value;
                this.atomIndexSphere = this.spherePoint instanceof Atom ? ((Atom)this.spherePoint).i : -1;
            }
            return this.spherePoint;
        }
        if (name == "screenxy") {
            if (value != null) {
                this.screenXY = (int[])value;
            }
            return this.screenXY;
        }
        if (name == "addconstraint") {
            ModelKitPopup.notImplemented("setProperty: addConstraint");
        }
        if (name == "removeconstraint") {
            ModelKitPopup.notImplemented("setProperty: removeConstraint");
        }
        if (name == "removeallconstraints") {
            ModelKitPopup.notImplemented("setProperty: removeAllConstraints");
        }
        System.err.println("ModelKitPopup.setProperty? " + name + " " + value);
        return null;
    }

    private static boolean isTrue(Object value) {
        return Boolean.valueOf(value.toString()) == Boolean.TRUE;
    }

    private Object getData(String key) {
        this.addData("centerPoint", this.centerPoint);
        this.addData("centerAtomIndex", this.centerAtomIndex);
        this.addData("secondAtomIndex", this.secondAtomIndex);
        this.addData("symop", this.symop);
        this.addData("offset", this.viewOffset);
        this.addData("drawData", this.drawData);
        this.addData("drawScript", this.drawScript);
        return this.mkdata;
    }

    private void addData(String key, Object value) {
        this.mkdata.put(key, value == null ? "null" : value);
    }

    private boolean processAtomClick(int atomIndex) {
        switch (this.getMKState()) {
            case 0: {
                return this.isVwrRotateBond();
            }
            case 1: {
                this.centerAtomIndex = atomIndex;
                if (this.getSymViewState() == 0) {
                    this.setSymViewState(8);
                }
                this.showXtalSymmetry();
                return true;
            }
            case 2: {
                if (atomIndex == this.centerAtomIndex) {
                    return true;
                }
                ModelKitPopup.notImplemented("edit click");
                return false;
            }
        }
        ModelKitPopup.notImplemented("atom click unknown XTAL state");
        return false;
    }

    private String getHoverLabel(int atomIndex) {
        int state = this.getMKState();
        if (state != 1 && atomIndex >= 0 && !this.vwr.ms.isAtomInLastModel(atomIndex)) {
            return "Only atoms in the last model may be edited.";
        }
        String msg = null;
        block0 : switch (state) {
            case 1: {
                if (this.symop == null) {
                    this.symop = 1;
                }
                msg = "view symop " + this.symop + " for " + this.vwr.getAtomInfo(atomIndex);
                break;
            }
            case 2: {
                msg = "start editing for " + this.vwr.getAtomInfo(atomIndex);
                break;
            }
            case 0: {
                if (this.isRotateBond) {
                    if (atomIndex == this.bondAtomIndex1 || atomIndex == this.bondAtomIndex2) {
                        msg = "rotate branch";
                        this.branchAtomIndex = atomIndex;
                        this.bsRotateBranch = null;
                    } else {
                        msg = "rotate bond";
                        this.bsRotateBranch = null;
                        this.branchAtomIndex = -1;
                    }
                }
                if (this.bondIndex < 0) {
                    if (this.atomHoverLabel.length() <= 2) {
                        msg = this.atomHoverLabel = "Click to change to " + this.atomHoverLabel + " or drag to add " + this.atomHoverLabel;
                        break;
                    }
                    msg = this.atomHoverLabel;
                    this.vwr.highlight(BSUtil.newAndSetBit(atomIndex));
                    break;
                }
                if (msg != null) break;
                switch (this.bsHighlight.cardinality()) {
                    case 0: {
                        this.vwr.highlight(BSUtil.newAndSetBit(atomIndex));
                    }
                    case 1: {
                        msg = this.atomHoverLabel;
                        break block0;
                    }
                    case 2: {
                        msg = this.bondHoverLabel;
                    }
                }
            }
        }
        return msg;
    }

    private void setDefaultState(int mode) {
        if (!this.hasUnitCell) {
            mode = 0;
        }
        if (!this.hasUnitCell || this.isXtalState() != this.hasUnitCell) {
            this.setMKState(mode);
            switch (mode) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.getSymViewState() != 0) break;
                    this.setSymViewState(8);
                    break;
                }
            }
        }
    }

    protected boolean appGetBooleanProperty(String name) {
        if (name.startsWith("mk")) {
            return (Boolean)this.getProperty(name.substring(2));
        }
        return this.vwr.getBooleanProperty(name);
    }

    public String getUnknownCheckBoxScriptToRun(SC item, String name, String what, boolean TF) {
        if (name.startsWith("mk")) {
            this.processMKPropertyItem(name, TF);
            return null;
        }
        String element = this.promptUser(GT.$("Element?"), "");
        if (element == null || Elements.elementNumberFromSymbol(element, true) == 0) {
            return null;
        }
        this.menuSetLabel(item, element);
        item.setActionCommand("assignAtom_" + element + "P!:??");
        this.atomHoverLabel = "Click or click+drag for " + element;
        return "set picking assignAtom_" + element;
    }

    private void processMKPropertyItem(String name, boolean TF) {
        int pt = (name = name.substring(2)).indexOf("_");
        if (pt > 0) {
            this.setProperty(name.substring(0, pt), name.substring(pt + 1));
        } else {
            this.setProperty(name, TF);
        }
    }

    private void showXtalSymmetry() {
        String script = null;
        switch (this.getSymViewState()) {
            case 0: {
                script = "draw * delete";
                break;
            }
            default: {
                P3 offset = null;
                if (this.secondAtomIndex >= 0) {
                    script = "draw ID sym symop " + (this.centerAtomIndex < 0 ? this.centerPoint : " {atomindex=" + this.centerAtomIndex + "}") + " {atomindex=" + this.secondAtomIndex + "}";
                } else {
                    offset = this.viewOffset;
                    if (this.symop == null) {
                        this.symop = 1;
                    }
                    int iatom = this.centerAtomIndex >= 0 ? this.centerAtomIndex : (this.centerPoint != null ? -1 : this.iatom0);
                    script = "draw ID sym symop " + (this.symop == null ? "1" : (this.symop instanceof String ? "'" + this.symop + "'" : PT.toJSON(null, this.symop))) + (iatom < 0 ? this.centerPoint : " {atomindex=" + iatom + "}") + (offset == null ? "" : " offset " + offset);
                }
                this.drawData = this.runScriptBuffered(script);
                this.drawScript = script;
                this.drawData = this.showSymopInfo ? this.drawData.substring(0, this.drawData.indexOf("\n") + 1) : "";
                this.appRunScript(";refresh;set echo top right;echo " + this.drawData.replace('\t', ' '));
            }
        }
    }

    private void assignAtom(int atomIndex, String type, boolean autoBond, boolean addHsAndBond) {
        this.vwr.ms.clearDB(atomIndex);
        if (type == null) {
            type = "C";
        }
        Atom atom = this.vwr.ms.at[atomIndex];
        BS bs = new BS();
        boolean wasH = atom.getElementNumber() == 1;
        int atomicNumber = PT.isUpperCase(type.charAt(0)) ? Elements.elementNumberFromSymbol(type, true) : -1;
        boolean isDelete = false;
        if (atomicNumber > 0) {
            boolean doTaint = atomicNumber > 1 || !addHsAndBond;
            this.vwr.ms.setElement(atom, atomicNumber, doTaint);
            this.vwr.shm.setShapeSizeBs(0, 0, this.vwr.rd, BSUtil.newAndSetBit(atomIndex));
            this.vwr.ms.setAtomName(atomIndex, type + atom.getAtomNumber(), doTaint);
            if (this.vwr.getBoolean(603983903)) {
                this.vwr.ms.am[atom.mi].isModelKit = true;
            }
            if (!this.vwr.ms.am[atom.mi].isModelKit || atomicNumber > 1) {
                this.vwr.ms.taintAtom(atomIndex, 0);
            }
        } else if (type.toLowerCase().equals("pl")) {
            atom.setFormalCharge(atom.getFormalCharge() + 1);
        } else if (type.toLowerCase().equals("mi")) {
            atom.setFormalCharge(atom.getFormalCharge() - 1);
        } else if (type.equals("X")) {
            isDelete = true;
        } else if (!type.equals(".")) {
            return;
        }
        if (!addHsAndBond) {
            return;
        }
        this.vwr.ms.removeUnnecessaryBonds(atom, isDelete);
        float dx = 0.0f;
        if (atom.getCovalentBondCount() == 1) {
            if (wasH) {
                dx = 1.5f;
            } else if (!wasH && atomicNumber == 1) {
                dx = 1.0f;
            }
        }
        if (dx != 0.0f) {
            V3 v = V3.newVsub(atom, this.vwr.ms.at[atom.getBondedAtomIndex(0)]);
            float d = v.length();
            v.normalize();
            v.scale(dx - d);
            this.vwr.ms.setAtomCoordRelative(atomIndex, v.x, v.y, v.z);
        }
        BS bsA = BSUtil.newAndSetBit(atomIndex);
        if (isDelete) {
            this.vwr.deleteAtoms(bsA, false);
        }
        if (atomicNumber != 1 && autoBond) {
            this.vwr.ms.validateBspf(false);
            bs = this.vwr.ms.getAtomsWithinRadius(1.0f, bsA, false, null);
            bs.andNot(bsA);
            if (bs.nextSetBit(0) >= 0) {
                this.vwr.deleteAtoms(bs, false);
            }
            bs = this.vwr.getModelUndeletedAtomsBitSet(atom.mi);
            bs.andNot(this.vwr.ms.getAtomBitsMDa(1612709900, null, new BS()));
            this.vwr.ms.makeConnections2(0.1f, 1.8f, 1, 0x40000050, bsA, bs, null, false, false, 0.0f);
        }
        if (this.addXtalHydrogens) {
            this.vwr.addHydrogens(bsA, 1);
        }
    }

    private BS assignBond(int bondIndex, char type) {
        int bondOrder = type - 48;
        Bond bond = this.vwr.ms.bo[bondIndex];
        this.vwr.ms.clearDB(bond.atom1.i);
        switch (type) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                break;
            }
            case 'm': 
            case 'p': {
                bondOrder = Edge.getBondOrderNumberFromOrder(bond.getCovalentOrder()).charAt(0) - 48 + (type == 'p' ? 1 : -1);
                if (bondOrder > 3) {
                    bondOrder = 1;
                    break;
                }
                if (bondOrder >= 0) break;
                bondOrder = 3;
                break;
            }
            default: {
                return null;
            }
        }
        BS bsAtoms = new BS();
        try {
            if (bondOrder == 0) {
                BS bs = new BS();
                bs.set(bond.index);
                bsAtoms.set(bond.atom1.i);
                bsAtoms.set(bond.atom2.i);
                this.vwr.ms.deleteBonds(bs, false);
            } else {
                bond.setOrder(bondOrder | 0x20000);
                if (bond.atom1.getElementNumber() != 1 && bond.atom2.getElementNumber() != 1) {
                    this.vwr.ms.removeUnnecessaryBonds(bond.atom1, false);
                    this.vwr.ms.removeUnnecessaryBonds(bond.atom2, false);
                }
                bsAtoms.set(bond.atom1.i);
                bsAtoms.set(bond.atom2.i);
            }
        }
        catch (Exception e) {
            Logger.error("Exception in seBondOrder: " + e.toString());
        }
        if (type != '0' && this.addXtalHydrogens) {
            this.vwr.addHydrogens(bsAtoms, 1);
        }
        return bsAtoms;
    }

    private boolean isVwrRotateBond() {
        return this.vwr.acm.getBondPickingMode() == 34;
    }

    public int getRotateBondIndex() {
        return this.getMKState() == 0 && this.isRotateBond ? this.bondIndex : -1;
    }

    private void resetBondFields(String where) {
        this.bsRotateBranch = null;
        this.bondAtomIndex2 = -1;
        this.bondAtomIndex1 = -1;
        this.branchAtomIndex = -1;
    }

    private void setBondIndex(int index, boolean isRotate) {
        boolean haveBond;
        if (!isRotate && this.isVwrRotateBond()) {
            this.vwr.setModelKitRotateBondIndex(index);
            return;
        }
        boolean bl = haveBond = this.bondIndex >= 0;
        if (!haveBond && index < 0) {
            return;
        }
        if (index < 0) {
            this.resetBondFields("setbondindex<0");
            return;
        }
        this.bsRotateBranch = null;
        this.branchAtomIndex = -1;
        this.bondIndex = index;
        this.isRotateBond = isRotate;
        this.bondAtomIndex1 = this.vwr.ms.bo[index].getAtomIndex1();
        this.bondAtomIndex2 = this.vwr.ms.bo[index].getAtomIndex2();
        this.setActiveMenu("bondMenu");
    }

    public void actionRotateBond(int deltaX, int deltaY, int x, int y, boolean forceFull) {
        Atom atomFix;
        Atom atomMove;
        if (this.bondIndex < 0) {
            return;
        }
        BS bsBranch = this.bsRotateBranch;
        ModelSet ms = this.vwr.ms;
        if (forceFull) {
            bsBranch = null;
            this.branchAtomIndex = -1;
        }
        if (bsBranch == null) {
            Bond b = ms.bo[this.bondIndex];
            atomMove = this.branchAtomIndex == b.atom1.i ? b.atom1 : b.atom2;
            atomFix = atomMove == b.atom1 ? b.atom2 : b.atom1;
            this.vwr.undoMoveActionClear(atomFix.i, 2, true);
            if (this.branchAtomIndex >= 0) {
                bsBranch = this.vwr.getBranchBitSet(atomMove.i, atomFix.i, true);
            }
            if (bsBranch != null) {
                int n = 0;
                int i = atomFix.bonds.length;
                while (--i >= 0) {
                    if (!bsBranch.get(atomFix.getBondedAtomIndex(i)) || ++n != 2) continue;
                    bsBranch = null;
                    break;
                }
            }
            if (bsBranch == null) {
                bsBranch = ms.getMoleculeBitSetForAtom(atomFix.i);
            }
            this.bsRotateBranch = bsBranch;
            this.bondAtomIndex1 = atomFix.i;
            this.bondAtomIndex2 = atomMove.i;
        } else {
            atomFix = ms.at[this.bondAtomIndex1];
            atomMove = ms.at[this.bondAtomIndex2];
        }
        V3 v1 = V3.new3(atomMove.sX - atomFix.sX, atomMove.sY - atomFix.sY, 0.0f);
        V3 v2 = V3.new3(deltaX, deltaY, 0.0f);
        v1.cross(v1, v2);
        float degrees = (float)(v1.z > 0.0f ? 1 : -1) * v2.length();
        BS bs = BSUtil.copy(bsBranch);
        bs.andNot(this.vwr.slm.getMotionFixedAtoms());
        this.vwr.rotateAboutPointsInternal(null, atomFix, atomMove, 0.0f, degrees, false, bs, null, null, null, null);
    }

    public void menuFocusCallback(String name, String actionCommand, boolean gained) {
        if (gained && !this.processSymop(name, true)) {
            this.setActiveMenu(name);
        }
    }

    public void menuClickCallback(SC source, String script) {
        this.doMenuClickCallbackMK(source, script);
    }

    public void doMenuClickCallbackMK(SC source, String script) {
        if (this.processSymop(source.getName(), false)) {
            return;
        }
        if (script.equals("clearQPersist")) {
            for (SC item : this.htCheckbox.values()) {
                if (item.getActionCommand().indexOf(":??") < 0) continue;
                this.menuSetLabel(item, "??");
                item.setActionCommand("_??P!:");
                item.setSelected(false);
            }
            this.appRunScript("set picking assignAtom_C");
            return;
        }
        this.doMenuClickCallback(source, script);
    }

    protected String getScriptForCallback(SC source, String id, String script) {
        if (script.startsWith("mk")) {
            this.processXtalClick(id, script);
            script = null;
        }
        return script;
    }

    private void processXtalClick(String id, String action) {
        if (this.processSymop(id, false)) {
            return;
        }
        if ((action = action.intern()).startsWith("mkmode_")) {
            if (!this.alertedNoEdit && action == "mkmode_edit") {
                this.alertedNoEdit = true;
                this.vwr.alert("ModelKit xtal edit has not been implemented");
                return;
            }
            this.processModeClick(action);
        } else if (action.startsWith("mksel_")) {
            this.processSelClick(action);
        } else if (action.startsWith("mkselop_")) {
            this.processSelOpClick(action);
        } else if (action.startsWith("mksymmetry_")) {
            this.processSymClick(action);
        } else if (action.startsWith("mkunitcell_")) {
            this.processUCClick(action);
        } else {
            ModelKitPopup.notImplemented("XTAL click " + action);
        }
        this.updateAllXtalMenuOptions();
    }

    private void processSelOpClick(String action) {
        this.secondAtomIndex = -1;
        if (action == "mkselop_addoffset") {
            String pos = this.promptUser("Enter i j k for an offset for viewing the operator - leave blank to clear", this.lastOffset);
            if (pos == null) {
                return;
            }
            this.lastOffset = pos;
            if (pos.length() == 0 || pos == "none") {
                this.setProperty("offset", "none");
                return;
            }
            P3 p = ModelKitPopup.pointFromTriad(pos);
            if (p == null) {
                this.processSelOpClick(action);
            } else {
                this.setProperty("offset", p);
            }
        } else if (action == "mkselop_atom2") {
            ModelKitPopup.notImplemented(action);
        }
    }

    private boolean processSymop(String id, boolean isFocus) {
        int pt = id.indexOf(".mkop_");
        if (pt >= 0) {
            Object op = this.symop;
            this.symop = Integer.valueOf(id.substring(pt + 6));
            this.showSymop(this.symop);
            if (isFocus) {
                this.symop = op;
            }
            return true;
        }
        return false;
    }

    private void showSymop(Object symop) {
        this.secondAtomIndex = -1;
        this.symop = symop;
        this.showXtalSymmetry();
    }

    private void processModeClick(String action) {
        this.processMKPropertyItem(action, false);
    }

    private void processSelClick(String action) {
        if (action == "mksel_atom") {
            this.centerPoint = null;
            this.centerAtomIndex = -1;
            this.secondAtomIndex = -1;
        } else if (action == "mksel_position") {
            String pos = this.promptUser("Enter three fractional coordinates", this.lastCenter);
            if (pos == null) {
                return;
            }
            this.lastCenter = pos;
            P3 p = ModelKitPopup.pointFromTriad(pos);
            if (p == null) {
                this.processSelClick(action);
                return;
            }
            this.centerAtomIndex = -2147483647;
            this.centerPoint = p;
            this.showXtalSymmetry();
        }
    }

    private void processSymClick(String action) {
        if (action == "mksymmetry_none") {
            this.setSymEdit(0);
        } else {
            this.processMKPropertyItem(action, false);
        }
    }

    private void processUCClick(String action) {
        this.processMKPropertyItem(action, false);
        this.showXtalSymmetry();
    }

    public boolean handleDragAtom(MouseState pressed, MouseState dragged, int[] countPlusIndices) {
        switch (this.getMKState()) {
            case 0: {
                return false;
            }
            case 2: {
                if (countPlusIndices[0] > 2) {
                    return true;
                }
                ModelKitPopup.notImplemented("drag atom for XTAL edit");
                break;
            }
            case 1: {
                if (this.getSymViewState() == 0) {
                    this.setSymViewState(8);
                }
                switch (countPlusIndices[0]) {
                    case 1: {
                        this.centerAtomIndex = countPlusIndices[1];
                        this.secondAtomIndex = -1;
                        break;
                    }
                    case 2: {
                        this.centerAtomIndex = countPlusIndices[1];
                        this.secondAtomIndex = countPlusIndices[2];
                    }
                }
                this.showXtalSymmetry();
                return true;
            }
        }
        return true;
    }

    private static P3 pointFromTriad(String pos) {
        float[] a = PT.parseFloatArray(PT.replaceAllCharacters(pos, "{,}", " "));
        return a.length == 3 && !Float.isNaN(a[2]) ? P3.new3(a[0], a[1], a[2]) : null;
    }

    private static void notImplemented(String action) {
        System.err.println("ModelKitPopup.notImplemented(" + action + ")");
    }

    private String promptUser(String msg, String def) {
        return this.vwr.prompt(msg, def, null, false);
    }

    private String runScriptBuffered(String script) {
        SB sb = new SB();
        try {
            ((ScriptEval)this.vwr.eval).runBufferedSafely(script, sb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public boolean handleAssignNew(MouseState pressed, MouseState dragged, MeasurementPending mp, int dragAtomIndex) {
        boolean inRange = pressed.inRange(10, dragged.x, dragged.y);
        if (inRange) {
            dragged.x = pressed.x;
            dragged.y = pressed.y;
        }
        if (this.handleDragAtom(pressed, dragged, mp.countPlusIndices)) {
            return true;
        }
        boolean isCharge = this.isPickAtomAssignCharge;
        String atomType = this.pickAtomAssignType;
        if (mp.count == 2) {
            this.vwr.undoMoveActionClear(-1, 4146, true);
            this.appRunScript("assign connect " + mp.getMeasurementScript(" ", false));
        } else {
            if (atomType.equals("Xx")) {
                return false;
            }
            if (inRange) {
                String s = "assign atom ({" + dragAtomIndex + "}) \"" + atomType + "\"";
                if (isCharge) {
                    s = s + ";{atomindex=" + dragAtomIndex + "}.label='%C'; ";
                    this.vwr.undoMoveActionClear(dragAtomIndex, 4, true);
                } else {
                    this.vwr.undoMoveActionClear(-1, 4146, true);
                }
                this.appRunScript(s);
            } else if (!isCharge) {
                this.vwr.undoMoveActionClear(-1, 4146, true);
                Atom a = this.vwr.ms.at[dragAtomIndex];
                if (a.getElementNumber() == 1) {
                    this.vwr.assignAtom(dragAtomIndex, "X", null);
                } else {
                    int x = dragged.x;
                    int y = dragged.y;
                    if (this.vwr.antialiased) {
                        x <<= 1;
                        y <<= 1;
                    }
                    P3 ptNew = P3.new3(x, y, a.sZ);
                    this.vwr.tm.unTransformPoint(ptNew, ptNew);
                    this.vwr.assignAtom(dragAtomIndex, atomType, ptNew);
                }
            }
        }
        return true;
    }
}

