// SDB-CGEN V1.8.0
// gcc -DMAIN=1 m68k.c ; ./a.out > m68k.h
#include <ctype.h>
#include <stdio.h>
#include <string.h>

struct kv { const char *name; const char *value; };
static struct kv kvs[] = {
  {"abcd","add decimal with extend"}, 
  {"add","add"}, 
  {"adda","add address"}, 
  {"addi","add immediate"}, 
  {"addq","add quick"}, 
  {"addx","add with extend"}, 
  {"and","logical and"}, 
  {"andi","logical and immediate"}, 
  {"asl","arithmetic shift left"}, 
  {"asr","arithmetic shift  right"}, 
  {"bcc","branch conditionally"}, 
  {"bchg","test bit and change"}, 
  {"bclr","test bit and clear"}, 
  {"bfchg","test bit field and change"}, 
  {"bfclr","test bit field and clear"}, 
  {"bfexts","signed bit field extract"}, 
  {"bfextu","unsigned bit field extract"}, 
  {"bfffo","bit field find first one"}, 
  {"bfins","bit field insert"}, 
  {"bfset","test bit field and set"}, 
  {"bftst","test bit field"}, 
  {"bgnd","enter background mode"}, 
  {"bkpt","breakpoint"}, 
  {"bra","branch"}, 
  {"bset","test bit and set"}, 
  {"bsr","branch to subroutine"}, 
  {"btst","test bit"}, 
  {"callm","call module"}, 
  {"cas","compare and swap operands"}, 
  {"cas2","compare and swap dual operands"}, 
  {"chk","check register against bound"}, 
  {"chk2","check register against upper and lower bounds"}, 
  {"cinv","invalidate cache entries"}, 
  {"clr","clear"}, 
  {"cmp","compare"}, 
  {"cmp2","compare register against upper and lower bounds"}, 
  {"cmpa","compare address"}, 
  {"cmpi","compare immediate"}, 
  {"cmpm","compare memory to memory"}, 
  {"cpbcc","branch on coprocessor condition"}, 
  {"cpdbcc","test coprocessor condition decrement and branch"}, 
  {"cpgen","coprocessor general function"}, 
  {"cprestore","coprocessor restore function"}, 
  {"cpsave","coprocessor save function"}, 
  {"cpscc","set on coprocessor condition"}, 
  {"cptracpcc","trap on coprocessor condition"}, 
  {"cptrapcc","trap on coprocessor condition"}, 
  {"cpush","push then invalidate cache entries"}, 
  {"dbcc","test condition, decrement and branch"}, 
  {"divs","signed divide"}, 
  {"divsl","signed divide"}, 
  {"divu","unsigned divide"}, 
  {"divul","unsigned divide"}, 
  {"eor","logical exclusive-or"}, 
  {"eori","logical exclusive-or immediate"}, 
  {"exg","exchange registers"}, 
  {"ext","sign extend"}, 
  {"extb","sign extend"}, 
  {"fabs","floating-point absolute value"}, 
  {"facos","floating-point arc cosine"}, 
  {"fadd","floating-point add"}, 
  {"fasin","floating-point arc sine"}, 
  {"fatan","floating-point arc tangent"}, 
  {"fatanh","floating-point hyperbolic arc tangent"}, 
  {"fbcc","floating-point branch"}, 
  {"fcmp","floating-point compare"}, 
  {"fcos","floating-point cosine"}, 
  {"fcosh","floating-point hyperbolic cosine"}, 
  {"fdabs","floating-point absolute value double precision"}, 
  {"fdadd","floating-point add double precision"}, 
  {"fdbcc","floating-point decrement and branch"}, 
  {"fddiv","floating-point divide double precision"}, 
  {"fdfabs","floating-point absolute value double precision"}, 
  {"fdiv","floating-point divide"}, 
  {"fdmove","move floating-point register single"}, 
  {"fdmul","floating-point multiply double precision"}, 
  {"fdneg","floating-point negate double precision"}, 
  {"fdsqrt","floating-point square root double precision"}, 
  {"fdsub","floating-point subtract double precision"}, 
  {"fetox","floating-point ex"}, 
  {"fetoxm","floating-point ex -1"}, 
  {"fgetexp","floating-point get exponent"}, 
  {"fgetman","floating-point get mantissa"}, 
  {"fint","floating-point integer part"}, 
  {"fintrz","floating-point integer part, round-to-zero"}, 
  {"flog10","floating-point log10"}, 
  {"flog2","floating-point log2"}, 
  {"flogn","floating-point loge"}, 
  {"flognp","floating-point loge (x + 1)"}, 
  {"fmod","floating-point modulo remainder"}, 
  {"fmove","move floating-point register"}, 
  {"fmovecr","move constant rom"}, 
  {"fmovem","move multiple floating-point registers"}, 
  {"fmul","floating-point multiply"}, 
  {"fneg","floating-point negate"}, 
  {"fnop","floating-point no operation"}, 
  {"frem","ieee remainder"}, 
  {"frestore","restore floating-point internal state"}, 
  {"fsabs","floating-point absolute value single precision"}, 
  {"fsadd","floating-point add single"}, 
  {"fsave","save floating-point internal state"}, 
  {"fscale","floating-point scale exponent"}, 
  {"fscc","floating-point set according to condition"}, 
  {"fsdiv","floating-point divide simple precision"}, 
  {"fsfabs","floating-point absolute value single precision"}, 
  {"fsgldiv","single-precision divide"}, 
  {"fsglmul","single-precision multiply"}, 
  {"fsin","sine"}, 
  {"fsincos","simultaneous sine and cosine"}, 
  {"fsinh","hyperbolic sine"}, 
  {"fsmove","move floating-point register double precision"}, 
  {"fsmul","floating-point multiply single precision"}, 
  {"fsneg","floating-point negate single precision"}, 
  {"fsqrt","floating-point square root"}, 
  {"fssqrt","floating-point square root single precision"}, 
  {"fssub","floating-point subtract single precision"}, 
  {"fsub","floating-point subtract"}, 
  {"ftan","tangent"}, 
  {"ftanh","hyperbolic tangent"}, 
  {"ftentox","floating-point 10x"}, 
  {"ftrapcc","floating-point trap on condition"}, 
  {"ftst","floating-point test"}, 
  {"ftwotox","floating-point 2x"}, 
  {"illegal","take illegal instruction trap"}, 
  {"jmp","jump"}, 
  {"jsr","jump to subroutine"}, 
  {"lea","load effective address"}, 
  {"link","link and allocate"}, 
  {"lpstop","low-power stop"}, 
  {"lsl","logical shift left"}, 
  {"lsr","logical shift right"}, 
  {"move","move"}, 
  {"move16","16-byte block move"}, 
  {"movea","move address"}, 
  {"movec","move control register"}, 
  {"movem","move multiple registers"}, 
  {"movep","move peripheral"}, 
  {"moveq","move quick"}, 
  {"moves","move address space"}, 
  {"muls","signed multiply"}, 
  {"mulu","unsigned multiply"}, 
  {"nbcd","negate decimal with extend"}, 
  {"neg","negate"}, 
  {"negx","negate with extend"}, 
  {"nop","no operation"}, 
  {"not","logical complement"}, 
  {"or","logical inclusive-or"}, 
  {"ori","logical inclusive-or immediate"}, 
  {"pack","pack bcd"}, 
  {"pbcc","branch on pmmu condition"}, 
  {"pdbcc","test, decrement, and branch on pmmu condition"}, 
  {"pea","push effective address"}, 
  {"pflush","flush entry(ies) in the atcs"}, 
  {"pflush*","invalidate entries in the atc"}, 
  {"pflusha","flush entry(ies) in the atcs"}, 
  {"pflusha*","invalidate all entries in the atc"}, 
  {"pflushr","flush entry(ies) in the atcs and rpt entries"}, 
  {"pflushs","flush entry(ies) in the atcs"}, 
  {"pload","load an entry into the atc"}, 
  {"pload*","load an entry into the atc"}, 
  {"pmove","move pmmu register"}, 
  {"prestore","pmmu restore function"}, 
  {"psave","pmmu save function"}, 
  {"pscc","set on pmmu condition"}, 
  {"ptest","test a logical address"}, 
  {"ptrapcc","trap on pmmu condition"}, 
  {"pvalid","validate a pointer"}, 
  {"reset","reset external devices"}, 
  {"rol","rotate left"}, 
  {"ror","rotate right"}, 
  {"roxl","rotate with extend left"}, 
  {"roxr","rotate with extend right"}, 
  {"rtd","return and deallocate"}, 
  {"rte","return from exception"}, 
  {"rtm","return from module"}, 
  {"rtr","return and restore"}, 
  {"rts","return from subroutine"}, 
  {"sbcd","subtract decimal with extend"}, 
  {"scc","set conditionally"}, 
  {"stop","stop"}, 
  {"sub","subtract"}, 
  {"suba","subtract address"}, 
  {"subi","subtract immediate"}, 
  {"subq","subtract quick"}, 
  {"subx","subtract with extend"}, 
  {"swap","swap register words"}, 
  {"tas","test operand and set"}, 
  {"tbls","unsigned table lookup with interpolate"}, 
  {"tblsn","signed table lookup with interpolate"}, 
  {"tblu","unsigned table lookup with interpolate"}, 
  {"tblun","unsigned table lookup with interpolate"}, 
  {"trap","trap"}, 
  {"trapcc","trap conditionally"}, 
  {"trapv","trap on overflow"}, 
  {"tst","test operand"}, 
  {"unlk","unlink"}, 
  {"unpk","unpack bcd"}, 
  {NULL, NULL}
};
// 0x475b58
// TODO
typedef int (*GperfForeachCallback)(void *user, const char *k, const char *v);
int gperf_m68k_foreach(GperfForeachCallback cb, void *user) {
  int i = 0; while (kvs[i].name) {
  cb (user, kvs[i].name, kvs[i].value);
  i++;}
  return 0;
}
const char *gperf_m68k_get(const char *s) {
  int i = 0; while (kvs[i].name) {
  if (!strcmp (s, kvs[i].name)) return kvs[i].value;
  i++;}
  return NULL;
}
#define sdb_hash_c_m68k(x,y) gperf_m68k_hash(x)
const unsigned int gperf_m68k_hash(const char *s) {
  int sum = strlen (s);
  while (*s) { sum += *s; s++; }
  return sum;
}
struct {const char *name;void *get;void *hash;void *foreach;} gperf_m68k = {
  .name = "m68k",
  .get = &gperf_m68k_get,
  .hash = &gperf_m68k_hash,
  .foreach = &gperf_m68k_foreach
};

#if MAIN
int main () {
	const char *s = ((char*(*)(char*))gperf_m68k.get)("foo");
	printf ("%s\n", s);
}
#endif
