/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.type;

import io.micronaut.core.type.Argument;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public interface TypeVariableResolver {
    default public Map<String, Argument<?>> getTypeVariables() {
        return Collections.emptyMap();
    }

    default public Argument[] getTypeParameters() {
        Collection<Argument<?>> values = this.getTypeVariables().values();
        return values.toArray(Argument.ZERO_ARGUMENTS);
    }

    default public Optional<Argument<?>> getFirstTypeVariable() {
        return this.getTypeVariables().values().stream().findFirst();
    }

    default public Optional<Argument<?>> getTypeVariable(String name) {
        Argument<?> argument = this.getTypeVariables().get(name);
        return argument != null ? Optional.of(argument) : Optional.empty();
    }
}

