/*
 * Decompiled with CFR 0.152.
 */
package grails.web.mapping;

import grails.web.http.HttpHeaders;
import grails.web.mapping.LinkGenerator;
import grails.web.mapping.mvc.RedirectEventListener;
import grails.web.mapping.mvc.exceptions.CannotRedirectException;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.RequestDataValueProcessor;

public class ResponseRedirector
implements GroovyObject {
    public static final String ARGUMENT_PERMANENT = "permanent";
    public static final String ARGUMENT_ABSOLUTE = "absolute";
    public static final String GRAILS_REDIRECT_ISSUED = "org.grails.REDIRECT_ISSUED";
    private static final String BLANK = "";
    private static final String KEEP_PARAMS_WHEN_REDIRECT = "keepParamsWhenRedirect";
    private LinkGenerator linkGenerator;
    private Collection<RedirectEventListener> redirectListeners;
    private RequestDataValueProcessor requestDataValueProcessor;
    private boolean useJessionId;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Log log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ResponseRedirector(LinkGenerator linkGenerator) {
        LinkGenerator linkGenerator2;
        MetaClass metaClass;
        boolean bl;
        List list;
        this.redirectListeners = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.useJessionId = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Assert.notNull((Object)linkGenerator, (String)"Argument [linkGenerator] cannot be null");
        this.linkGenerator = linkGenerator2 = linkGenerator;
    }

    public void redirect(Map arguments) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        HttpServletRequest request = webRequest.getCurrentRequest();
        HttpServletResponse response = webRequest.getCurrentResponse();
        this.redirect(request, response, arguments);
    }

    public void redirect(HttpServletRequest request, HttpServletResponse response, Map arguments) {
        if (DefaultTypeTransformation.booleanUnbox((Object)request.getAttribute(GRAILS_REDIRECT_ISSUED))) {
            throw (Throwable)((Object)new CannotRedirectException("Cannot issue a redirect(..) here. A previous call to redirect(..) has already redirected the response."));
        }
        if (response.isCommitted()) {
            throw (Throwable)((Object)new CannotRedirectException("Cannot issue a redirect(..) here. The response has already been committed either by another redirect or by directly writing to the response."));
        }
        boolean permanent = false;
        Object permanentArgument = arguments.get(ARGUMENT_PERMANENT);
        if (permanentArgument instanceof String) {
            Boolean bl = Boolean.valueOf(ShortTypeHandling.castToString(permanentArgument));
            permanent = DefaultTypeTransformation.booleanUnbox((Object)bl);
        } else {
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)Boolean.TRUE, permanentArgument);
            permanent = bl;
        }
        LinkedHashMap<String, Object> namedParameters = new LinkedHashMap<String, Object>(arguments);
        namedParameters.put(LinkGenerator.ATTRIBUTE_CONTEXT_PATH, BLANK);
        boolean absolute = false;
        Object absoluteArgument = arguments.get(ARGUMENT_ABSOLUTE);
        if (absoluteArgument instanceof String) {
            Boolean bl = Boolean.valueOf(ShortTypeHandling.castToString(absoluteArgument));
            absolute = DefaultTypeTransformation.booleanUnbox((Object)bl);
        } else {
            boolean bl;
            absolute = bl = absoluteArgument == null ? true : ScriptBytecodeAdapter.compareEqual((Object)Boolean.TRUE, absoluteArgument);
        }
        Boolean bl = Boolean.valueOf(DefaultGroovyMethods.toString(arguments.get(KEEP_PARAMS_WHEN_REDIRECT)));
        if (bl == null ? false : bl) {
            GrailsWebRequest webRequest = GrailsWebRequest.lookup((HttpServletRequest)request);
            if (DefaultTypeTransformation.booleanUnbox((Object)webRequest.getOriginalParams())) {
                Map map = (Map)ScriptBytecodeAdapter.castToType(arguments.get(LinkGenerator.ATTRIBUTE_PARAMS), Map.class);
                Map configuredParams = DefaultTypeTransformation.booleanUnbox((Object)map) ? map : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                namedParameters.put(LinkGenerator.ATTRIBUTE_PARAMS, DefaultGroovyMethods.plus((Map)configuredParams, (Map)webRequest.getOriginalParams()));
            }
        }
        this.redirectResponse(this.linkGenerator.getServerBaseURL(), this.linkGenerator.link(namedParameters), request, response, permanent, absolute);
    }

    private void redirectResponse(String serverBaseURL, String actualUri, HttpServletRequest request, HttpServletResponse response, boolean permanent, boolean absolute) {
        String string;
        String string2;
        if (log.isDebugEnabled()) {
            Object v1;
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug((Object)new GStringImpl(new Object[]{actualUri}, new String[]{"Method [redirect] forwarding request to [", "]"}));
                v0 = null;
            } else {
                v0 = null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)new GStringImpl(new Object[]{response}, new String[]{"Executing redirect with response [", "]"}));
                v1 = null;
            } else {
                v1 = null;
            }
        }
        String processedActualUri = this.processedUrl(actualUri, request);
        String redirectURI = null;
        redirectURI = absolute ? (string2 = processedActualUri.contains("://") ? processedActualUri : StringGroovyMethods.plus((String)serverBaseURL, (CharSequence)processedActualUri)) : (string = processedActualUri);
        String redirectUrl = this.useJessionId ? response.encodeRedirectURL(redirectURI) : redirectURI;
        int status = permanent ? HttpServletResponse.SC_MOVED_PERMANENTLY : HttpServletResponse.SC_MOVED_TEMPORARILY;
        int n = status;
        response.setStatus(n);
        response.setHeader(HttpHeaders.LOCATION, redirectUrl);
        if (DefaultTypeTransformation.booleanUnbox(this.redirectListeners)) {
            RedirectEventListener redirectEventListener2 = null;
            for (RedirectEventListener redirectEventListener2 : this.redirectListeners) {
                redirectEventListener2.responseRedirected(redirectUrl);
            }
        }
        request.setAttribute(GRAILS_REDIRECT_ISSUED, (Object)processedActualUri);
    }

    private String processedUrl(String link, HttpServletRequest request) {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.requestDataValueProcessor)) {
            String string;
            link = string = this.requestDataValueProcessor.processUrl(request, link);
        }
        return link;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ResponseRedirector.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public void redirect() {
        this.redirect(Collections.emptyMap());
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Log log;
        ResponseRedirector.log = log = LogFactory.getLog((String)"grails.web.mapping.ResponseRedirector");
    }

    @Generated
    public LinkGenerator getLinkGenerator() {
        return this.linkGenerator;
    }

    @Generated
    public void setLinkGenerator(LinkGenerator linkGenerator) {
        this.linkGenerator = linkGenerator;
    }

    @Generated
    public Collection<RedirectEventListener> getRedirectListeners() {
        return this.redirectListeners;
    }

    @Generated
    public void setRedirectListeners(Collection<RedirectEventListener> collection) {
        this.redirectListeners = collection;
    }

    @Generated
    public RequestDataValueProcessor getRequestDataValueProcessor() {
        return this.requestDataValueProcessor;
    }

    @Generated
    public void setRequestDataValueProcessor(RequestDataValueProcessor requestDataValueProcessor) {
        this.requestDataValueProcessor = requestDataValueProcessor;
    }

    @Generated
    public boolean getUseJessionId() {
        return this.useJessionId;
    }

    @Generated
    public boolean isUseJessionId() {
        return this.useJessionId;
    }

    @Generated
    public void setUseJessionId(boolean bl) {
        this.useJessionId = bl;
    }
}

