/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sf.sdedit.util.CollectionState;

public class TableModelAdapter
implements TableModel,
CollectionState.CollectionStateChangeListener {
    private Object[][] data;
    private Object[] rawData;
    private String[] columns;
    private Class<?>[] classes;
    private List<TableModelListener> listeners;
    private CollectionState collectionState;
    private RowExpansion rowExpansion;
    private RowEditor rowEditor;
    private Object master;
    public static final RowExpansion DEFAULT_ROW_EXPANSION = new RowExpansion(){

        @Override
        public Object[] expand(Object row) {
            if (row instanceof Object[]) {
                return (Object[])row;
            }
            return ((Collection)row).toArray();
        }
    };

    public TableModelAdapter(String[] columns, Class<?>[] classes, RowExpansion rowExpansion, RowEditor rowEditor) {
        this.columns = columns;
        this.classes = classes;
        this.listeners = new LinkedList<TableModelListener>();
        this.collectionState = new CollectionState();
        this.collectionState.addListener(this);
        this.rowExpansion = rowExpansion;
        this.rowEditor = rowEditor;
    }

    public TableModelAdapter(String[] columns, Class<?>[] classes) {
        this(columns, classes, null, null);
    }

    public void setMaster(Object master) {
        this.master = master;
    }

    public Object getMaster() {
        return this.master;
    }

    public Object getRawDataAt(int i) {
        return this.rawData[i];
    }

    public void setRowExpansion(RowExpansion rowExpansion) {
        this.rowExpansion = rowExpansion;
    }

    public void setRowEditor(RowEditor rowEditor) {
        this.rowEditor = rowEditor;
    }

    private Object[] expand(Object row) {
        if (this.rowExpansion == null) {
            return new Object[]{row};
        }
        return this.rowExpansion.expand(row);
    }

    public void setData(Collection<?> data) {
        this.rawData = data.toArray();
        this.data = new Object[data.size()][this.columns.length];
        int i = 0;
        for (Object row : this.rawData) {
            Object[] expanded = this.expand(row);
            for (int j = 0; j < expanded.length; ++j) {
                this.data[i][j] = expanded[j];
            }
            ++i;
        }
        this.collectionState.update(data);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.classes[columnIndex];
    }

    @Override
    public int getColumnCount() {
        return this.classes.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data[rowIndex][columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.rowEditor != null && this.rowEditor.isEditable(this.rawData[rowIndex], columnIndex);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.rowEditor.setValue(this.rawData[rowIndex], columnIndex, value);
        this.data[rowIndex] = this.rowExpansion.expand(this.rawData[rowIndex]);
    }

    @Override
    public void itemsAdded(int[] indices) {
        TableModelEvent tme = new TableModelEvent(this, indices[0], indices[indices.length - 1], -1, 1);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(tme);
        }
    }

    @Override
    public void itemsChanged(int[] indices) {
        for (TableModelListener listener : this.listeners) {
            for (int i : indices) {
                TableModelEvent tme = new TableModelEvent(this, i, i, -1, 0);
                listener.tableChanged(tme);
            }
        }
    }

    @Override
    public void itemsRemoved(int[] indices) {
        TableModelEvent tme = new TableModelEvent(this, indices[0], indices[indices.length - 1], -1, -1);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(tme);
        }
    }

    public static interface RowEditor {
        public boolean isEditable(Object var1, int var2);

        public void setValue(Object var1, int var2, Object var3);
    }

    public static interface RowExpansion {
        public Object[] expand(Object var1);
    }
}

