/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.octree;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gephi.graph.api.Node;
import org.gephi.lib.gleem.linalg.Vec3f;
import org.gephi.visualization.GraphLimits;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.GraphDrawable;
import org.gephi.visualization.model.edge.EdgeModel;
import org.gephi.visualization.model.node.NodeModel;
import org.gephi.visualization.octree.Octant;

public class Octree {
    protected static final int NULL_ID = -1;
    protected GraphLimits limits;
    private GraphDrawable drawable;
    protected VizController vizController;
    protected final int maxDepth;
    protected final int size;
    protected final Octant root;
    protected final IntSortedSet garbageQueue;
    protected Octant[] leaves = new Octant[0];
    protected int leavesCount;
    protected int length = 0;
    protected int visibleLeaves;
    protected List<Octant> selectedLeaves;
    protected final OctantIterator nodeIterator;
    protected final SelectableIterator selectableIterator;
    protected final EdgeIterator edgeIterator;

    public Octree(int maxDepth, int size) {
        this.garbageQueue = new IntRBTreeSet();
        this.maxDepth = maxDepth;
        this.size = size;
        this.selectedLeaves = new ArrayList<Octant>();
        this.nodeIterator = new OctantIterator();
        this.edgeIterator = new EdgeIterator(null);
        this.selectableIterator = new SelectableIterator();
        float dis = (float)size / (float)Math.pow(2.0, this.maxDepth + 1);
        this.root = new Octant(0, dis, dis, dis, size);
    }

    public void initArchitecture() {
        this.drawable = VizController.getInstance().getDrawable();
        this.limits = VizController.getInstance().getLimits();
        this.vizController = VizController.getInstance();
    }

    public void addNode(NodeModel node) {
        if (node.getOctant() != null) {
            throw new RuntimeException("Can't add a node to two octants");
        }
        Octant octant = this.root;
        int depth = octant.depth;
        this.clampPosition(node);
        while (depth < this.maxDepth) {
            if (octant.children == null) {
                this.subdivide(octant);
            }
            int index = node.octreePosition(octant.posX, octant.posY, octant.posZ, octant.size);
            octant = octant.children[index];
            depth = octant.depth;
        }
        if (octant.isEmpty()) {
            this.addLeaf(octant);
        }
        octant.addNode(node);
        node.setOctant(octant);
    }

    public void removeNode(NodeModel node) {
        Octant octant = node.getOctant();
        octant.removeNode(node);
        if (octant.isEmpty()) {
            this.removeLeaf(octant);
        }
        node.setOctant(null);
    }

    public boolean repositionNodes() {
        ArrayList<NodeModel> movedNodes = new ArrayList<NodeModel>();
        for (int i = 0; i < this.length; ++i) {
            Octant leaf = this.leaves[i];
            if (leaf == null) continue;
            int l = leaf.nodesLength;
            NodeModel[] nodes = leaf.nodes;
            for (int j = 0; j < l; ++j) {
                NodeModel node = nodes[j];
                if (node == null || node.isInOctreeLeaf(leaf)) continue;
                this.removeNode(node);
                movedNodes.add(node);
            }
        }
        if (!movedNodes.isEmpty()) {
            for (NodeModel node : movedNodes) {
                this.addNode(node);
            }
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.leavesCount == 0;
    }

    public void clear() {
        for (int i = 0; i < this.length; ++i) {
            Octant leaf = this.leaves[i];
            if (leaf == null) continue;
            leaf.clear();
        }
        this.leaves = new Octant[0];
        this.leavesCount = 0;
        this.length = 0;
        this.garbageQueue.clear();
        this.selectedLeaves.clear();
        this.visibleLeaves = 0;
    }

    public Iterator<NodeModel> getNodeIterator() {
        this.nodeIterator.reset();
        return this.nodeIterator;
    }

    public Iterator<NodeModel> getSelectableNodeIterator() {
        this.selectableIterator.reset();
        return this.selectableIterator;
    }

    public Iterator<EdgeModel> getEdgeIterator() {
        this.nodeIterator.reset();
        this.edgeIterator.reset(this.nodeIterator);
        return this.edgeIterator;
    }

    protected int addLeaf(Octant octant) {
        int id;
        if (!this.garbageQueue.isEmpty()) {
            id = this.garbageQueue.firstInt();
            this.garbageQueue.remove(id);
        } else {
            id = this.length++;
            this.ensureArraySize(id);
        }
        this.leaves[id] = octant;
        ++this.leavesCount;
        octant.leafId = id;
        return id;
    }

    protected void removeLeaf(Octant octant) {
        int id = octant.leafId;
        this.leaves[id] = null;
        --this.leavesCount;
        this.garbageQueue.add(id);
        octant.leafId = -1;
    }

    private void ensureArraySize(int index) {
        if (index >= this.leaves.length) {
            Octant[] newArray = new Octant[index + 1];
            System.arraycopy(this.leaves, 0, newArray, 0, this.leaves.length);
            this.leaves = newArray;
        }
    }

    private void subdivide(Octant octant) {
        float quantum = octant.size / 4.0f;
        float newSize = octant.size / 2.0f;
        float posX = octant.posX;
        float posY = octant.posY;
        float posZ = octant.posZ;
        int depth = octant.depth;
        Octant o1 = new Octant(depth + 1, posX + quantum, posY + quantum, posZ - quantum, newSize);
        Octant o2 = new Octant(depth + 1, posX - quantum, posY + quantum, posZ - quantum, newSize);
        Octant o3 = new Octant(depth + 1, posX + quantum, posY + quantum, posZ + quantum, newSize);
        Octant o4 = new Octant(depth + 1, posX - quantum, posY + quantum, posZ + quantum, newSize);
        Octant o5 = new Octant(depth + 1, posX + quantum, posY - quantum, posZ - quantum, newSize);
        Octant o6 = new Octant(depth + 1, posX - quantum, posY - quantum, posZ - quantum, newSize);
        Octant o7 = new Octant(depth + 1, posX + quantum, posY - quantum, posZ + quantum, newSize);
        Octant o8 = new Octant(depth + 1, posX - quantum, posY - quantum, posZ + quantum, newSize);
        octant.children = new Octant[]{o1, o2, o3, o4, o5, o6, o7, o8};
    }

    private void clampPosition(NodeModel nodeModel) {
        float quantum = this.size / 2;
        Node node = nodeModel.getNode();
        float x = node.x();
        float y = node.y();
        float z = node.z();
        if (x > this.root.posX + quantum) {
            node.setX(this.root.posX + quantum);
        } else if (x < this.root.posX - quantum) {
            node.setX(this.root.posX - quantum);
        }
        if (y > this.root.posY + quantum) {
            node.setY(this.root.posY + quantum);
        } else if (y < this.root.posY - quantum) {
            node.setY(this.root.posY - quantum);
        }
        if (z > this.root.posZ + quantum) {
            node.setZ(this.root.posZ + quantum);
        } else if (z < this.root.posZ - quantum) {
            node.setZ(this.root.posZ - quantum);
        }
    }

    private void refreshLimits() {
        float minX = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        for (Octant o : this.leaves) {
            if (o == null) continue;
            float octanSize = o.getSize() / 2.0f;
            minX = Math.min(minX, o.getPosX() - octanSize);
            maxX = Math.max(maxX, o.getPosX() + octanSize);
            minY = Math.min(minY, o.getPosY() - octanSize);
            maxY = Math.max(maxY, o.getPosY() + octanSize);
            minZ = Math.min(minZ, o.getPosZ() - octanSize);
            maxZ = Math.max(maxZ, o.getPosZ() + octanSize);
        }
        this.limits.setMinXoctree(minX);
        this.limits.setMaxXoctree(maxX);
        this.limits.setMinYoctree(minY);
        this.limits.setMaxYoctree(maxY);
        this.limits.setMinZoctree(minZ);
        this.limits.setMaxZoctree(maxZ);
    }

    public void updateVisibleOctant(GL2 gl) {
        if (this.leavesCount > 0) {
            this.refreshLimits();
            int capacity = 4 * this.leavesCount;
            IntBuffer hitsBuffer = Buffers.newDirectIntBuffer((int)capacity);
            gl.glSelectBuffer(hitsBuffer.capacity(), hitsBuffer);
            gl.glRenderMode(7170);
            gl.glInitNames();
            gl.glPushName(0);
            gl.glDisable(2884);
            for (Octant n : this.leaves) {
                if (n == null) continue;
                gl.glLoadName(n.leafId);
                n.displayOctant(gl);
                n.visible = false;
            }
            this.visibleLeaves = 0;
            int nbRecords = gl.glRenderMode(7168);
            int depth = Integer.MAX_VALUE;
            int minDepth = -1;
            for (int i = 0; i < nbRecords; ++i) {
                int hit = hitsBuffer.get(i * 4 + 3);
                int minZ = hitsBuffer.get(i * 4 + 1);
                if (minZ < depth) {
                    depth = minZ;
                    minDepth = hit;
                }
                Octant nodeHit = this.leaves[hit];
                nodeHit.visible = true;
                ++this.visibleLeaves;
            }
            if (minDepth != -1) {
                Octant closestOctant = this.leaves[minDepth];
                Vec3f pos = new Vec3f(closestOctant.getPosX(), closestOctant.getPosY(), closestOctant.getPosZ());
                this.limits.setClosestPoint(pos);
            }
        }
    }

    public void updateSelectedOctant(GL2 gl, GLU glu, float[] mousePosition, float[] pickRectangle) {
        if (this.visibleLeaves > 0) {
            int capacity = 4 * this.visibleLeaves;
            IntBuffer hitsBuffer = Buffers.newDirectIntBuffer((int)capacity);
            gl.glSelectBuffer(hitsBuffer.capacity(), hitsBuffer);
            gl.glRenderMode(7170);
            gl.glDisable(2884);
            gl.glInitNames();
            gl.glPushName(0);
            gl.glMatrixMode(5889);
            gl.glPushMatrix();
            gl.glLoadIdentity();
            glu.gluPickMatrix(mousePosition[0], mousePosition[1], pickRectangle[0], pickRectangle[1], this.drawable.getViewport());
            gl.glMultMatrixf(this.drawable.getProjectionMatrix());
            gl.glMatrixMode(5888);
            ArrayList<Octant> visibleLeavesList = new ArrayList<Octant>();
            for (Octant n : this.leaves) {
                if (n == null || !n.visible) continue;
                int i = visibleLeavesList.size() + 1;
                visibleLeavesList.add(n);
                gl.glLoadName(i);
                n.displayOctant(gl);
            }
            gl.glMatrixMode(5889);
            gl.glPopMatrix();
            gl.glMatrixMode(5888);
            gl.glFlush();
            int nbRecords = gl.glRenderMode(7168);
            this.selectedLeaves.clear();
            for (int i = 0; i < nbRecords; ++i) {
                int hit = hitsBuffer.get(i * 4 + 3) - 1;
                Octant nodeHit = (Octant)visibleLeavesList.get(hit);
                this.selectedLeaves.add(nodeHit);
            }
        }
    }

    public void displayOctree(GL2 gl, GLU glu) {
        gl.glDisable(2884);
        gl.glPolygonMode(1032, 6913);
        for (Octant o : this.leaves) {
            if (o == null || !o.visible) continue;
            gl.glColor3f(1.0f, 0.5f, 0.5f);
            o.displayOctant(gl);
            o.displayOctantInfo(gl, glu);
        }
        if (!this.vizController.getVizConfig().isWireFrame()) {
            gl.glPolygonMode(1032, 6914);
        }
    }

    protected final class EdgeIterator
    implements Iterator<EdgeModel> {
        private Iterator<NodeModel> nodeItr;
        private EdgeModel[] edges;
        private int edgeId;
        private int edgeLength;
        private EdgeModel pointer;

        public EdgeIterator(Iterator<NodeModel> nodeIterator) {
            this.nodeItr = nodeIterator;
        }

        @Override
        public boolean hasNext() {
            this.pointer = null;
            while (this.pointer == null) {
                while (this.edgeId < this.edgeLength && this.pointer == null) {
                    this.pointer = this.edges[this.edgeId++];
                }
                if (this.pointer != null) continue;
                if (this.nodeItr != null && this.nodeItr.hasNext()) {
                    NodeModel node = this.nodeItr.next();
                    this.edges = node.getEdges();
                    this.edgeLength = this.edges.length;
                    this.edgeId = 0;
                    continue;
                }
                return false;
            }
            return this.pointer != null;
        }

        @Override
        public EdgeModel next() {
            return this.pointer;
        }

        public void reset(Iterator<NodeModel> nodeIterator) {
            this.nodeItr = nodeIterator;
            this.edges = null;
            this.edgeLength = 0;
            this.edgeId = 0;
            this.pointer = null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    protected final class SelectableIterator
    implements Iterator<NodeModel> {
        private int leavesLength;
        private int leafId;
        private Octant octant;
        private NodeModel[] nodes;
        private int nodesId;
        private int nodesLength;
        private NodeModel pointer;

        public SelectableIterator() {
            this.leavesLength = Octree.this.selectedLeaves.size();
        }

        @Override
        public boolean hasNext() {
            this.pointer = null;
            while (this.pointer == null) {
                while (this.nodesId < this.nodesLength && this.pointer == null) {
                    this.pointer = this.nodes[this.nodesId++];
                }
                if (this.pointer != null) continue;
                this.octant = null;
                while (this.leafId < this.leavesLength && this.octant == null) {
                    this.octant = Octree.this.selectedLeaves.get(this.leafId++);
                }
                if (this.octant == null) {
                    return false;
                }
                this.nodes = this.octant.nodes;
                this.nodesId = 0;
                this.nodesLength = this.octant.nodesLength;
            }
            return this.pointer != null;
        }

        @Override
        public NodeModel next() {
            return this.pointer;
        }

        public void reset() {
            this.leafId = 0;
            this.octant = null;
            this.leavesLength = Octree.this.selectedLeaves.size();
            this.nodes = null;
            this.nodesId = 0;
            this.nodesLength = 0;
            this.pointer = null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    protected final class OctantIterator
    implements Iterator<NodeModel> {
        private int leafId;
        private Octant octant;
        private int leavesLength;
        private NodeModel[] nodes;
        private int nodesId;
        private int nodesLength;
        private NodeModel pointer;

        public OctantIterator() {
            this.leavesLength = Octree.this.leaves.length;
        }

        @Override
        public boolean hasNext() {
            this.pointer = null;
            while (this.pointer == null) {
                while (this.nodesId < this.nodesLength && this.pointer == null) {
                    this.pointer = this.nodes[this.nodesId++];
                }
                if (this.pointer != null) continue;
                this.octant = null;
                while (!(this.leafId >= this.leavesLength || this.octant != null && this.octant.visible)) {
                    this.octant = Octree.this.leaves[this.leafId++];
                }
                if (this.octant == null || !this.octant.visible) {
                    return false;
                }
                this.nodes = this.octant.nodes;
                this.nodesId = 0;
                this.nodesLength = this.octant.nodesLength;
            }
            return this.pointer != null;
        }

        @Override
        public NodeModel next() {
            return this.pointer;
        }

        public void reset() {
            this.leafId = 0;
            this.octant = null;
            this.leavesLength = Octree.this.leaves.length;
            this.nodes = null;
            this.nodesId = 0;
            this.nodesLength = 0;
            this.pointer = null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

