/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.transactions;

import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.grails.datastore.mapping.transactions.Transaction;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionUtils {
    public static boolean isTransactionPresent(Datastore datastore) {
        return TransactionUtils.getTransaction(datastore) != null;
    }

    public static Transaction<?> currentTransaction(Datastore datastore) {
        Transaction<?> transaction = TransactionUtils.getTransaction(datastore);
        if (transaction == null) {
            throw new NoTransactionException("No transaction started.");
        }
        return transaction;
    }

    public static Transaction<?> getTransaction(Datastore datastore) {
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)datastore));
        return sessionHolder == null ? null : sessionHolder.getTransaction();
    }
}

