/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.CoordinateFormatManager;
import org.openstreetmap.josm.data.coor.conversion.DMSCoordinateFormat;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.download.AbstractDownloadSourcePanel;
import org.openstreetmap.josm.gui.download.BookmarkSelection;
import org.openstreetmap.josm.gui.download.BoundingBoxSelection;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.download.DownloadSettings;
import org.openstreetmap.josm.gui.download.DownloadSource;
import org.openstreetmap.josm.gui.download.DownloadSourceListener;
import org.openstreetmap.josm.gui.download.DownloadSourceSizingPolicy;
import org.openstreetmap.josm.gui.download.OSMDownloadSource;
import org.openstreetmap.josm.gui.download.OverpassDownloadSource;
import org.openstreetmap.josm.gui.download.PlaceSelection;
import org.openstreetmap.josm.gui.download.SlippyMapChooser;
import org.openstreetmap.josm.gui.download.TileSelection;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.ImageLabel;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Shortcut;

public class DownloadDialog
extends JDialog {
    private static final IntegerProperty DOWNLOAD_TAB = new IntegerProperty("download.tab", 0);
    private static final StringProperty DOWNLOAD_SOURCE_TAB = new StringProperty("download.source.tab", "osmdownloadpanel");
    private static final BooleanProperty DOWNLOAD_AUTORUN = new BooleanProperty("download.autorun", false);
    private static final BooleanProperty DOWNLOAD_ZOOMTODATA = new BooleanProperty("download.zoomtodata", true);
    private static DownloadDialog instance;
    private static final ListenerList<DownloadSourceListener> downloadSourcesListeners;
    private static final List<DownloadSource<?>> downloadSources;
    protected final transient List<DownloadSelection> downloadSelections = new ArrayList<DownloadSelection>();
    protected final JTabbedPane tpDownloadAreaSelectors = new JTabbedPane();
    protected final DownloadSourceTabs downloadSourcesTab = new DownloadSourceTabs();
    private final ImageLabel latText;
    private final ImageLabel lonText;
    private final ImageLabel bboxText;
    protected JCheckBox cbStartup;
    protected JCheckBox cbZoomToDownloadedData;
    protected SlippyMapChooser slippyMapChooser;
    protected JPanel mainPanel;
    protected DownloadDialogSplitPane dialogSplit;
    protected final transient ExpertToggleAction.ExpertModeChangeListener expertListener;
    protected transient Bounds currentBounds;
    protected boolean canceled;
    protected JButton btnDownload;
    protected JButton btnDownloadNewLayer;
    protected JButton btnCancel;
    protected JButton btnHelp;

    public static synchronized DownloadDialog getInstance() {
        if (instance == null) {
            instance = new DownloadDialog((Component)MainApplication.getMainFrame());
        }
        return instance;
    }

    protected final JPanel buildMainPanel() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.slippyMapChooser = new SlippyMapChooser();
        this.downloadSelections.add(this.slippyMapChooser);
        this.downloadSelections.add(new BookmarkSelection());
        this.downloadSelections.add(new BoundingBoxSelection());
        this.downloadSelections.add(new PlaceSelection());
        this.downloadSelections.add(new TileSelection());
        PluginHandler.addDownloadSelection(this.downloadSelections);
        for (DownloadSelection s : this.downloadSelections) {
            s.addGui(this);
        }
        this.downloadSourcesTab.setMinimumSize(new Dimension(0, 25));
        this.tpDownloadAreaSelectors.setMinimumSize(new Dimension(0, 0));
        this.dialogSplit = new DownloadDialogSplitPane(this.downloadSourcesTab, this.tpDownloadAreaSelectors);
        ChangeListener tabChangedListener = this.getDownloadSourceTabChangeListener();
        tabChangedListener.stateChanged(new ChangeEvent(this.downloadSourcesTab));
        this.downloadSourcesTab.addChangeListener(tabChangedListener);
        this.mainPanel.add((Component)this.dialogSplit, GBC.eol().fill());
        JPanel statusBarPanel = new JPanel(new FlowLayout(0, 5, 0));
        statusBarPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        statusBarPanel.add(this.latText);
        statusBarPanel.add(this.lonText);
        statusBarPanel.add(this.bboxText);
        this.mainPanel.add((Component)statusBarPanel, GBC.eol().fill(2));
        ExpertToggleAction.addVisibilitySwitcher(statusBarPanel);
        this.cbStartup = new JCheckBox(I18n.tr("Open this dialog on startup", new Object[0]));
        this.cbStartup.setToolTipText(I18n.tr("<html>Autostart ''Download from OSM'' dialog every time JOSM is started.<br>You can open it manually from File menu or toolbar.</html>", new Object[0]));
        this.cbStartup.addActionListener(e -> DOWNLOAD_AUTORUN.put(this.cbStartup.isSelected()));
        JLabel iconZoomToDownloadedData = new JLabel(ImageProvider.get("dialogs/autoscale/download", ImageProvider.ImageSizes.SMALLICON));
        this.cbZoomToDownloadedData = new JCheckBox(I18n.tr("Zoom to downloaded data", new Object[0]));
        this.cbZoomToDownloadedData.setToolTipText(I18n.tr("Select to zoom to entire newly downloaded data.", new Object[0]));
        JPanel checkboxPanel = new JPanel(new FlowLayout());
        checkboxPanel.add(this.cbStartup);
        checkboxPanel.add(Box.createHorizontalStrut(6));
        checkboxPanel.add(iconZoomToDownloadedData);
        checkboxPanel.add(this.cbZoomToDownloadedData);
        this.mainPanel.add((Component)checkboxPanel, GBC.eol());
        ExpertToggleAction.addVisibilitySwitcher(this.cbZoomToDownloadedData);
        ExpertToggleAction.addVisibilitySwitcher(iconZoomToDownloadedData);
        JLabel infoLabel = new JLabel(I18n.tr("Use left click&drag to select area, arrows or right mouse button to scroll map, wheel or +/- to zoom.", new Object[0]));
        this.mainPanel.add((Component)infoLabel, GBC.eol().anchor(10).insets(0, 0, 0, 0));
        ExpertToggleAction.addExpertModeChangeListener(isExpert -> infoLabel.setVisible(!isExpert), true);
        return this.mainPanel;
    }

    protected final JPanel buildButtonPanel() {
        this.btnDownload = new JButton(new DownloadAction(false));
        this.btnDownloadNewLayer = new JButton(new DownloadAction(true));
        this.btnCancel = new JButton(new CancelAction());
        this.btnHelp = new JButton(new ContextSensitiveHelpAction(this.getRootPane().getClientProperty("help").toString()));
        JPanel pnl = new JPanel(new FlowLayout());
        pnl.add(this.btnDownload);
        pnl.add(this.btnDownloadNewLayer);
        pnl.add(this.btnCancel);
        pnl.add(this.btnHelp);
        InputMapUtils.enableEnter(this.btnDownload);
        InputMapUtils.enableEnter(this.btnCancel);
        InputMapUtils.addEscapeAction(this.getRootPane(), this.btnCancel.getAction());
        InputMapUtils.enableEnter(this.btnHelp);
        InputMapUtils.addEnterActionWhenAncestor(this.cbStartup, this.btnDownload.getAction());
        InputMapUtils.addEnterActionWhenAncestor(this.cbZoomToDownloadedData, this.btnDownload.getAction());
        InputMapUtils.addCtrlEnterAction(pnl, this.btnDownload.getAction());
        return pnl;
    }

    public DownloadDialog(Component parent) {
        this(parent, HelpUtil.ht("/Action/Download"));
    }

    public DownloadDialog(Component parent, String helpTopic) {
        super((Window)GuiHelper.getFrameForComponent(parent), I18n.tr("Download", new Object[0]), Dialog.ModalityType.DOCUMENT_MODAL);
        LatLon sample = new LatLon(90.0, 180.0);
        DMSCoordinateFormat sampleFormat = DMSCoordinateFormat.INSTANCE;
        Color background = new JPanel().getBackground();
        this.latText = new ImageLabel("lat", null, sampleFormat.latToString(sample).length(), background);
        this.lonText = new ImageLabel("lon", null, sampleFormat.lonToString(sample).length(), background);
        this.bboxText = new ImageLabel("bbox", null, sampleFormat.toString(sample, "").length() * 2, background);
        this.expertListener = this.getExpertModeListenerForDownloadSources();
        HelpUtil.setHelpContext(this.getRootPane(), helpTopic);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildMainPanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.getRootPane().getInputMap(2).put(Shortcut.getPasteKeyStroke(), "checkClipboardContents");
        this.getRootPane().getActionMap().put("checkClipboardContents", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String clip = ClipboardUtils.getClipboardStringContent();
                if (clip == null) {
                    return;
                }
                Bounds b = OsmUrlToBounds.parse(clip);
                if (b != null) {
                    DownloadDialog.this.boundingBoxChanged(new Bounds(b), null);
                }
            }
        });
        this.addWindowListener(new WindowEventHandler());
        ExpertToggleAction.addExpertModeChangeListener(this.expertListener);
        this.restoreSettings();
        if (this.currentBounds == null) {
            this.boundingBoxChanged(null, null);
        }
    }

    public void boundingBoxChanged(Bounds b, DownloadSelection eventSource) {
        this.currentBounds = b;
        for (DownloadSelection downloadSelection : this.downloadSelections) {
            if (downloadSelection == eventSource) continue;
            downloadSelection.setDownloadArea(this.currentBounds);
        }
        for (AbstractDownloadSourcePanel abstractDownloadSourcePanel : this.downloadSourcesTab.getAllPanels()) {
            abstractDownloadSourcePanel.boundingBoxChanged(b);
        }
        this.bboxText.setText(b == null ? "" : String.join((CharSequence)"  ", CoordinateFormatManager.getDefaultFormat().toString(b.getMin(), " "), CoordinateFormatManager.getDefaultFormat().toString(b.getMax(), " ")));
    }

    public void mapCursorChanged(ILatLon latLon) {
        this.latText.setText(CoordinateFormatManager.getDefaultFormat().latToString(latLon));
        this.lonText.setText(CoordinateFormatManager.getDefaultFormat().lonToString(latLon));
    }

    public void startDownload(Bounds b) {
        this.currentBounds = b;
        this.startDownload();
    }

    public void startDownload() {
        this.btnDownload.doClick();
    }

    public boolean isZoomToDownloadedDataRequired() {
        return this.cbZoomToDownloadedData.isSelected();
    }

    public static boolean isAutorunEnabled() {
        return DOWNLOAD_AUTORUN.get();
    }

    public void addDownloadAreaSelector(JPanel selector, String displayName) {
        this.tpDownloadAreaSelectors.add(displayName, selector);
    }

    public boolean addDownloadAreaListener(DownloadSelection selection) {
        return this.downloadSelections.add(selection);
    }

    public boolean removeDownloadAreaListener(DownloadSelection selection) {
        return this.downloadSelections.remove(selection);
    }

    public static <T> void addDownloadSource(DownloadSource<T> downloadSource) {
        if (downloadSources.contains(downloadSource)) {
            throw new JosmRuntimeException("The download source you are trying to add already exists.");
        }
        downloadSources.add(downloadSource);
        downloadSourcesListeners.fireEvent(l -> l.downloadSourceAdded(downloadSource));
    }

    public static boolean removeDownloadSource(DownloadSource<?> downloadSource) {
        if (downloadSources.contains(downloadSource)) {
            return downloadSources.remove(downloadSource);
        }
        return false;
    }

    public final void refreshTileSources() {
        if (this.slippyMapChooser != null) {
            this.slippyMapChooser.refreshTileSources();
        }
    }

    public void rememberSettings() {
        DOWNLOAD_TAB.put(this.tpDownloadAreaSelectors.getSelectedIndex());
        this.downloadSourcesTab.getAllPanels().forEach(AbstractDownloadSourcePanel::rememberSettings);
        this.downloadSourcesTab.getSelectedPanel().ifPresent(panel -> DOWNLOAD_SOURCE_TAB.put(panel.getSimpleName()));
        DOWNLOAD_ZOOMTODATA.put(this.cbZoomToDownloadedData.isSelected());
        if (this.currentBounds != null) {
            Config.getPref().put("osm-download.bounds", this.currentBounds.encodeAsString(";"));
        }
    }

    public void restoreSettings() {
        this.cbStartup.setSelected(DownloadDialog.isAutorunEnabled());
        this.cbZoomToDownloadedData.setSelected(DOWNLOAD_ZOOMTODATA.get());
        try {
            this.tpDownloadAreaSelectors.setSelectedIndex(DOWNLOAD_TAB.get());
        }
        catch (IndexOutOfBoundsException e) {
            Logging.trace(e);
            this.tpDownloadAreaSelectors.setSelectedIndex(0);
        }
        this.downloadSourcesTab.getAllPanels().forEach(AbstractDownloadSourcePanel::restoreSettings);
        this.downloadSourcesTab.setSelected(DOWNLOAD_SOURCE_TAB.get());
        if (MainApplication.isDisplayingMapView()) {
            MapView mv = MainApplication.getMap().mapView;
            this.currentBounds = new Bounds(mv.getLatLon(0, mv.getHeight()), mv.getLatLon(mv.getWidth(), 0));
            this.boundingBoxChanged(this.currentBounds, null);
        } else {
            Bounds bounds = DownloadDialog.getSavedDownloadBounds();
            if (bounds != null) {
                this.currentBounds = bounds;
                this.boundingBoxChanged(this.currentBounds, null);
            }
        }
    }

    public static Bounds getSavedDownloadBounds() {
        String value = Config.getPref().get("osm-download.bounds");
        if (!value.isEmpty()) {
            try {
                return new Bounds(value, ";");
            }
            catch (IllegalArgumentException e) {
                Logging.warn(e);
            }
        }
        return null;
    }

    public static void autostartIfNeeded() {
        if (DownloadDialog.isAutorunEnabled()) {
            MainApplication.getMenu().download.actionPerformed(null);
        }
    }

    public Optional<Bounds> getSelectedDownloadArea() {
        return Optional.ofNullable(this.currentBounds);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.btnDownloadNewLayer.setEnabled(!MainApplication.getLayerManager().getLayersOfType(OsmDataLayer.class).isEmpty());
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), new Dimension(1000, 600))).applySafe(this);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public DownloadSettings getDownloadSettings(boolean newLayer) {
        Component areaSelector = this.tpDownloadAreaSelectors.getSelectedComponent();
        Bounds slippyMapBounds = areaSelector instanceof SlippyMapBBoxChooser ? ((SlippyMapBBoxChooser)areaSelector).getVisibleMapArea() : null;
        return new DownloadSettings(this.currentBounds, slippyMapBounds, newLayer, this.isZoomToDownloadedDataRequired());
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    protected <T> void addNewDownloadSourceTab(DownloadSource<T> downloadSource) {
        this.downloadSourcesTab.addPanel(downloadSource.createPanel(this));
    }

    private ExpertToggleAction.ExpertModeChangeListener getExpertModeListenerForDownloadSources() {
        return this.downloadSourcesTab::updateExpert;
    }

    private ChangeListener getDownloadSourceTabChangeListener() {
        return ec -> this.downloadSourcesTab.getSelectedPanel().ifPresent(panel -> this.dialogSplit.setPolicy(panel.getSizingPolicy()));
    }

    static {
        downloadSourcesListeners = ListenerList.create();
        downloadSources = new ArrayList();
        DownloadDialog.addDownloadSource(new OSMDownloadSource());
        DownloadDialog.addDownloadSource(new OverpassDownloadSource());
    }

    private static class DownloadDialogSplitPane
    extends JSplitPane {
        private DownloadSourceSizingPolicy policy;
        private final JTabbedPane topComponent;
        private boolean heightAdjustedExplicitly;

        DownloadDialogSplitPane(JTabbedPane newTopComponent, Component newBottomComponent) {
            super(0, newTopComponent, newBottomComponent);
            this.topComponent = newTopComponent;
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.revalidate();
                }
            });
            this.addPropertyChangeListener("dividerLocation", e -> {
                this.heightAdjustedExplicitly = true;
            });
        }

        public void setPolicy(DownloadSourceSizingPolicy policy) {
            this.policy = policy;
            super.setDividerLocation(policy.getComponentHeight() + this.computeOffset());
            this.setDividerSize(policy.isHeightAdjustable() ? 10 : 0);
            this.setEnabled(policy.isHeightAdjustable());
        }

        @Override
        public void doLayout() {
            int offset = this.computeOffset();
            if (this.policy.isHeightAdjustable() && this.heightAdjustedExplicitly) {
                this.policy.storeHeight(Math.max(this.getDividerLocation() - offset, 0));
            }
            int maxValidDividerLocation = this.getHeight() > 150 ? this.getHeight() - 40 : this.getHeight();
            super.setDividerLocation(Math.min(this.policy.getComponentHeight() + offset, maxValidDividerLocation));
            super.doLayout();
            this.heightAdjustedExplicitly = false;
        }

        private int computeOffset() {
            Component selectedComponent = this.topComponent.getSelectedComponent();
            return this.topComponent.getHeight() - (selectedComponent == null ? 0 : selectedComponent.getHeight());
        }
    }

    private class DownloadSourceTabs
    extends JTabbedPane
    implements DownloadSourceListener {
        private final List<AbstractDownloadSourcePanel<?>> allPanels = new ArrayList();

        DownloadSourceTabs() {
            downloadSources.forEach(this::downloadSourceAdded);
            downloadSourcesListeners.addListener(this);
        }

        List<AbstractDownloadSourcePanel<?>> getAllPanels() {
            return this.allPanels;
        }

        List<AbstractDownloadSourcePanel<?>> getVisiblePanels() {
            return IntStream.range(0, this.getTabCount()).mapToObj(this::getComponentAt).map(p -> (AbstractDownloadSourcePanel)p).collect(Collectors.toList());
        }

        void setSelected(String simpleName) {
            this.getVisiblePanels().stream().filter(panel -> simpleName.equals(panel.getSimpleName())).findFirst().ifPresent(this::setSelectedComponent);
        }

        void updateExpert(boolean isExpert) {
            this.updateTabs();
        }

        void addPanel(AbstractDownloadSourcePanel<?> panel) {
            this.allPanels.add(panel);
            this.updateTabs();
        }

        private void updateTabs() {
            this.removeAll();
            boolean isExpert = ExpertToggleAction.isExpert();
            this.allPanels.stream().filter(panel -> isExpert || !panel.getDownloadSource().onlyExpert()).forEach(panel -> this.addTab(panel.getDownloadSource().getLabel(), panel.getIcon(), (Component)panel));
        }

        Optional<AbstractDownloadSourcePanel<?>> getSelectedPanel() {
            return Optional.ofNullable((AbstractDownloadSourcePanel)this.getSelectedComponent());
        }

        @Override
        public void insertTab(String title, Icon icon, Component component, String tip, int index) {
            if (!(component instanceof AbstractDownloadSourcePanel)) {
                throw new IllegalArgumentException("Can only add AbstractDownloadSourcePanels");
            }
            super.insertTab(title, icon, component, tip, index);
        }

        @Override
        public void downloadSourceAdded(DownloadSource<?> source) {
            this.addPanel(source.createPanel(DownloadDialog.this));
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            new CancelAction().run();
        }

        @Override
        public void windowActivated(WindowEvent e) {
            DownloadDialog.this.btnDownload.requestFocusInWindow();
        }
    }

    class DownloadAction
    extends AbstractAction {
        final boolean newLayer;

        DownloadAction(boolean newLayer) {
            this.newLayer = newLayer;
            if (!newLayer) {
                this.putValue("Name", I18n.tr("Download", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Click to download the currently selected area", new Object[0]));
                new ImageProvider("download").getResource().attachImageIcon(this);
            } else {
                this.putValue("Name", I18n.tr("Download as new layer", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Click to download the currently selected area into a new data layer", new Object[0]));
                new ImageProvider("download_new_layer").getResource().attachImageIcon(this);
            }
            this.setEnabled(!NetworkManager.isOffline(OnlineResource.OSM_API));
        }

        public void run() {
            DownloadDialog.this.rememberSettings();
            DownloadDialog.this.downloadSourcesTab.getSelectedPanel().ifPresent(panel -> {
                DownloadSettings downloadSettings = DownloadDialog.this.getDownloadSettings(this.newLayer);
                if (panel.checkDownload(downloadSettings)) {
                    DownloadDialog.this.setCanceled(false);
                    DownloadDialog.this.setVisible(false);
                    panel.triggerDownload(downloadSettings);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Click to close the dialog and to abort downloading", new Object[0]));
        }

        public void run() {
            DownloadDialog.this.rememberSettings();
            DownloadDialog.this.setCanceled(true);
            DownloadDialog.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Optional<AbstractDownloadSourcePanel<?>> panel = DownloadDialog.this.downloadSourcesTab.getSelectedPanel();
            this.run();
            panel.ifPresent(AbstractDownloadSourcePanel::checkCancel);
        }
    }
}

