/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.io.ChangesetManagementPanel;
import org.openstreetmap.josm.gui.io.UploadStrategySelectionPanel;
import org.openstreetmap.josm.gui.io.UploadedObjectsSummaryPanel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.UploadStrategySpecification;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.StreamUtils;

public class UploadParameterSummaryPanel
extends JPanel
implements HyperlinkListener,
PropertyChangeListener {
    private transient UploadStrategySpecification spec = new UploadStrategySpecification();
    private int numObjects;
    private JMultilineLabel jepMessage;
    private JLabel lblWarning;
    private transient Changeset selectedChangeset;
    private boolean closeChangesetAfterNextUpload;
    private transient Runnable configHandler;

    public UploadParameterSummaryPanel() {
        this.build();
        this.updateSummary();
    }

    protected String buildChangesetSummary() {
        if (this.selectedChangeset == null || this.selectedChangeset.isNew()) {
            return I18n.tr("Objects are uploaded to a <strong>new changeset</strong>.", new Object[0]);
        }
        return I18n.tr("Objects are uploaded to the <strong>open changeset</strong> {0} with upload comment ''{1}''.", this.selectedChangeset.getId(), this.selectedChangeset.getComment());
    }

    protected String buildChangesetSummary2() {
        if (this.closeChangesetAfterNextUpload) {
            return I18n.tr("The changeset is going to be <strong>closed</strong> after this upload", new Object[0]);
        }
        return I18n.tr("The changeset is <strong>left open</strong> after this upload", new Object[0]);
    }

    protected String buildStrategySummary() {
        int maxChunkSize;
        if (this.spec == null) {
            return "";
        }
        boolean useOneChangeset = true;
        Capabilities capabilities = OsmApi.getOsmApi().getCapabilities();
        int n = maxChunkSize = capabilities != null ? capabilities.getMaxChangesetSize() : -1;
        if (maxChunkSize > 0 && this.numObjects > maxChunkSize) {
            useOneChangeset = false;
        }
        int numRequests = this.spec.getNumRequests(this.numObjects);
        if (useOneChangeset) {
            this.lblWarning.setVisible(false);
            if (numRequests == 0) {
                return I18n.trn("Uploading <strong>{0} object</strong> to <strong>1 changeset</strong>", "Uploading <strong>{0} objects</strong> to <strong>1 changeset</strong>", this.numObjects, this.numObjects);
            }
            if (numRequests == 1) {
                return I18n.trn("Uploading <strong>{0} object</strong> to <strong>1 changeset</strong> using <strong>1 request</strong>", "Uploading <strong>{0} objects</strong> to <strong>1 changeset</strong> using <strong>1 request</strong>", this.numObjects, this.numObjects);
            }
            if (numRequests > 1) {
                return I18n.tr("Uploading <strong>{0} objects</strong> to <strong>1 changeset</strong> using <strong>{1} requests</strong>", this.numObjects, numRequests);
            }
        } else {
            this.lblWarning.setVisible(true);
            if (numRequests == 0) {
                return I18n.tr("{0} objects exceed the max. allowed {1} objects in a changeset on the server ''{2}''. Please <a href=\"urn:changeset-configuration\">configure</a> how to proceed with <strong>multiple changesets</strong>", this.numObjects, maxChunkSize, OsmApi.getOsmApi().getBaseUrl());
            }
            if (numRequests > 1) {
                return I18n.tr("Uploading <strong>{0} objects</strong> to <strong>multiple changesets</strong> using <strong>{1} requests</strong>", this.numObjects, numRequests);
            }
        }
        return "";
    }

    protected void build() {
        this.jepMessage = new JMultilineLabel("");
        this.jepMessage.addHyperlinkListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(I18n.tr("Settings:", new Object[0])));
        this.add((Component)this.jepMessage, "Center");
        this.lblWarning = new JLabel("");
        this.lblWarning.setVisible(false);
        this.lblWarning.setLabelFor(this.jepMessage);
        this.lblWarning.setIcon(ImageProvider.get("warning-small"));
        this.lblWarning.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.lblWarning, "North");
        this.add((Component)pnl, "West");
    }

    public void setConfigurationParameterRequestListener(Runnable handler) {
        this.configHandler = handler;
    }

    public void setUploadStrategySpecification(UploadStrategySpecification spec) {
        this.spec = spec;
        this.updateSummary();
    }

    public void setNumObjects(int numObjects) {
        this.numObjects = numObjects;
        this.updateSummary();
    }

    public void setCloseChangesetAfterNextUpload(boolean value) {
        this.closeChangesetAfterNextUpload = value;
        this.updateSummary();
    }

    protected void updateSummary() {
        String server = Optional.of(OsmApi.getOsmApi().getServerUrl()).filter(url -> !Config.getUrls().getDefaultOsmApiUrl().equals(url)).map(url -> I18n.tr("\u2026 to server: <strong>{0}</strong>", url)).orElse("");
        String html = Stream.of(this.buildChangesetSummary(), this.buildChangesetSummary2(), this.buildStrategySummary(), server).filter(s -> s != null && !s.isEmpty()).collect(StreamUtils.toHtmlList());
        this.jepMessage.setText(html);
        this.validate();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
            String desc = e.getDescription();
            if (desc == null || this.configHandler == null) {
                return;
            }
            if ("urn:changeset-configuration".equals(desc)) {
                this.configHandler.run();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(ChangesetManagementPanel.SELECTED_CHANGESET_PROP)) {
            this.selectedChangeset = (Changeset)evt.getNewValue();
            this.updateSummary();
        } else if (evt.getPropertyName().equals(ChangesetManagementPanel.CLOSE_CHANGESET_AFTER_UPLOAD)) {
            this.closeChangesetAfterNextUpload = (Boolean)evt.getNewValue();
            this.updateSummary();
        } else if (evt.getPropertyName().equals(UploadedObjectsSummaryPanel.NUM_OBJECTS_TO_UPLOAD_PROP)) {
            this.numObjects = (Integer)evt.getNewValue();
            this.updateSummary();
        } else if (evt.getPropertyName().equals(UploadStrategySelectionPanel.UPLOAD_STRATEGY_SPECIFICATION_PROP)) {
            this.spec = (UploadStrategySpecification)evt.getNewValue();
            this.updateSummary();
        }
    }
}

