/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.RestartAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.advanced.AdvancedPreference;
import org.openstreetmap.josm.gui.preferences.audio.AudioPreference;
import org.openstreetmap.josm.gui.preferences.display.ColorPreference;
import org.openstreetmap.josm.gui.preferences.display.DisplayPreference;
import org.openstreetmap.josm.gui.preferences.display.DrawingPreference;
import org.openstreetmap.josm.gui.preferences.display.GPXPreference;
import org.openstreetmap.josm.gui.preferences.display.LafPreference;
import org.openstreetmap.josm.gui.preferences.display.LanguagePreference;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.map.BackupPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreference;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.remotecontrol.RemoteControlPreference;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreference;
import org.openstreetmap.josm.gui.preferences.server.ServerAccessPreference;
import org.openstreetmap.josm.gui.preferences.shortcut.ShortcutPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTagCheckerRulesPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTestsPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public final class PreferenceTabbedPane
extends JTabbedPane
implements ExpertToggleAction.ExpertModeChangeListener,
ChangeListener {
    private final transient List<PreferenceTab> tabs = new ArrayList<PreferenceTab>();
    private static final Collection<PreferenceSettingFactory> SETTINGS_FACTORIES = new LinkedList<PreferenceSettingFactory>();
    private static final PreferenceSettingFactory ADVANCED_PREFERENCE_FACTORY = new AdvancedPreference.Factory();
    private final transient List<PreferenceSetting> settings = new ArrayList<PreferenceSetting>();
    private final transient List<PreferenceSetting> settingsInitialized = new ArrayList<PreferenceSetting>();
    final transient List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();

    public void addValidationListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
    }

    public PreferencePanel createPreferenceTab(TabPreferenceSetting caller) {
        return this.createPreferenceTab(caller, false);
    }

    public PreferencePanel createPreferenceTab(TabPreferenceSetting caller, boolean inScrollPane) {
        PreferencePanel p = new PreferencePanel(Objects.requireNonNull(caller, "caller"));
        this.tabs.add((PreferenceTab)((Object)(inScrollPane ? new PreferenceScrollPane(p) : p)));
        return p;
    }

    private OptionalInt indexOfTab(Predicate<TabPreferenceSetting> predicate) {
        return IntStream.range(0, this.getTabCount()).filter(i -> this.getComponentAt(i) instanceof PreferenceTab && predicate.test(((PreferenceTab)((Object)this.getComponentAt(i))).getTabPreferenceSetting())).findFirst();
    }

    private void selectTabBy(Predicate<TabPreferenceSetting> predicate) {
        this.setSelectedIndex(this.indexOfTab(predicate).orElse(0));
    }

    public void selectTabByName(String name) {
        Objects.requireNonNull(name);
        this.selectTabBy(tps -> Objects.equals(name, tps.getIconName()));
    }

    public void selectTabByPref(Class<? extends TabPreferenceSetting> clazz) {
        this.selectTabBy(clazz::isInstance);
    }

    public boolean selectSubTabByPref(Class<? extends SubPreferenceSetting> clazz) {
        try {
            SubPreferenceSetting sub = this.getSetting(clazz);
            TabPreferenceSetting tab = sub.getTabPreferenceSetting(this);
            this.selectTabBy(tps -> tps.equals(tab));
            return tab.selectSubTab(sub);
        }
        catch (NoSuchElementException ignore) {
            Logging.trace(ignore);
            return false;
        }
    }

    public Pair<Class<? extends TabPreferenceSetting>, Class<? extends SubPreferenceSetting>> getSelectedTab() {
        Component selected = this.getSelectedComponent();
        if (selected instanceof PreferenceTab) {
            TabPreferenceSetting setting = ((PreferenceTab)((Object)selected)).getTabPreferenceSetting();
            return Pair.create(setting.getClass(), setting.getSelectedSubTab());
        }
        return null;
    }

    public DisplayPreference getDisplayPreference() {
        return this.getSetting(DisplayPreference.class);
    }

    public PluginPreference getPluginPreference() {
        return this.getSetting(PluginPreference.class);
    }

    public ImageryPreference getImageryPreference() {
        return this.getSetting(ImageryPreference.class);
    }

    public ShortcutPreference getShortcutPreference() {
        return this.getSetting(ShortcutPreference.class);
    }

    public ServerAccessPreference getServerPreference() {
        return this.getSetting(ServerAccessPreference.class);
    }

    public ValidatorPreference getValidatorPreference() {
        return this.getSetting(ValidatorPreference.class);
    }

    public void savePreferences() {
        PluginPreference preference = this.getPluginPreference();
        if (preference != null) {
            Set<PluginInformation> toDownload = preference.getPluginsScheduledForUpdateOrDownload();
            PluginDownloadTask task = toDownload != null && !toDownload.isEmpty() ? new PluginDownloadTask((Component)this, toDownload, I18n.tr("Download plugins", new Object[0])) : null;
            PluginDownloadAfterTask continuation = new PluginDownloadAfterTask(preference, task, toDownload);
            if (task != null) {
                MainApplication.worker.submit(task);
                MainApplication.worker.submit(() -> GuiHelper.runInEDT(continuation));
            } else {
                continuation.run();
            }
        }
    }

    public PreferenceTabbedPane() {
        super(2, 1);
        super.addMouseWheelListener(new WheelListener(this));
        ExpertToggleAction.addExpertModeChangeListener(this);
    }

    public void buildGui() {
        ArrayList<PreferenceSettingFactory> factories = new ArrayList<PreferenceSettingFactory>(SETTINGS_FACTORIES);
        factories.addAll(PluginHandler.getPreferenceSetting());
        factories.add(ADVANCED_PREFERENCE_FACTORY);
        for (PreferenceSettingFactory factory : factories) {
            if (factory == null) continue;
            PreferenceSetting setting = factory.createPreferenceSetting();
            if (setting instanceof TabPreferenceSetting && ((TabPreferenceSetting)setting).getIconName() == null) {
                Logging.error("Invalid setting (Icon missing): " + setting.getClass().getName());
                setting = null;
            }
            if (setting == null) continue;
            this.settings.add(setting);
        }
        this.addGUITabs(false);
        super.getModel().addChangeListener(this);
    }

    private void addGUITabsForSetting(Icon icon, TabPreferenceSetting tps, int maxWidth) {
        for (PreferenceTab tab : this.tabs) {
            if (!tab.getTabPreferenceSetting().equals(tps)) continue;
            this.insertGUITabsForSetting(icon, tps, tab.getComponent(), this.getTabCount(), maxWidth);
        }
    }

    private int insertGUITabsForSetting(Icon icon, TabPreferenceSetting tps, int index, int maxWidth) {
        int position = index;
        for (PreferenceTab tab : this.tabs) {
            if (!tab.getTabPreferenceSetting().equals(tps)) continue;
            this.insertGUITabsForSetting(icon, tps, tab.getComponent(), position, maxWidth);
            ++position;
        }
        return position - 1;
    }

    private void insertGUITabsForSetting(Icon icon, TabPreferenceSetting tps, Component component, int position, int maxWidth) {
        String title = "Aqua".equals(UIManager.getLookAndFeel().getID()) ? null : PreferenceTabbedPane.htmlTabTitle(tps.getTitle(), maxWidth);
        this.insertTab(title, icon, component, tps.getTooltip(), position);
    }

    private static String htmlTabTitle(String title, int maxWidth) {
        return "<html><div style='padding-left:5px; width:" + maxWidth + "px'>" + title + "</div></html>";
    }

    private void addGUITabs(boolean clear) {
        boolean expert = ExpertToggleAction.isExpert();
        if (clear) {
            this.removeAll();
        }
        int maxWidth = this.computeMaxTabWidth();
        for (PreferenceSetting setting : this.settings) {
            if (setting instanceof TabPreferenceSetting) {
                TabPreferenceSetting tps = (TabPreferenceSetting)setting;
                if (!expert && tps.isExpert()) continue;
                ImageIcon icon = tps.getIcon(ImageProvider.ImageSizes.LARGEICON);
                if (this.settingsInitialized.contains(tps)) {
                    this.addGUITabsForSetting(icon, tps, maxWidth);
                    continue;
                }
                this.insertGUITabsForSetting(icon, tps, new PreferencePanel(tps), this.getTabCount(), maxWidth);
                continue;
            }
            if (setting instanceof SubPreferenceSetting) continue;
            Logging.warn("Ignoring preferences " + setting);
        }
        for (DefaultTabPreferenceSetting tps : Utils.filteredCollection(this.settings, DefaultTabPreferenceSetting.class)) {
            if (!tps.canBeHidden() || Utils.filteredCollection(this.settings, SubPreferenceSetting.class).stream().anyMatch(s -> s.getTabPreferenceSetting(this) == tps)) continue;
            this.indexOfTab(tps::equals).ifPresent(index -> {
                this.remove(index);
                Logging.debug("{0}: hiding empty {1}", this.getClass().getSimpleName(), tps);
            });
        }
        this.setSelectedIndex(-1);
    }

    private int computeMaxTabWidth() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return this.settings.stream().filter(x -> x instanceof TabPreferenceSetting).map(x -> ((TabPreferenceSetting)x).getTitle()).filter(Objects::nonNull).mapToInt(fm::stringWidth).max().orElse(120);
    }

    @Override
    public void expertChanged(boolean isExpert) {
        Component sel = this.getSelectedComponent();
        this.addGUITabs(true);
        int index = -1;
        if (sel != null) {
            index = this.indexOfComponent(sel);
        }
        this.setSelectedIndex(Math.max(index, 0));
    }

    public List<PreferenceSetting> getSettings() {
        return Collections.unmodifiableList(this.settings);
    }

    public <T extends PreferenceSetting> T getSetting(Class<? extends T> clazz) {
        return (T)((PreferenceSetting)Utils.filteredCollection(this.settings, clazz).iterator().next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.getSelectedIndex();
        Component sel = this.getSelectedComponent();
        if (index > -1 && sel instanceof PreferenceTab) {
            Container ancestor;
            PreferenceTab tab = (PreferenceTab)((Object)sel);
            TabPreferenceSetting preferenceSettings = tab.getTabPreferenceSetting();
            if (!this.settingsInitialized.contains(preferenceSettings)) {
                try {
                    this.getModel().removeChangeListener(this);
                    preferenceSettings.addGui(this);
                    for (PreferenceSetting setting : this.settings) {
                        if (!(setting instanceof SubPreferenceSetting)) continue;
                        this.addSubPreferenceSetting(preferenceSettings, (SubPreferenceSetting)setting);
                    }
                    Icon icon = this.getIconAt(index);
                    this.remove(index);
                    if (index <= this.insertGUITabsForSetting(icon, preferenceSettings, index, this.computeMaxTabWidth())) {
                        this.setSelectedIndex(index);
                    }
                }
                catch (SecurityException ex) {
                    Logging.error(ex);
                }
                catch (RuntimeException ex) {
                    BugReportExceptionHandler.handleException(ex);
                }
                finally {
                    this.settingsInitialized.add(preferenceSettings);
                    this.getModel().addChangeListener(this);
                }
            }
            if ((ancestor = this.getTopLevelAncestor()) instanceof PreferenceDialog) {
                ((PreferenceDialog)ancestor).setHelpContext(preferenceSettings.getHelpContext());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubPreferenceSetting(TabPreferenceSetting preferenceSettings, SubPreferenceSetting sps) {
        if (sps.getTabPreferenceSetting(this) == preferenceSettings) {
            try {
                sps.addGui(this);
            }
            catch (SecurityException ex) {
                Logging.error(ex);
            }
            catch (RuntimeException ex) {
                BugReportExceptionHandler.handleException(ex);
            }
            finally {
                this.settingsInitialized.add(sps);
            }
        }
    }

    static {
        SETTINGS_FACTORIES.add(new DisplayPreference.Factory());
        SETTINGS_FACTORIES.add(new DrawingPreference.Factory());
        SETTINGS_FACTORIES.add(new GPXPreference.Factory());
        SETTINGS_FACTORIES.add(new ColorPreference.Factory());
        SETTINGS_FACTORIES.add(new LafPreference.Factory());
        SETTINGS_FACTORIES.add(new LanguagePreference.Factory());
        SETTINGS_FACTORIES.add(new ServerAccessPreference.Factory());
        SETTINGS_FACTORIES.add(new ProxyPreference.Factory());
        SETTINGS_FACTORIES.add(new ProjectionPreference.Factory());
        SETTINGS_FACTORIES.add(new MapPaintPreference.Factory());
        SETTINGS_FACTORIES.add(new TaggingPresetPreference.Factory());
        SETTINGS_FACTORIES.add(new BackupPreference.Factory());
        SETTINGS_FACTORIES.add(new PluginPreference.Factory());
        SETTINGS_FACTORIES.add(MainApplication.getToolbar());
        SETTINGS_FACTORIES.add(new AudioPreference.Factory());
        SETTINGS_FACTORIES.add(new ShortcutPreference.Factory());
        SETTINGS_FACTORIES.add(new ValidatorPreference.Factory());
        SETTINGS_FACTORIES.add(new ValidatorTestsPreference.Factory());
        SETTINGS_FACTORIES.add(new ValidatorTagCheckerRulesPreference.Factory());
        SETTINGS_FACTORIES.add(new RemoteControlPreference.Factory());
        SETTINGS_FACTORIES.add(new ImageryPreference.Factory());
    }

    static final class WheelListener
    implements MouseWheelListener {
        final JTabbedPane tabbedPane;

        WheelListener(JTabbedPane tabbedPane) {
            this.tabbedPane = tabbedPane;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent wev) {
            if (this.tabbedPane.indexAtLocation(wev.getPoint().x, wev.getPoint().y) < 0) {
                return;
            }
            int newTab = Utils.clamp(this.tabbedPane.getSelectedIndex() + wev.getWheelRotation(), 0, this.tabbedPane.getTabCount() - 1);
            this.tabbedPane.setSelectedIndex(newTab);
        }
    }

    public static final class PreferenceScrollPane
    extends JScrollPane
    implements PreferenceTab {
        private final transient TabPreferenceSetting preferenceSetting;

        private PreferenceScrollPane(PreferencePanel preferencePanel) {
            super(preferencePanel.getComponent());
            this.preferenceSetting = preferencePanel.getTabPreferenceSetting();
            GuiHelper.setDefaultIncrement(this);
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public TabPreferenceSetting getTabPreferenceSetting() {
            return this.preferenceSetting;
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }

    public static final class PreferencePanel
    extends JPanel
    implements PreferenceTab {
        private final transient TabPreferenceSetting preferenceSetting;

        private PreferencePanel(TabPreferenceSetting preferenceSetting) {
            super(new GridBagLayout());
            this.preferenceSetting = Objects.requireNonNull(preferenceSetting, "preferenceSetting");
            this.buildPanel();
        }

        private void buildPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel headerPanel = new JPanel(new BorderLayout());
            this.add((Component)headerPanel, GBC.eop().fill(2));
            JLabel label = new JLabel("<html><b>" + this.preferenceSetting.getTitle() + "</b><br><i>" + this.preferenceSetting.getDescription() + "</i></html>");
            label.setFont(label.getFont().deriveFont(0));
            headerPanel.add((Component)label, "Center");
            ImageIcon icon = this.preferenceSetting.getIcon(ImageProvider.ImageSizes.SETTINGS_TAB);
            headerPanel.add((Component)new JLabel(icon), "East");
        }

        @Override
        public TabPreferenceSetting getTabPreferenceSetting() {
            return this.preferenceSetting;
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }

    private static interface PreferenceTab {
        public TabPreferenceSetting getTabPreferenceSetting();

        public Component getComponent();
    }

    @FunctionalInterface
    public static interface ValidationListener {
        public boolean validatePreferences();
    }

    private final class PluginDownloadAfterTask
    implements Runnable {
        private final PluginPreference preference;
        private final PluginDownloadTask task;
        private final Set<PluginInformation> toDownload;

        private PluginDownloadAfterTask(PluginPreference preference, PluginDownloadTask task, Set<PluginInformation> toDownload) {
            this.preference = preference;
            this.task = task;
            this.toDownload = toDownload;
        }

        @Override
        public void run() {
            boolean requiresRestart = false;
            for (PreferenceSetting setting : PreferenceTabbedPane.this.settingsInitialized) {
                if (!setting.ok()) continue;
                requiresRestart = true;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            if (this.task != null && !this.task.isCanceled()) {
                PluginHandler.refreshLocalUpdatedPluginInfo(this.task.getDownloadedPlugins());
                sb.append(PluginPreference.buildDownloadSummary(this.task));
            }
            if (requiresRestart) {
                sb.append(I18n.tr("You have to restart JOSM for some settings to take effect.", new Object[0]));
                sb.append("<br/><br/>");
                sb.append(I18n.tr("Would you like to restart now?", new Object[0]));
            }
            sb.append("</html>");
            if (requiresRestart) {
                HelpAwareOptionPane.ButtonSpec[] options = RestartAction.getButtonSpecs();
                if (0 == HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), sb.toString(), I18n.tr("Restart", new Object[0]), 1, null, options, options[0], null)) {
                    MainApplication.getMenu().restart.actionPerformed(null);
                }
            } else if (this.task != null && !this.task.isCanceled()) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), sb.toString(), I18n.tr("Warning", new Object[0]), 2);
            }
            List<PluginInformation> newPlugins = this.preference.getNewlyActivatedPlugins();
            if (newPlugins != null) {
                boolean removed;
                Collection<PluginInformation> downloadedPlugins = null;
                if (this.task != null && !this.task.isCanceled()) {
                    downloadedPlugins = this.task.getDownloadedPlugins();
                }
                ArrayList<PluginInformation> toLoad = new ArrayList<PluginInformation>();
                for (PluginInformation pi : newPlugins) {
                    if (this.toDownload.contains(pi) && downloadedPlugins != null && !downloadedPlugins.contains(pi) || !pi.canloadatruntime) continue;
                    toLoad.add(pi);
                }
                HashSet<PluginInformation> allPlugins = new HashSet<PluginInformation>(toLoad);
                allPlugins.addAll(PluginHandler.getPlugins());
                do {
                    removed = false;
                    Iterator it = toLoad.iterator();
                    while (it.hasNext()) {
                        if (PluginHandler.checkRequiredPluginsPreconditions(null, allPlugins, (PluginInformation)it.next(), requiresRestart)) continue;
                        it.remove();
                        removed = true;
                    }
                } while (removed);
                if (!toLoad.isEmpty()) {
                    PluginHandler.loadPlugins(PreferenceTabbedPane.this, toLoad, null);
                }
            }
            if (MainApplication.getMainFrame() != null) {
                MainApplication.getMainFrame().repaint();
            }
        }
    }
}

