/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItemGuiSupport;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetLabel;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.TextItem;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class PresetLink
extends TextItem {
    public String preset_name = "";

    public JLabel createLabel() {
        this.initializeLocaleText(I18n.tr("Edit also \u2026", new Object[0]));
        return new JLabel(this.locale_text);
    }

    @Override
    public boolean addToPanel(JPanel p, TaggingPresetItemGuiSupport support) {
        String presetName = this.preset_name;
        Optional<TaggingPreset> found = TaggingPresets.getTaggingPresets().stream().filter(preset -> presetName.equals(preset.name)).findFirst();
        if (found.isPresent()) {
            TaggingPreset t = found.get();
            TaggingPresetLabel lbl = new TaggingPresetLabel(t);
            lbl.addMouseListener(new TaggingPresetMouseAdapter(t, support.getSelected()));
            p.add((Component)lbl, GBC.eol().fill(2));
        }
        return false;
    }

    @Override
    public void addCommands(List<Tag> changedTags) {
    }

    @Override
    public String toString() {
        return "PresetLink [preset_name=" + this.preset_name + ']';
    }

    static final class TaggingPresetMouseAdapter
    extends MouseAdapter {
        private final TaggingPreset t;
        private final Collection<OsmPrimitive> sel;

        TaggingPresetMouseAdapter(TaggingPreset t, Collection<OsmPrimitive> sel) {
            this.t = t;
            this.sel = sel;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.t.showAndApply(this.sel);
        }
    }
}

