/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.SamType;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\f\u0010\r\u001a\u00020\u0006*\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/SamTypeFactory;", "", "()V", "create", "Lorg/jetbrains/kotlin/backend/common/SamType;", "originalType", "Lorg/jetbrains/kotlin/types/KotlinType;", "createByValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "isSamType", "", "type", "removeExternalProjections", "Companion", "backend-common"})
public class SamTypeFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final SamTypeFactory INSTANCE = new SamTypeFactory();

    @Nullable
    public final SamType createByValueParameter(@NotNull ValueParameterDescriptor valueParameter2) {
        KotlinType originalSingleArgumentType;
        KotlinType singleArgumentType;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
                singleArgumentType = null;
                originalSingleArgumentType = null;
                KotlinType varargElementType = valueParameter2.getVarargElementType();
                if (varargElementType != null) {
                    singleArgumentType = varargElementType;
                    originalSingleArgumentType = valueParameter2.getOriginal().getVarargElementType();
                    boolean bl = originalSingleArgumentType != null;
                    boolean bl2 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl3 = false;
                        String string2 = "Value parameter and original value parameter have inconsistent varargs: " + valueParameter2 + "; " + valueParameter2.getOriginal();
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                } else {
                    KotlinType kotlinType = valueParameter2.getType();
                    Intrinsics.checkNotNullExpressionValue(kotlinType, "valueParameter.type");
                    singleArgumentType = kotlinType;
                    originalSingleArgumentType = valueParameter2.getOriginal().getType();
                }
                if (KotlinTypeKt.isError(singleArgumentType)) break block7;
                Intrinsics.checkNotNull(originalSingleArgumentType);
                if (!KotlinTypeKt.isError(originalSingleArgumentType)) break block8;
            }
            return null;
        }
        KotlinType originalTypeToUse = KotlinBuiltIns.isNothing(singleArgumentType) ? TypeUtilsKt.replaceArgumentsWithNothing(originalSingleArgumentType) : singleArgumentType;
        return this.create(this.removeExternalProjections(originalTypeToUse));
    }

    public boolean isSamType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        return descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).isFun();
    }

    @Nullable
    public final SamType create(@NotNull KotlinType originalType) {
        Intrinsics.checkNotNullParameter(originalType, "originalType");
        return this.isSamType(originalType) ? new SamType(originalType) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType removeExternalProjections(KotlinType $this$removeExternalProjections) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$removeExternalProjections.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(Variance.INVARIANT, it.getType());
            collection.add(typeProjectionImpl);
        }
        List newArguments2 = (List)destination$iv$iv;
        return TypeSubstitutionKt.replace$default($this$removeExternalProjections, newArguments2, null, null, 6, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/backend/common/SamTypeFactory$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/kotlin/backend/common/SamTypeFactory;", "getINSTANCE", "()Lorg/jetbrains/kotlin/backend/common/SamTypeFactory;", "backend-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SamTypeFactory getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

