/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.languagetool.JLanguageTool;
import org.languagetool.server.RequestLimiter;
import org.languagetool.server.TooManyRequestsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ErrorRequestLimiter
extends RequestLimiter {
    private static final Logger log = LoggerFactory.getLogger(ErrorRequestLimiter.class);

    ErrorRequestLimiter(int requestLimit, int requestLimitPeriodInSeconds) {
        super(requestLimit, 0, requestLimitPeriodInSeconds);
    }

    boolean wouldAccessBeOkay(String ipAddress, Map<String, String> parameters, Map<String, List<String>> httpHeader) {
        try {
            this.checkLimit(ipAddress, parameters, httpHeader);
            return true;
        }
        catch (TooManyRequestsException e) {
            log.info("wouldAccessBeOkay -> false: " + e.getMessage());
            return false;
        }
    }

    void logAccess(String ipAddress, Map<String, List<String>> httpHeader, Map<String, String> params) {
        while (this.requestEvents.size() > 1000) {
            this.requestEvents.remove(0);
        }
        this.requestEvents.add(new RequestLimiter.RequestEvent(ipAddress, new Date(), 0, this.computeFingerprint(httpHeader, params), JLanguageTool.Mode.ALL));
    }
}

