/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternToken;

@ApiStatus.Internal
public abstract class AbstractTokenBasedRule
extends AbstractPatternRule {
    @Nullable
    final TokenHint[] tokenHints;
    @Nullable
    final TokenHint anchorHint;

    protected AbstractTokenBasedRule(String id, String description, Language language, List<PatternToken> patternTokens, boolean getUnified) {
        super(id, description, language, patternTokens, getUnified);
        HashSet<TokenHint> tokenHints = new HashSet<TokenHint>();
        TokenHint anchorHint = null;
        boolean fixedOffset = true;
        for (int i = 0; i < patternTokens.size(); ++i) {
            PatternToken token = patternTokens.get(i);
            boolean inflected = false;
            Set<String> hints = token.calcFormHints();
            if (hints == null) {
                inflected = true;
                hints = token.calcLemmaHints();
            }
            if (hints != null) {
                TokenHint hint = new TokenHint(inflected, hints, i);
                tokenHints.add(hint);
                if (fixedOffset && anchorHint == null) {
                    anchorHint = hint;
                }
            }
            if (!fixedOffset || token.getMinOccurrence() == 1 && token.getSkipNext() == 0 && token.getMaxOccurrence() == 1) continue;
            fixedOffset = false;
        }
        this.tokenHints = tokenHints.isEmpty() ? null : (TokenHint[])tokenHints.stream().sorted(Comparator.comparing(th -> th.lowerCaseValues.length).thenComparing(th -> -Arrays.stream(th.lowerCaseValues).mapToInt(String::length).min().orElse(0))).toArray(TokenHint[]::new);
        this.anchorHint = anchorHint;
    }

    protected boolean canBeIgnoredFor(AnalyzedSentence sentence) {
        if (this.tokenHints == null) {
            return false;
        }
        for (TokenHint th : this.tokenHints) {
            if (!th.canBeIgnoredFor(sentence)) continue;
            return true;
        }
        return false;
    }

    static class TokenHint {
        final boolean inflected;
        final String[] lowerCaseValues;
        final int tokenIndex;

        private TokenHint(boolean inflected, Set<String> possibleValues, int tokenIndex) {
            this.inflected = inflected;
            this.tokenIndex = tokenIndex;
            this.lowerCaseValues = (String[])possibleValues.stream().map(String::toLowerCase).distinct().toArray(String[]::new);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TokenHint)) {
                return false;
            }
            TokenHint tokenHint = (TokenHint)o;
            return this.inflected == tokenHint.inflected && this.tokenIndex == tokenHint.tokenIndex && Arrays.equals(this.lowerCaseValues, tokenHint.lowerCaseValues);
        }

        public int hashCode() {
            return Objects.hash(this.inflected, this.tokenIndex, Arrays.hashCode(this.lowerCaseValues));
        }

        List<Integer> getPossibleIndices(AnalyzedSentence sentence) {
            boolean needMerge = false;
            List<Object> result = null;
            for (String hint : this.lowerCaseValues) {
                List<Integer> hintIndices = this.getHintIndices(sentence, hint);
                if (hintIndices == null) continue;
                if (result == null) {
                    result = hintIndices;
                    continue;
                }
                if (!needMerge) {
                    result = new ArrayList<Object>(result);
                    needMerge = true;
                }
                result.addAll(hintIndices);
            }
            if (result == null) {
                return Collections.emptyList();
            }
            return needMerge ? new ArrayList(new TreeSet(result)) : result;
        }

        private boolean canBeIgnoredFor(AnalyzedSentence sentence) {
            for (String hint : this.lowerCaseValues) {
                if (this.getHintIndices(sentence, hint) == null) continue;
                return false;
            }
            return true;
        }

        @Nullable
        private List<Integer> getHintIndices(AnalyzedSentence sentence, String hint) {
            return this.inflected ? sentence.getLemmaOffsets(hint) : sentence.getTokenOffsets(hint);
        }
    }
}

