/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.rules;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.Language;
import org.languagetool.rules.patterns.AbstractTokenBasedRule;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.tagging.disambiguation.rules.DisambiguatedExample;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRuleReplacer;

public class DisambiguationPatternRule
extends AbstractTokenBasedRule {
    private final String disambiguatedPOS;
    private final Match matchElement;
    private final DisambiguatorAction disAction;
    private AnalyzedToken[] newTokenReadings;
    private List<DisambiguatedExample> examples = Collections.emptyList();
    private List<String> untouchedExamples = Collections.emptyList();

    public DisambiguationPatternRule(String id, String description, Language language, List<PatternToken> patternTokens, String disambiguatedPOS, Match posSelect, DisambiguatorAction disambAction) {
        super(id, description, language, patternTokens, true);
        if (disambiguatedPOS == null && posSelect == null && disambAction != DisambiguatorAction.UNIFY && disambAction != DisambiguatorAction.ADD && disambAction != DisambiguatorAction.REMOVE && disambAction != DisambiguatorAction.IMMUNIZE && disambAction != DisambiguatorAction.REPLACE && disambAction != DisambiguatorAction.FILTERALL && disambAction != DisambiguatorAction.IGNORE_SPELLING) {
            throw new NullPointerException("disambiguated POS cannot be null with posSelect == null and " + (Object)((Object)disambAction));
        }
        this.disambiguatedPOS = disambiguatedPOS;
        this.matchElement = posSelect;
        this.disAction = Objects.requireNonNull(disambAction);
    }

    public final void setNewInterpretations(AnalyzedToken[] newReadings) {
        this.newTokenReadings = (AnalyzedToken[])newReadings.clone();
    }

    public final AnalyzedSentence replace(AnalyzedSentence sentence) throws IOException {
        return this.canBeIgnoredFor(sentence) ? sentence : new DisambiguationPatternRuleReplacer(this).replace(sentence);
    }

    public void setExamples(List<DisambiguatedExample> examples) {
        this.examples = Objects.requireNonNull(examples);
    }

    public List<DisambiguatedExample> getExamples() {
        return Collections.unmodifiableList(this.examples);
    }

    public void setUntouchedExamples(List<String> untouchedExamples) {
        this.untouchedExamples = Objects.requireNonNull(untouchedExamples);
    }

    public List<String> getUntouchedExamples() {
        return Collections.unmodifiableList(this.untouchedExamples);
    }

    public DisambiguatorAction getAction() {
        return this.disAction;
    }

    public AnalyzedToken[] getNewTokenReadings() {
        return this.newTokenReadings;
    }

    @Nullable
    public Match getMatchElement() {
        return this.matchElement;
    }

    @Nullable
    public String getDisambiguatedPOS() {
        return this.disambiguatedPOS;
    }

    public static enum DisambiguatorAction {
        ADD,
        FILTER,
        REMOVE,
        REPLACE,
        UNIFY,
        IMMUNIZE,
        IGNORE_SPELLING,
        FILTERALL;

    }
}

