# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2013 Kristian Høgsberg
# Copyright © 2013      Rafael Antognolli
# Copyright © 2013      Jasper St. Pierre
# Copyright © 2010-2013 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from pywayland.protocol_core import Global, Interface, Proxy, Resource


class XdgPopup(Interface):
    """Short-lived, popup surfaces for menus

    A popup surface is a short-lived, temporary surface that can be used to
    implement menus. It takes an explicit grab on the surface that will be
    dismissed when the user dismisses the popup. This can be done by the user
    clicking outside the surface, using the keyboard, or even locking the
    screen through closing the lid or a timeout.

    When the popup is dismissed, a popup_done event will be sent out, and at
    the same time the surface will be unmapped. The :class:`XdgPopup` object is
    now inert and cannot be reactivated, so clients should destroy it.
    Explicitly destroying the :class:`XdgPopup` object will also dismiss the
    popup and unmap the surface.

    Clients will receive events for all their surfaces during this grab (which
    is an "owner-events" grab in X11 parlance). This is done so that users can
    navigate through submenus and other "nested" popup windows without having
    to dismiss the topmost popup.

    Clients that want to dismiss the popup when another surface of their own is
    clicked should dismiss the popup using the destroy request.

    The parent surface must have either an
    :class:`~pywayland.protocol.xdg_shell.XdgSurface` or :class:`XdgPopup`
    role.

    Specifying an :class:`XdgPopup` for the parent means that the popups are
    nested, with this popup now being the topmost popup. Nested popups must be
    destroyed in the reverse order they were created in, e.g. the only popup
    you are allowed to destroy at all times is the topmost one.

    If there is an existing popup when creating a new popup, the parent must be
    the current topmost popup.

    A parent surface must be mapped before the new popup is mapped.

    When compositors choose to dismiss a popup, they will likely dismiss every
    nested popup as well. When a compositor dismisses popups, it will follow
    the same dismissing order as required from the client.

    The x and y arguments passed when creating the popup object specify where
    the top left of the popup should be placed, relative to the local surface
    coordinates of the parent surface. See :func:`XdgShell.get_xdg_popup()
    <pywayland.protocol.xdg_shell_unstable_v5.XdgShell.get_xdg_popup>`.

    The client must call :func:`WlSurface.commit()
    <pywayland.protocol.wayland.WlSurface.commit>` on the corresponding
    :class:`~pywayland.protocol.wayland.WlSurface` for the :class:`XdgPopup`
    state to take effect.

    For a surface to be mapped by the compositor the client must have committed
    both the :class:`XdgPopup` state and a buffer.
    """

    name = "xdg_popup"
    version = 1


class XdgPopupProxy(Proxy):
    interface = XdgPopup

    @XdgPopup.request()
    def destroy(self):
        """Remove :class:`XdgPopup` interface

        This destroys the popup. Explicitly destroying the :class:`XdgPopup`
        object will also dismiss the popup, and unmap the surface.

        If this :class:`XdgPopup` is not the "topmost" popup, a protocol error
        will be sent.
        """
        self._marshal(0)
        self._destroy()


class XdgPopupResource(Resource):
    interface = XdgPopup

    @XdgPopup.event()
    def popup_done(self):
        """Popup interaction is done

        The popup_done event is sent out when a popup is dismissed by the
        compositor. The client should destroy the :class:`XdgPopup` object at
        this point.
        """
        self._post_event(0)


class XdgPopupGlobal(Global):
    interface = XdgPopup


XdgPopup._gen_c()
XdgPopup.proxy_class = XdgPopupProxy
XdgPopup.resource_class = XdgPopupResource
XdgPopup.global_class = XdgPopupGlobal
