from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.gp import *
from OCC.Core.GeomAbs import *
from OCC.Core.TColgp import *
from OCC.Core.TColStd import *


class Geom_SequenceOfBSplineSurface:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class Geom_Geometry(Standard_Transient):
	def Copy(self) -> Geom_Geometry: ...
	@overload
	def Mirror(self, P: gp_Pnt) -> None: ...
	@overload
	def Mirror(self, A1: gp_Ax1) -> None: ...
	@overload
	def Mirror(self, A2: gp_Ax2) -> None: ...
	@overload
	def Mirrored(self, P: gp_Pnt) -> Geom_Geometry: ...
	@overload
	def Mirrored(self, A1: gp_Ax1) -> Geom_Geometry: ...
	@overload
	def Mirrored(self, A2: gp_Ax2) -> Geom_Geometry: ...
	def Rotate(self, A1: gp_Ax1, Ang: float) -> None: ...
	def Rotated(self, A1: gp_Ax1, Ang: float) -> Geom_Geometry: ...
	def Scale(self, P: gp_Pnt, S: float) -> None: ...
	def Scaled(self, P: gp_Pnt, S: float) -> Geom_Geometry: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def Transformed(self, T: gp_Trsf) -> Geom_Geometry: ...
	@overload
	def Translate(self, V: gp_Vec) -> None: ...
	@overload
	def Translate(self, P1: gp_Pnt, P2: gp_Pnt) -> None: ...
	@overload
	def Translated(self, V: gp_Vec) -> Geom_Geometry: ...
	@overload
	def Translated(self, P1: gp_Pnt, P2: gp_Pnt) -> Geom_Geometry: ...

class Geom_OsculatingSurface(Standard_Transient):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, BS: Geom_Surface, Tol: float) -> None: ...
	def BasisSurface(self) -> Geom_Surface: ...
	def Init(self, BS: Geom_Surface, Tol: float) -> None: ...
	def Tolerance(self) -> float: ...
	def UOscSurf(self, U: float, V: float, L: Geom_BSplineSurface) -> Tuple[bool, bool]: ...
	def VOscSurf(self, U: float, V: float, L: Geom_BSplineSurface) -> Tuple[bool, bool]: ...

class Geom_Transformation(Standard_Transient):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, T: gp_Trsf) -> None: ...
	def Copy(self) -> Geom_Transformation: ...
	def Form(self) -> gp_TrsfForm: ...
	def Invert(self) -> None: ...
	def Inverted(self) -> Geom_Transformation: ...
	def IsNegative(self) -> bool: ...
	def Multiplied(self, Other: Geom_Transformation) -> Geom_Transformation: ...
	def Multiply(self, theOther: Geom_Transformation) -> None: ...
	def Power(self, N: int) -> None: ...
	def Powered(self, N: int) -> Geom_Transformation: ...
	def PreMultiply(self, Other: Geom_Transformation) -> None: ...
	def ScaleFactor(self) -> float: ...
	@overload
	def SetMirror(self, thePnt: gp_Pnt) -> None: ...
	@overload
	def SetMirror(self, theA1: gp_Ax1) -> None: ...
	@overload
	def SetMirror(self, theA2: gp_Ax2) -> None: ...
	def SetRotation(self, theA1: gp_Ax1, theAng: float) -> None: ...
	def SetScale(self, thePnt: gp_Pnt, theScale: float) -> None: ...
	@overload
	def SetTransformation(self, theFromSystem1: gp_Ax3, theToSystem2: gp_Ax3) -> None: ...
	@overload
	def SetTransformation(self, theToSystem: gp_Ax3) -> None: ...
	@overload
	def SetTranslation(self, theVec: gp_Vec) -> None: ...
	@overload
	def SetTranslation(self, P1: gp_Pnt, P2: gp_Pnt) -> None: ...
	def SetTrsf(self, theTrsf: gp_Trsf) -> None: ...
	def Transforms(self) -> Tuple[float, float, float]: ...
	def Trsf(self) -> gp_Trsf: ...
	def Value(self, theRow: int, theCol: int) -> float: ...

class Geom_AxisPlacement(Geom_Geometry):
	def Angle(self, Other: Geom_AxisPlacement) -> float: ...
	def Axis(self) -> gp_Ax1: ...
	def Direction(self) -> gp_Dir: ...
	def Location(self) -> gp_Pnt: ...
	def SetAxis(self, A1: gp_Ax1) -> None: ...
	def SetDirection(self, V: gp_Dir) -> None: ...
	def SetLocation(self, P: gp_Pnt) -> None: ...

class Geom_Curve(Geom_Geometry):
	def Continuity(self) -> GeomAbs_Shape: ...
	def D0(self, U: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, P: gp_Pnt, V1: gp_Vec) -> None: ...
	def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
	def D3(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec: ...
	def FirstParameter(self) -> float: ...
	def IsCN(self, N: int) -> bool: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def ParametricTransformation(self, T: gp_Trsf) -> float: ...
	def Period(self) -> float: ...
	def Reverse(self) -> None: ...
	def Reversed(self) -> Geom_Curve: ...
	def ReversedParameter(self, U: float) -> float: ...
	def TransformedParameter(self, U: float, T: gp_Trsf) -> float: ...
	def Value(self, U: float) -> gp_Pnt: ...

class Geom_Point(Geom_Geometry):
	def Coord(self) -> Tuple[float, float, float]: ...
	def Distance(self, Other: Geom_Point) -> float: ...
	def Pnt(self) -> gp_Pnt: ...
	def SquareDistance(self, Other: Geom_Point) -> float: ...
	def X(self) -> float: ...
	def Y(self) -> float: ...
	def Z(self) -> float: ...

class Geom_Surface(Geom_Geometry):
	def Bounds(self) -> Tuple[float, float, float, float]: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
	def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
	def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
	def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
	def IsCNu(self, N: int) -> bool: ...
	def IsCNv(self, N: int) -> bool: ...
	def IsUClosed(self) -> bool: ...
	def IsUPeriodic(self) -> bool: ...
	def IsVClosed(self) -> bool: ...
	def IsVPeriodic(self) -> bool: ...
	def ParametricTransformation(self, T: gp_Trsf) -> gp_GTrsf2d: ...
	def TransformParameters(self, T: gp_Trsf) -> Tuple[float, float]: ...
	def UIso(self, U: float) -> Geom_Curve: ...
	def UPeriod(self) -> float: ...
	def UReverse(self) -> None: ...
	def UReversed(self) -> Geom_Surface: ...
	def UReversedParameter(self, U: float) -> float: ...
	def VIso(self, V: float) -> Geom_Curve: ...
	def VPeriod(self) -> float: ...
	def VReverse(self) -> None: ...
	def VReversed(self) -> Geom_Surface: ...
	def VReversedParameter(self, V: float) -> float: ...
	def Value(self, U: float, V: float) -> gp_Pnt: ...

class Geom_Vector(Geom_Geometry):
	def Angle(self, Other: Geom_Vector) -> float: ...
	def AngleWithRef(self, Other: Geom_Vector, VRef: Geom_Vector) -> float: ...
	def Coord(self) -> Tuple[float, float, float]: ...
	def Cross(self, Other: Geom_Vector) -> None: ...
	def CrossCross(self, V1: Geom_Vector, V2: Geom_Vector) -> None: ...
	def CrossCrossed(self, V1: Geom_Vector, V2: Geom_Vector) -> Geom_Vector: ...
	def Crossed(self, Other: Geom_Vector) -> Geom_Vector: ...
	def Dot(self, Other: Geom_Vector) -> float: ...
	def DotCross(self, V1: Geom_Vector, V2: Geom_Vector) -> float: ...
	def Magnitude(self) -> float: ...
	def Reverse(self) -> None: ...
	def Reversed(self) -> Geom_Vector: ...
	def SquareMagnitude(self) -> float: ...
	def Vec(self) -> gp_Vec: ...
	def X(self) -> float: ...
	def Y(self) -> float: ...
	def Z(self) -> float: ...

class Geom_Axis1Placement(Geom_AxisPlacement):
	@overload
	def __init__(self, A1: gp_Ax1) -> None: ...
	@overload
	def __init__(self, P: gp_Pnt, V: gp_Dir) -> None: ...
	def Ax1(self) -> gp_Ax1: ...
	def Copy(self) -> Geom_Geometry: ...
	def Reverse(self) -> None: ...
	def Reversed(self) -> Geom_Axis1Placement: ...
	def SetDirection(self, V: gp_Dir) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...

class Geom_Axis2Placement(Geom_AxisPlacement):
	@overload
	def __init__(self, A2: gp_Ax2) -> None: ...
	@overload
	def __init__(self, P: gp_Pnt, N: gp_Dir, Vx: gp_Dir) -> None: ...
	def Ax2(self) -> gp_Ax2: ...
	def Copy(self) -> Geom_Geometry: ...
	def SetAx2(self, A2: gp_Ax2) -> None: ...
	def SetDirection(self, V: gp_Dir) -> None: ...
	def SetXDirection(self, Vx: gp_Dir) -> None: ...
	def SetYDirection(self, Vy: gp_Dir) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def XDirection(self) -> gp_Dir: ...
	def YDirection(self) -> gp_Dir: ...

class Geom_BoundedCurve(Geom_Curve):
	def EndPoint(self) -> gp_Pnt: ...
	def StartPoint(self) -> gp_Pnt: ...

class Geom_BoundedSurface(Geom_Surface):
	pass

class Geom_CartesianPoint(Geom_Point):
	@overload
	def __init__(self, P: gp_Pnt) -> None: ...
	@overload
	def __init__(self, X: float, Y: float, Z: float) -> None: ...
	def Coord(self) -> Tuple[float, float, float]: ...
	def Copy(self) -> Geom_Geometry: ...
	def Pnt(self) -> gp_Pnt: ...
	def SetCoord(self, X: float, Y: float, Z: float) -> None: ...
	def SetPnt(self, P: gp_Pnt) -> None: ...
	def SetX(self, X: float) -> None: ...
	def SetY(self, Y: float) -> None: ...
	def SetZ(self, Z: float) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def X(self) -> float: ...
	def Y(self) -> float: ...
	def Z(self) -> float: ...

class Geom_Conic(Geom_Curve):
	def Axis(self) -> gp_Ax1: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Eccentricity(self) -> float: ...
	def IsCN(self, N: int) -> bool: ...
	def Location(self) -> gp_Pnt: ...
	def Position(self) -> gp_Ax2: ...
	def Reverse(self) -> None: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetAxis(self, theA1: gp_Ax1) -> None: ...
	def SetLocation(self, theP: gp_Pnt) -> None: ...
	def SetPosition(self, theA2: gp_Ax2) -> None: ...
	def XAxis(self) -> gp_Ax1: ...
	def YAxis(self) -> gp_Ax1: ...

class Geom_Direction(Geom_Vector):
	@overload
	def __init__(self, X: float, Y: float, Z: float) -> None: ...
	@overload
	def __init__(self, V: gp_Dir) -> None: ...
	def Copy(self) -> Geom_Geometry: ...
	def Cross(self, Other: Geom_Vector) -> None: ...
	def CrossCross(self, V1: Geom_Vector, V2: Geom_Vector) -> None: ...
	def CrossCrossed(self, V1: Geom_Vector, V2: Geom_Vector) -> Geom_Vector: ...
	def Crossed(self, Other: Geom_Vector) -> Geom_Vector: ...
	def Dir(self) -> gp_Dir: ...
	def Magnitude(self) -> float: ...
	def SetCoord(self, X: float, Y: float, Z: float) -> None: ...
	def SetDir(self, V: gp_Dir) -> None: ...
	def SetX(self, X: float) -> None: ...
	def SetY(self, Y: float) -> None: ...
	def SetZ(self, Z: float) -> None: ...
	def SquareMagnitude(self) -> float: ...
	def Transform(self, T: gp_Trsf) -> None: ...

class Geom_ElementarySurface(Geom_Surface):
	def Axis(self) -> gp_Ax1: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def IsCNu(self, N: int) -> bool: ...
	def IsCNv(self, N: int) -> bool: ...
	def Location(self) -> gp_Pnt: ...
	def Position(self) -> gp_Ax3: ...
	def SetAxis(self, theA1: gp_Ax1) -> None: ...
	def SetLocation(self, theLoc: gp_Pnt) -> None: ...
	def SetPosition(self, theAx3: gp_Ax3) -> None: ...
	def UReverse(self) -> None: ...
	def UReversedParameter(self, U: float) -> float: ...
	def VReverse(self) -> None: ...
	def VReversedParameter(self, V: float) -> float: ...

class Geom_Line(Geom_Curve):
	@overload
	def __init__(self, A1: gp_Ax1) -> None: ...
	@overload
	def __init__(self, L: gp_Lin) -> None: ...
	@overload
	def __init__(self, P: gp_Pnt, V: gp_Dir) -> None: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, P: gp_Pnt, V1: gp_Vec) -> None: ...
	def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
	def D3(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec: ...
	def FirstParameter(self) -> float: ...
	def IsCN(self, N: int) -> bool: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def Lin(self) -> gp_Lin: ...
	def ParametricTransformation(self, T: gp_Trsf) -> float: ...
	def Position(self) -> gp_Ax1: ...
	def Reverse(self) -> None: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetDirection(self, V: gp_Dir) -> None: ...
	def SetLin(self, L: gp_Lin) -> None: ...
	def SetLocation(self, P: gp_Pnt) -> None: ...
	def SetPosition(self, A1: gp_Ax1) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def TransformedParameter(self, U: float, T: gp_Trsf) -> float: ...

class Geom_OffsetCurve(Geom_Curve):
	def __init__(self, C: Geom_Curve, Offset: float, V: gp_Dir, isNotCheckC0: Optional[bool] = False) -> None: ...
	def BasisCurve(self) -> Geom_Curve: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, P: gp_Pnt, V1: gp_Vec) -> None: ...
	def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
	def D3(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec: ...
	def Direction(self) -> gp_Dir: ...
	def FirstParameter(self) -> float: ...
	def GetBasisCurveContinuity(self) -> GeomAbs_Shape: ...
	def IsCN(self, N: int) -> bool: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def Offset(self) -> float: ...
	def ParametricTransformation(self, T: gp_Trsf) -> float: ...
	def Period(self) -> float: ...
	def Reverse(self) -> None: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetBasisCurve(self, C: Geom_Curve, isNotCheckC0: Optional[bool] = False) -> None: ...
	def SetDirection(self, V: gp_Dir) -> None: ...
	def SetOffsetValue(self, D: float) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def TransformedParameter(self, U: float, T: gp_Trsf) -> float: ...

class Geom_OffsetSurface(Geom_Surface):
	def __init__(self, S: Geom_Surface, Offset: float, isNotCheckC0: Optional[bool] = False) -> None: ...
	def BasisSurface(self) -> Geom_Surface: ...
	def Bounds(self) -> Tuple[float, float, float, float]: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
	def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
	def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
	def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
	def GetBasisSurfContinuity(self) -> GeomAbs_Shape: ...
	def IsCNu(self, N: int) -> bool: ...
	def IsCNv(self, N: int) -> bool: ...
	def IsUClosed(self) -> bool: ...
	def IsUPeriodic(self) -> bool: ...
	def IsVClosed(self) -> bool: ...
	def IsVPeriodic(self) -> bool: ...
	def Offset(self) -> float: ...
	def OsculatingSurface(self) -> Geom_OsculatingSurface: ...
	def ParametricTransformation(self, T: gp_Trsf) -> gp_GTrsf2d: ...
	def SetBasisSurface(self, S: Geom_Surface, isNotCheckC0: Optional[bool] = False) -> None: ...
	def SetOffsetValue(self, D: float) -> None: ...
	def Surface(self) -> Geom_Surface: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def TransformParameters(self, T: gp_Trsf) -> Tuple[float, float]: ...
	def UIso(self, U: float) -> Geom_Curve: ...
	def UOsculatingSurface(self, U: float, V: float, UOsculSurf: Geom_BSplineSurface) -> Tuple[bool, bool]: ...
	def UPeriod(self) -> float: ...
	def UReverse(self) -> None: ...
	def UReversedParameter(self, U: float) -> float: ...
	def VIso(self, V: float) -> Geom_Curve: ...
	def VOsculatingSurface(self, U: float, V: float, VOsculSurf: Geom_BSplineSurface) -> Tuple[bool, bool]: ...
	def VPeriod(self) -> float: ...
	def VReverse(self) -> None: ...
	def VReversedParameter(self, V: float) -> float: ...

class Geom_SweptSurface(Geom_Surface):
	def BasisCurve(self) -> Geom_Curve: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Direction(self) -> gp_Dir: ...

class Geom_VectorWithMagnitude(Geom_Vector):
	@overload
	def __init__(self, V: gp_Vec) -> None: ...
	@overload
	def __init__(self, X: float, Y: float, Z: float) -> None: ...
	@overload
	def __init__(self, P1: gp_Pnt, P2: gp_Pnt) -> None: ...
	def Add(self, Other: Geom_Vector) -> None: ...
	def Added(self, Other: Geom_Vector) -> Geom_VectorWithMagnitude: ...
	def Copy(self) -> Geom_Geometry: ...
	def Cross(self, Other: Geom_Vector) -> None: ...
	def CrossCross(self, V1: Geom_Vector, V2: Geom_Vector) -> None: ...
	def CrossCrossed(self, V1: Geom_Vector, V2: Geom_Vector) -> Geom_Vector: ...
	def Crossed(self, Other: Geom_Vector) -> Geom_Vector: ...
	def Divide(self, Scalar: float) -> None: ...
	def Divided(self, Scalar: float) -> Geom_VectorWithMagnitude: ...
	def Magnitude(self) -> float: ...
	def Multiplied(self, Scalar: float) -> Geom_VectorWithMagnitude: ...
	def Multiply(self, Scalar: float) -> None: ...
	def Normalize(self) -> None: ...
	def Normalized(self) -> Geom_VectorWithMagnitude: ...
	def SetCoord(self, X: float, Y: float, Z: float) -> None: ...
	def SetVec(self, V: gp_Vec) -> None: ...
	def SetX(self, X: float) -> None: ...
	def SetY(self, Y: float) -> None: ...
	def SetZ(self, Z: float) -> None: ...
	def SquareMagnitude(self) -> float: ...
	def Subtract(self, Other: Geom_Vector) -> None: ...
	def Subtracted(self, Other: Geom_Vector) -> Geom_VectorWithMagnitude: ...
	def Transform(self, T: gp_Trsf) -> None: ...

class Geom_BSplineCurve(Geom_BoundedCurve):
	@overload
	def __init__(self, Poles: TColgp_Array1OfPnt, Knots: TColStd_Array1OfReal, Multiplicities: TColStd_Array1OfInteger, Degree: int, Periodic: Optional[bool] = False) -> None: ...
	@overload
	def __init__(self, Poles: TColgp_Array1OfPnt, Weights: TColStd_Array1OfReal, Knots: TColStd_Array1OfReal, Multiplicities: TColStd_Array1OfInteger, Degree: int, Periodic: Optional[bool] = False, CheckRational: Optional[bool] = True) -> None: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, P: gp_Pnt, V1: gp_Vec) -> None: ...
	def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
	def D3(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec: ...
	def Degree(self) -> int: ...
	def EndPoint(self) -> gp_Pnt: ...
	def FirstParameter(self) -> float: ...
	def FirstUKnotIndex(self) -> int: ...
	def IncreaseDegree(self, Degree: int) -> None: ...
	@overload
	def IncreaseMultiplicity(self, Index: int, M: int) -> None: ...
	@overload
	def IncreaseMultiplicity(self, I1: int, I2: int, M: int) -> None: ...
	def IncrementMultiplicity(self, I1: int, I2: int, M: int) -> None: ...
	def InsertKnot(self, U: float, M: Optional[int] = 1, ParametricTolerance: Optional[float] = 0.0, Add: Optional[bool] = True) -> None: ...
	def InsertKnots(self, Knots: TColStd_Array1OfReal, Mults: TColStd_Array1OfInteger, ParametricTolerance: Optional[float] = 0.0, Add: Optional[bool] = False) -> None: ...
	def IsCN(self, N: int) -> bool: ...
	def IsClosed(self) -> bool: ...
	def IsEqual(self, theOther: Geom_BSplineCurve, thePreci: float) -> bool: ...
	def IsG1(self, theTf: float, theTl: float, theAngTol: float) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def IsRational(self) -> bool: ...
	def Knot(self, Index: int) -> float: ...
	def KnotDistribution(self) -> GeomAbs_BSplKnotDistribution: ...
	@overload
	def KnotSequence(self, K: TColStd_Array1OfReal) -> None: ...
	@overload
	def KnotSequence(self) -> TColStd_Array1OfReal: ...
	@overload
	def Knots(self, K: TColStd_Array1OfReal) -> None: ...
	@overload
	def Knots(self) -> TColStd_Array1OfReal: ...
	def LastParameter(self) -> float: ...
	def LastUKnotIndex(self) -> int: ...
	def LocalD0(self, U: float, FromK1: int, ToK2: int, P: gp_Pnt) -> None: ...
	def LocalD1(self, U: float, FromK1: int, ToK2: int, P: gp_Pnt, V1: gp_Vec) -> None: ...
	def LocalD2(self, U: float, FromK1: int, ToK2: int, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
	def LocalD3(self, U: float, FromK1: int, ToK2: int, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
	def LocalDN(self, U: float, FromK1: int, ToK2: int, N: int) -> gp_Vec: ...
	def LocalValue(self, U: float, FromK1: int, ToK2: int) -> gp_Pnt: ...
	def LocateU(self, U: float, ParametricTolerance: float, WithKnotRepetition: Optional[bool] = False) -> Tuple[int, int]: ...
	@staticmethod
	def MaxDegree() -> int: ...
	def MovePoint(self, U: float, P: gp_Pnt, Index1: int, Index2: int) -> Tuple[int, int]: ...
	def MovePointAndTangent(self, U: float, P: gp_Pnt, Tangent: gp_Vec, Tolerance: float, StartingCondition: int, EndingCondition: int) -> int: ...
	@overload
	def Multiplicities(self, M: TColStd_Array1OfInteger) -> None: ...
	@overload
	def Multiplicities(self) -> TColStd_Array1OfInteger: ...
	def Multiplicity(self, Index: int) -> int: ...
	def NbKnots(self) -> int: ...
	def NbPoles(self) -> int: ...
	def PeriodicNormalization(self) -> float: ...
	def Pole(self, Index: int) -> gp_Pnt: ...
	@overload
	def Poles(self, P: TColgp_Array1OfPnt) -> None: ...
	@overload
	def Poles(self) -> TColgp_Array1OfPnt: ...
	def RemoveKnot(self, Index: int, M: int, Tolerance: float) -> bool: ...
	def Resolution(self, Tolerance3D: float) -> float: ...
	def Reverse(self) -> None: ...
	def ReversedParameter(self, U: float) -> float: ...
	def Segment(self, U1: float, U2: float, theTolerance: Optional[float] = precision_PConfusion()) -> None: ...
	@overload
	def SetKnot(self, Index: int, K: float) -> None: ...
	@overload
	def SetKnot(self, Index: int, K: float, M: int) -> None: ...
	def SetKnots(self, K: TColStd_Array1OfReal) -> None: ...
	def SetNotPeriodic(self) -> None: ...
	@overload
	def SetOrigin(self, Index: int) -> None: ...
	@overload
	def SetOrigin(self, U: float, Tol: float) -> None: ...
	def SetPeriodic(self) -> None: ...
	@overload
	def SetPole(self, Index: int, P: gp_Pnt) -> None: ...
	@overload
	def SetPole(self, Index: int, P: gp_Pnt, Weight: float) -> None: ...
	def SetWeight(self, Index: int, Weight: float) -> None: ...
	def StartPoint(self) -> gp_Pnt: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def Weight(self, Index: int) -> float: ...
	@overload
	def Weights(self, W: TColStd_Array1OfReal) -> None: ...
	@overload
	def Weights(self) -> TColStd_Array1OfReal: ...

class Geom_BSplineSurface(Geom_BoundedSurface):
	@overload
	def __init__(self, Poles: TColgp_Array2OfPnt, UKnots: TColStd_Array1OfReal, VKnots: TColStd_Array1OfReal, UMults: TColStd_Array1OfInteger, VMults: TColStd_Array1OfInteger, UDegree: int, VDegree: int, UPeriodic: Optional[bool] = False, VPeriodic: Optional[bool] = False) -> None: ...
	@overload
	def __init__(self, Poles: TColgp_Array2OfPnt, Weights: TColStd_Array2OfReal, UKnots: TColStd_Array1OfReal, VKnots: TColStd_Array1OfReal, UMults: TColStd_Array1OfInteger, VMults: TColStd_Array1OfInteger, UDegree: int, VDegree: int, UPeriodic: Optional[bool] = False, VPeriodic: Optional[bool] = False) -> None: ...
	def Bounds(self) -> Tuple[float, float, float, float]: ...
	def CheckAndSegment(self, U1: float, U2: float, V1: float, V2: float, theUTolerance: Optional[float] = precision_PConfusion(), theVTolerance: Optional[float] = precision_PConfusion()) -> None: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
	def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
	def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
	def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
	def ExchangeUV(self) -> None: ...
	def FirstUKnotIndex(self) -> int: ...
	def FirstVKnotIndex(self) -> int: ...
	def IncreaseDegree(self, UDegree: int, VDegree: int) -> None: ...
	@overload
	def IncreaseUMultiplicity(self, UIndex: int, M: int) -> None: ...
	@overload
	def IncreaseUMultiplicity(self, FromI1: int, ToI2: int, M: int) -> None: ...
	@overload
	def IncreaseVMultiplicity(self, VIndex: int, M: int) -> None: ...
	@overload
	def IncreaseVMultiplicity(self, FromI1: int, ToI2: int, M: int) -> None: ...
	def IncrementUMultiplicity(self, FromI1: int, ToI2: int, Step: int) -> None: ...
	def IncrementVMultiplicity(self, FromI1: int, ToI2: int, Step: int) -> None: ...
	def InsertUKnot(self, U: float, M: int, ParametricTolerance: float, Add: Optional[bool] = True) -> None: ...
	def InsertUKnots(self, Knots: TColStd_Array1OfReal, Mults: TColStd_Array1OfInteger, ParametricTolerance: Optional[float] = 0.0, Add: Optional[bool] = True) -> None: ...
	def InsertVKnot(self, V: float, M: int, ParametricTolerance: float, Add: Optional[bool] = True) -> None: ...
	def InsertVKnots(self, Knots: TColStd_Array1OfReal, Mults: TColStd_Array1OfInteger, ParametricTolerance: Optional[float] = 0.0, Add: Optional[bool] = True) -> None: ...
	def IsCNu(self, N: int) -> bool: ...
	def IsCNv(self, N: int) -> bool: ...
	def IsUClosed(self) -> bool: ...
	def IsUPeriodic(self) -> bool: ...
	def IsURational(self) -> bool: ...
	def IsVClosed(self) -> bool: ...
	def IsVPeriodic(self) -> bool: ...
	def IsVRational(self) -> bool: ...
	def LastUKnotIndex(self) -> int: ...
	def LastVKnotIndex(self) -> int: ...
	def LocalD0(self, U: float, V: float, FromUK1: int, ToUK2: int, FromVK1: int, ToVK2: int, P: gp_Pnt) -> None: ...
	def LocalD1(self, U: float, V: float, FromUK1: int, ToUK2: int, FromVK1: int, ToVK2: int, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
	def LocalD2(self, U: float, V: float, FromUK1: int, ToUK2: int, FromVK1: int, ToVK2: int, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
	def LocalD3(self, U: float, V: float, FromUK1: int, ToUK2: int, FromVK1: int, ToVK2: int, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
	def LocalDN(self, U: float, V: float, FromUK1: int, ToUK2: int, FromVK1: int, ToVK2: int, Nu: int, Nv: int) -> gp_Vec: ...
	def LocalValue(self, U: float, V: float, FromUK1: int, ToUK2: int, FromVK1: int, ToVK2: int) -> gp_Pnt: ...
	def LocateU(self, U: float, ParametricTolerance: float, WithKnotRepetition: Optional[bool] = False) -> Tuple[int, int]: ...
	def LocateV(self, V: float, ParametricTolerance: float, WithKnotRepetition: Optional[bool] = False) -> Tuple[int, int]: ...
	@staticmethod
	def MaxDegree() -> int: ...
	def MovePoint(self, U: float, V: float, P: gp_Pnt, UIndex1: int, UIndex2: int, VIndex1: int, VIndex2: int) -> Tuple[int, int, int, int]: ...
	def NbUKnots(self) -> int: ...
	def NbUPoles(self) -> int: ...
	def NbVKnots(self) -> int: ...
	def NbVPoles(self) -> int: ...
	def PeriodicNormalization(self) -> Tuple[float, float]: ...
	def Pole(self, UIndex: int, VIndex: int) -> gp_Pnt: ...
	@overload
	def Poles(self, P: TColgp_Array2OfPnt) -> None: ...
	@overload
	def Poles(self) -> TColgp_Array2OfPnt: ...
	def RemoveUKnot(self, Index: int, M: int, Tolerance: float) -> bool: ...
	def RemoveVKnot(self, Index: int, M: int, Tolerance: float) -> bool: ...
	def Resolution(self, Tolerance3D: float) -> Tuple[float, float]: ...
	def Segment(self, U1: float, U2: float, V1: float, V2: float, theUTolerance: Optional[float] = precision_PConfusion(), theVTolerance: Optional[float] = precision_PConfusion()) -> None: ...
	@overload
	def SetPole(self, UIndex: int, VIndex: int, P: gp_Pnt) -> None: ...
	@overload
	def SetPole(self, UIndex: int, VIndex: int, P: gp_Pnt, Weight: float) -> None: ...
	@overload
	def SetPoleCol(self, VIndex: int, CPoles: TColgp_Array1OfPnt) -> None: ...
	@overload
	def SetPoleCol(self, VIndex: int, CPoles: TColgp_Array1OfPnt, CPoleWeights: TColStd_Array1OfReal) -> None: ...
	@overload
	def SetPoleRow(self, UIndex: int, CPoles: TColgp_Array1OfPnt, CPoleWeights: TColStd_Array1OfReal) -> None: ...
	@overload
	def SetPoleRow(self, UIndex: int, CPoles: TColgp_Array1OfPnt) -> None: ...
	@overload
	def SetUKnot(self, UIndex: int, K: float) -> None: ...
	@overload
	def SetUKnot(self, UIndex: int, K: float, M: int) -> None: ...
	def SetUKnots(self, UK: TColStd_Array1OfReal) -> None: ...
	def SetUNotPeriodic(self) -> None: ...
	def SetUOrigin(self, Index: int) -> None: ...
	def SetUPeriodic(self) -> None: ...
	@overload
	def SetVKnot(self, VIndex: int, K: float) -> None: ...
	@overload
	def SetVKnot(self, VIndex: int, K: float, M: int) -> None: ...
	def SetVKnots(self, VK: TColStd_Array1OfReal) -> None: ...
	def SetVNotPeriodic(self) -> None: ...
	def SetVOrigin(self, Index: int) -> None: ...
	def SetVPeriodic(self) -> None: ...
	def SetWeight(self, UIndex: int, VIndex: int, Weight: float) -> None: ...
	def SetWeightCol(self, VIndex: int, CPoleWeights: TColStd_Array1OfReal) -> None: ...
	def SetWeightRow(self, UIndex: int, CPoleWeights: TColStd_Array1OfReal) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def UDegree(self) -> int: ...
	@overload
	def UIso(self, U: float) -> Geom_Curve: ...
	@overload
	def UIso(self, U: float, CheckRational: bool) -> Geom_Curve: ...
	def UKnot(self, UIndex: int) -> float: ...
	def UKnotDistribution(self) -> GeomAbs_BSplKnotDistribution: ...
	@overload
	def UKnotSequence(self, Ku: TColStd_Array1OfReal) -> None: ...
	@overload
	def UKnotSequence(self) -> TColStd_Array1OfReal: ...
	@overload
	def UKnots(self, Ku: TColStd_Array1OfReal) -> None: ...
	@overload
	def UKnots(self) -> TColStd_Array1OfReal: ...
	@overload
	def UMultiplicities(self, Mu: TColStd_Array1OfInteger) -> None: ...
	@overload
	def UMultiplicities(self) -> TColStd_Array1OfInteger: ...
	def UMultiplicity(self, UIndex: int) -> int: ...
	def UReverse(self) -> None: ...
	def UReversedParameter(self, U: float) -> float: ...
	def VDegree(self) -> int: ...
	@overload
	def VIso(self, V: float) -> Geom_Curve: ...
	@overload
	def VIso(self, V: float, CheckRational: bool) -> Geom_Curve: ...
	def VKnot(self, VIndex: int) -> float: ...
	def VKnotDistribution(self) -> GeomAbs_BSplKnotDistribution: ...
	@overload
	def VKnotSequence(self, Kv: TColStd_Array1OfReal) -> None: ...
	@overload
	def VKnotSequence(self) -> TColStd_Array1OfReal: ...
	@overload
	def VKnots(self, Kv: TColStd_Array1OfReal) -> None: ...
	@overload
	def VKnots(self) -> TColStd_Array1OfReal: ...
	@overload
	def VMultiplicities(self, Mv: TColStd_Array1OfInteger) -> None: ...
	@overload
	def VMultiplicities(self) -> TColStd_Array1OfInteger: ...
	def VMultiplicity(self, VIndex: int) -> int: ...
	def VReverse(self) -> None: ...
	def VReversedParameter(self, V: float) -> float: ...
	def Weight(self, UIndex: int, VIndex: int) -> float: ...
	@overload
	def Weights(self, W: TColStd_Array2OfReal) -> None: ...
	@overload
	def Weights(self) -> TColStd_Array2OfReal: ...

class Geom_BezierCurve(Geom_BoundedCurve):
	@overload
	def __init__(self, CurvePoles: TColgp_Array1OfPnt) -> None: ...
	@overload
	def __init__(self, CurvePoles: TColgp_Array1OfPnt, PoleWeights: TColStd_Array1OfReal) -> None: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, P: gp_Pnt, V1: gp_Vec) -> None: ...
	def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
	def D3(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec: ...
	def Degree(self) -> int: ...
	def EndPoint(self) -> gp_Pnt: ...
	def FirstParameter(self) -> float: ...
	def Increase(self, Degree: int) -> None: ...
	@overload
	def InsertPoleAfter(self, Index: int, P: gp_Pnt) -> None: ...
	@overload
	def InsertPoleAfter(self, Index: int, P: gp_Pnt, Weight: float) -> None: ...
	@overload
	def InsertPoleBefore(self, Index: int, P: gp_Pnt) -> None: ...
	@overload
	def InsertPoleBefore(self, Index: int, P: gp_Pnt, Weight: float) -> None: ...
	def IsCN(self, N: int) -> bool: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def IsRational(self) -> bool: ...
	def LastParameter(self) -> float: ...
	@staticmethod
	def MaxDegree() -> int: ...
	def NbPoles(self) -> int: ...
	def Pole(self, Index: int) -> gp_Pnt: ...
	@overload
	def Poles(self, P: TColgp_Array1OfPnt) -> None: ...
	@overload
	def Poles(self) -> TColgp_Array1OfPnt: ...
	def RemovePole(self, Index: int) -> None: ...
	def Resolution(self, Tolerance3D: float) -> float: ...
	def Reverse(self) -> None: ...
	def ReversedParameter(self, U: float) -> float: ...
	def Segment(self, U1: float, U2: float) -> None: ...
	@overload
	def SetPole(self, Index: int, P: gp_Pnt) -> None: ...
	@overload
	def SetPole(self, Index: int, P: gp_Pnt, Weight: float) -> None: ...
	def SetWeight(self, Index: int, Weight: float) -> None: ...
	def StartPoint(self) -> gp_Pnt: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def Weight(self, Index: int) -> float: ...
	@overload
	def Weights(self, W: TColStd_Array1OfReal) -> None: ...
	@overload
	def Weights(self) -> TColStd_Array1OfReal: ...

class Geom_BezierSurface(Geom_BoundedSurface):
	@overload
	def __init__(self, SurfacePoles: TColgp_Array2OfPnt) -> None: ...
	@overload
	def __init__(self, SurfacePoles: TColgp_Array2OfPnt, PoleWeights: TColStd_Array2OfReal) -> None: ...
	def Bounds(self) -> Tuple[float, float, float, float]: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
	def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
	def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
	def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
	def ExchangeUV(self) -> None: ...
	def Increase(self, UDeg: int, VDeg: int) -> None: ...
	@overload
	def InsertPoleColAfter(self, VIndex: int, CPoles: TColgp_Array1OfPnt) -> None: ...
	@overload
	def InsertPoleColAfter(self, VIndex: int, CPoles: TColgp_Array1OfPnt, CPoleWeights: TColStd_Array1OfReal) -> None: ...
	@overload
	def InsertPoleColBefore(self, VIndex: int, CPoles: TColgp_Array1OfPnt) -> None: ...
	@overload
	def InsertPoleColBefore(self, VIndex: int, CPoles: TColgp_Array1OfPnt, CPoleWeights: TColStd_Array1OfReal) -> None: ...
	@overload
	def InsertPoleRowAfter(self, UIndex: int, CPoles: TColgp_Array1OfPnt) -> None: ...
	@overload
	def InsertPoleRowAfter(self, UIndex: int, CPoles: TColgp_Array1OfPnt, CPoleWeights: TColStd_Array1OfReal) -> None: ...
	@overload
	def InsertPoleRowBefore(self, UIndex: int, CPoles: TColgp_Array1OfPnt) -> None: ...
	@overload
	def InsertPoleRowBefore(self, UIndex: int, CPoles: TColgp_Array1OfPnt, CPoleWeights: TColStd_Array1OfReal) -> None: ...
	def IsCNu(self, N: int) -> bool: ...
	def IsCNv(self, N: int) -> bool: ...
	def IsUClosed(self) -> bool: ...
	def IsUPeriodic(self) -> bool: ...
	def IsURational(self) -> bool: ...
	def IsVClosed(self) -> bool: ...
	def IsVPeriodic(self) -> bool: ...
	def IsVRational(self) -> bool: ...
	@staticmethod
	def MaxDegree() -> int: ...
	def NbUPoles(self) -> int: ...
	def NbVPoles(self) -> int: ...
	def Pole(self, UIndex: int, VIndex: int) -> gp_Pnt: ...
	@overload
	def Poles(self, P: TColgp_Array2OfPnt) -> None: ...
	@overload
	def Poles(self) -> TColgp_Array2OfPnt: ...
	def RemovePoleCol(self, VIndex: int) -> None: ...
	def RemovePoleRow(self, UIndex: int) -> None: ...
	def Resolution(self, Tolerance3D: float) -> Tuple[float, float]: ...
	def Segment(self, U1: float, U2: float, V1: float, V2: float) -> None: ...
	@overload
	def SetPole(self, UIndex: int, VIndex: int, P: gp_Pnt) -> None: ...
	@overload
	def SetPole(self, UIndex: int, VIndex: int, P: gp_Pnt, Weight: float) -> None: ...
	@overload
	def SetPoleCol(self, VIndex: int, CPoles: TColgp_Array1OfPnt) -> None: ...
	@overload
	def SetPoleCol(self, VIndex: int, CPoles: TColgp_Array1OfPnt, CPoleWeights: TColStd_Array1OfReal) -> None: ...
	@overload
	def SetPoleRow(self, UIndex: int, CPoles: TColgp_Array1OfPnt) -> None: ...
	@overload
	def SetPoleRow(self, UIndex: int, CPoles: TColgp_Array1OfPnt, CPoleWeights: TColStd_Array1OfReal) -> None: ...
	def SetWeight(self, UIndex: int, VIndex: int, Weight: float) -> None: ...
	def SetWeightCol(self, VIndex: int, CPoleWeights: TColStd_Array1OfReal) -> None: ...
	def SetWeightRow(self, UIndex: int, CPoleWeights: TColStd_Array1OfReal) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def UDegree(self) -> int: ...
	def UIso(self, U: float) -> Geom_Curve: ...
	def UReverse(self) -> None: ...
	def UReversedParameter(self, U: float) -> float: ...
	def VDegree(self) -> int: ...
	def VIso(self, V: float) -> Geom_Curve: ...
	def VReverse(self) -> None: ...
	def VReversedParameter(self, V: float) -> float: ...
	def Weight(self, UIndex: int, VIndex: int) -> float: ...
	@overload
	def Weights(self, W: TColStd_Array2OfReal) -> None: ...
	@overload
	def Weights(self) -> TColStd_Array2OfReal: ...

class Geom_Circle(Geom_Conic):
	@overload
	def __init__(self, C: gp_Circ) -> None: ...
	@overload
	def __init__(self, A2: gp_Ax2, Radius: float) -> None: ...
	def Circ(self) -> gp_Circ: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, P: gp_Pnt, V1: gp_Vec) -> None: ...
	def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
	def D3(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec: ...
	def Eccentricity(self) -> float: ...
	def FirstParameter(self) -> float: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def Radius(self) -> float: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetCirc(self, C: gp_Circ) -> None: ...
	def SetRadius(self, R: float) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...

class Geom_ConicalSurface(Geom_ElementarySurface):
	@overload
	def __init__(self, A3: gp_Ax3, Ang: float, Radius: float) -> None: ...
	@overload
	def __init__(self, C: gp_Cone) -> None: ...
	def Apex(self) -> gp_Pnt: ...
	def Bounds(self) -> Tuple[float, float, float, float]: ...
	def Coefficients(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...
	def Cone(self) -> gp_Cone: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
	def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
	def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
	def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
	def IsUClosed(self) -> bool: ...
	def IsUPeriodic(self) -> bool: ...
	def IsVClosed(self) -> bool: ...
	def IsVPeriodic(self) -> bool: ...
	def ParametricTransformation(self, T: gp_Trsf) -> gp_GTrsf2d: ...
	def RefRadius(self) -> float: ...
	def SemiAngle(self) -> float: ...
	def SetCone(self, C: gp_Cone) -> None: ...
	def SetRadius(self, R: float) -> None: ...
	def SetSemiAngle(self, Ang: float) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def TransformParameters(self, T: gp_Trsf) -> Tuple[float, float]: ...
	def UIso(self, U: float) -> Geom_Curve: ...
	def UReversedParameter(self, U: float) -> float: ...
	def VIso(self, V: float) -> Geom_Curve: ...
	def VReverse(self) -> None: ...
	def VReversedParameter(self, V: float) -> float: ...

class Geom_CylindricalSurface(Geom_ElementarySurface):
	@overload
	def __init__(self, A3: gp_Ax3, Radius: float) -> None: ...
	@overload
	def __init__(self, C: gp_Cylinder) -> None: ...
	def Bounds(self) -> Tuple[float, float, float, float]: ...
	def Coefficients(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...
	def Copy(self) -> Geom_Geometry: ...
	def Cylinder(self) -> gp_Cylinder: ...
	def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
	def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
	def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
	def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
	def IsUClosed(self) -> bool: ...
	def IsUPeriodic(self) -> bool: ...
	def IsVClosed(self) -> bool: ...
	def IsVPeriodic(self) -> bool: ...
	def ParametricTransformation(self, T: gp_Trsf) -> gp_GTrsf2d: ...
	def Radius(self) -> float: ...
	def SetCylinder(self, C: gp_Cylinder) -> None: ...
	def SetRadius(self, R: float) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def TransformParameters(self, T: gp_Trsf) -> Tuple[float, float]: ...
	def UIso(self, U: float) -> Geom_Curve: ...
	def UReversedParameter(self, U: float) -> float: ...
	def VIso(self, V: float) -> Geom_Curve: ...
	def VReversedParameter(self, V: float) -> float: ...

class Geom_Ellipse(Geom_Conic):
	@overload
	def __init__(self, E: gp_Elips) -> None: ...
	@overload
	def __init__(self, A2: gp_Ax2, MajorRadius: float, MinorRadius: float) -> None: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, P: gp_Pnt, V1: gp_Vec) -> None: ...
	def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
	def D3(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec: ...
	def Directrix1(self) -> gp_Ax1: ...
	def Directrix2(self) -> gp_Ax1: ...
	def Eccentricity(self) -> float: ...
	def Elips(self) -> gp_Elips: ...
	def FirstParameter(self) -> float: ...
	def Focal(self) -> float: ...
	def Focus1(self) -> gp_Pnt: ...
	def Focus2(self) -> gp_Pnt: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def MajorRadius(self) -> float: ...
	def MinorRadius(self) -> float: ...
	def Parameter(self) -> float: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetElips(self, E: gp_Elips) -> None: ...
	def SetMajorRadius(self, MajorRadius: float) -> None: ...
	def SetMinorRadius(self, MinorRadius: float) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...

class Geom_Hyperbola(Geom_Conic):
	@overload
	def __init__(self, H: gp_Hypr) -> None: ...
	@overload
	def __init__(self, A2: gp_Ax2, MajorRadius: float, MinorRadius: float) -> None: ...
	def Asymptote1(self) -> gp_Ax1: ...
	def Asymptote2(self) -> gp_Ax1: ...
	def ConjugateBranch1(self) -> gp_Hypr: ...
	def ConjugateBranch2(self) -> gp_Hypr: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, P: gp_Pnt, V1: gp_Vec) -> None: ...
	def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
	def D3(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec: ...
	def Directrix1(self) -> gp_Ax1: ...
	def Directrix2(self) -> gp_Ax1: ...
	def Eccentricity(self) -> float: ...
	def FirstParameter(self) -> float: ...
	def Focal(self) -> float: ...
	def Focus1(self) -> gp_Pnt: ...
	def Focus2(self) -> gp_Pnt: ...
	def Hypr(self) -> gp_Hypr: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def MajorRadius(self) -> float: ...
	def MinorRadius(self) -> float: ...
	def OtherBranch(self) -> gp_Hypr: ...
	def Parameter(self) -> float: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetHypr(self, H: gp_Hypr) -> None: ...
	def SetMajorRadius(self, MajorRadius: float) -> None: ...
	def SetMinorRadius(self, MinorRadius: float) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...

class Geom_Parabola(Geom_Conic):
	@overload
	def __init__(self, Prb: gp_Parab) -> None: ...
	@overload
	def __init__(self, A2: gp_Ax2, Focal: float) -> None: ...
	@overload
	def __init__(self, D: gp_Ax1, F: gp_Pnt) -> None: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, P: gp_Pnt, V1: gp_Vec) -> None: ...
	def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
	def D3(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec: ...
	def Directrix(self) -> gp_Ax1: ...
	def Eccentricity(self) -> float: ...
	def FirstParameter(self) -> float: ...
	def Focal(self) -> float: ...
	def Focus(self) -> gp_Pnt: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def Parab(self) -> gp_Parab: ...
	def Parameter(self) -> float: ...
	def ParametricTransformation(self, T: gp_Trsf) -> float: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetFocal(self, Focal: float) -> None: ...
	def SetParab(self, Prb: gp_Parab) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def TransformedParameter(self, U: float, T: gp_Trsf) -> float: ...

class Geom_Plane(Geom_ElementarySurface):
	@overload
	def __init__(self, A3: gp_Ax3) -> None: ...
	@overload
	def __init__(self, Pl: gp_Pln) -> None: ...
	@overload
	def __init__(self, P: gp_Pnt, V: gp_Dir) -> None: ...
	@overload
	def __init__(self, A: float, B: float, C: float, D: float) -> None: ...
	def Bounds(self) -> Tuple[float, float, float, float]: ...
	def Coefficients(self) -> Tuple[float, float, float, float]: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
	def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
	def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
	def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
	def IsUClosed(self) -> bool: ...
	def IsUPeriodic(self) -> bool: ...
	def IsVClosed(self) -> bool: ...
	def IsVPeriodic(self) -> bool: ...
	def ParametricTransformation(self, T: gp_Trsf) -> gp_GTrsf2d: ...
	def Pln(self) -> gp_Pln: ...
	def SetPln(self, Pl: gp_Pln) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def TransformParameters(self, T: gp_Trsf) -> Tuple[float, float]: ...
	def UIso(self, U: float) -> Geom_Curve: ...
	def UReverse(self) -> None: ...
	def UReversedParameter(self, U: float) -> float: ...
	def VIso(self, V: float) -> Geom_Curve: ...
	def VReverse(self) -> None: ...
	def VReversedParameter(self, V: float) -> float: ...

class Geom_RectangularTrimmedSurface(Geom_BoundedSurface):
	@overload
	def __init__(self, S: Geom_Surface, U1: float, U2: float, V1: float, V2: float, USense: Optional[bool] = True, VSense: Optional[bool] = True) -> None: ...
	@overload
	def __init__(self, S: Geom_Surface, Param1: float, Param2: float, UTrim: bool, Sense: Optional[bool] = True) -> None: ...
	def BasisSurface(self) -> Geom_Surface: ...
	def Bounds(self) -> Tuple[float, float, float, float]: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
	def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
	def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
	def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
	def IsCNu(self, N: int) -> bool: ...
	def IsCNv(self, N: int) -> bool: ...
	def IsUClosed(self) -> bool: ...
	def IsUPeriodic(self) -> bool: ...
	def IsVClosed(self) -> bool: ...
	def IsVPeriodic(self) -> bool: ...
	def ParametricTransformation(self, T: gp_Trsf) -> gp_GTrsf2d: ...
	@overload
	def SetTrim(self, U1: float, U2: float, V1: float, V2: float, USense: Optional[bool] = True, VSense: Optional[bool] = True) -> None: ...
	@overload
	def SetTrim(self, Param1: float, Param2: float, UTrim: bool, Sense: Optional[bool] = True) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def TransformParameters(self, T: gp_Trsf) -> Tuple[float, float]: ...
	def UIso(self, U: float) -> Geom_Curve: ...
	def UPeriod(self) -> float: ...
	def UReverse(self) -> None: ...
	def UReversedParameter(self, U: float) -> float: ...
	def VIso(self, V: float) -> Geom_Curve: ...
	def VPeriod(self) -> float: ...
	def VReverse(self) -> None: ...
	def VReversedParameter(self, V: float) -> float: ...

class Geom_SphericalSurface(Geom_ElementarySurface):
	@overload
	def __init__(self, A3: gp_Ax3, Radius: float) -> None: ...
	@overload
	def __init__(self, S: gp_Sphere) -> None: ...
	def Area(self) -> float: ...
	def Bounds(self) -> Tuple[float, float, float, float]: ...
	def Coefficients(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
	def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
	def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
	def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
	def IsUClosed(self) -> bool: ...
	def IsUPeriodic(self) -> bool: ...
	def IsVClosed(self) -> bool: ...
	def IsVPeriodic(self) -> bool: ...
	def Radius(self) -> float: ...
	def SetRadius(self, R: float) -> None: ...
	def SetSphere(self, S: gp_Sphere) -> None: ...
	def Sphere(self) -> gp_Sphere: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def UIso(self, U: float) -> Geom_Curve: ...
	def UReversedParameter(self, U: float) -> float: ...
	def VIso(self, V: float) -> Geom_Curve: ...
	def VReversedParameter(self, V: float) -> float: ...
	def Volume(self) -> float: ...

class Geom_SurfaceOfLinearExtrusion(Geom_SweptSurface):
	def __init__(self, C: Geom_Curve, V: gp_Dir) -> None: ...
	def Bounds(self) -> Tuple[float, float, float, float]: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
	def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
	def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
	def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
	def IsCNu(self, N: int) -> bool: ...
	def IsCNv(self, N: int) -> bool: ...
	def IsUClosed(self) -> bool: ...
	def IsUPeriodic(self) -> bool: ...
	def IsVClosed(self) -> bool: ...
	def IsVPeriodic(self) -> bool: ...
	def ParametricTransformation(self, T: gp_Trsf) -> gp_GTrsf2d: ...
	def SetBasisCurve(self, C: Geom_Curve) -> None: ...
	def SetDirection(self, V: gp_Dir) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def TransformParameters(self, T: gp_Trsf) -> Tuple[float, float]: ...
	def UIso(self, U: float) -> Geom_Curve: ...
	def UReverse(self) -> None: ...
	def UReversedParameter(self, U: float) -> float: ...
	def VIso(self, V: float) -> Geom_Curve: ...
	def VReverse(self) -> None: ...
	def VReversedParameter(self, V: float) -> float: ...

class Geom_SurfaceOfRevolution(Geom_SweptSurface):
	def __init__(self, C: Geom_Curve, A1: gp_Ax1) -> None: ...
	def Axis(self) -> gp_Ax1: ...
	def Bounds(self) -> Tuple[float, float, float, float]: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
	def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
	def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
	def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
	def IsCNu(self, N: int) -> bool: ...
	def IsCNv(self, N: int) -> bool: ...
	def IsUClosed(self) -> bool: ...
	def IsUPeriodic(self) -> bool: ...
	def IsVClosed(self) -> bool: ...
	def IsVPeriodic(self) -> bool: ...
	def Location(self) -> gp_Pnt: ...
	def ParametricTransformation(self, T: gp_Trsf) -> gp_GTrsf2d: ...
	def ReferencePlane(self) -> gp_Ax2: ...
	def SetAxis(self, A1: gp_Ax1) -> None: ...
	def SetBasisCurve(self, C: Geom_Curve) -> None: ...
	def SetDirection(self, V: gp_Dir) -> None: ...
	def SetLocation(self, P: gp_Pnt) -> None: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def TransformParameters(self, T: gp_Trsf) -> Tuple[float, float]: ...
	def UIso(self, U: float) -> Geom_Curve: ...
	def UReverse(self) -> None: ...
	def UReversedParameter(self, U: float) -> float: ...
	def VIso(self, V: float) -> Geom_Curve: ...
	def VReverse(self) -> None: ...
	def VReversedParameter(self, V: float) -> float: ...

class Geom_ToroidalSurface(Geom_ElementarySurface):
	@overload
	def __init__(self, A3: gp_Ax3, MajorRadius: float, MinorRadius: float) -> None: ...
	@overload
	def __init__(self, T: gp_Torus) -> None: ...
	def Area(self) -> float: ...
	def Bounds(self) -> Tuple[float, float, float, float]: ...
	def Coefficients(self, Coef: TColStd_Array1OfReal) -> None: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
	def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
	def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
	def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
	def IsUClosed(self) -> bool: ...
	def IsUPeriodic(self) -> bool: ...
	def IsVClosed(self) -> bool: ...
	def IsVPeriodic(self) -> bool: ...
	def MajorRadius(self) -> float: ...
	def MinorRadius(self) -> float: ...
	def SetMajorRadius(self, MajorRadius: float) -> None: ...
	def SetMinorRadius(self, MinorRadius: float) -> None: ...
	def SetTorus(self, T: gp_Torus) -> None: ...
	def Torus(self) -> gp_Torus: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def UIso(self, U: float) -> Geom_Curve: ...
	def UReversedParameter(self, U: float) -> float: ...
	def VIso(self, V: float) -> Geom_Curve: ...
	def VReversedParameter(self, U: float) -> float: ...
	def Volume(self) -> float: ...

class Geom_TrimmedCurve(Geom_BoundedCurve):
	def __init__(self, C: Geom_Curve, U1: float, U2: float, Sense: Optional[bool] = True, theAdjustPeriodic: Optional[bool] = True) -> None: ...
	def BasisCurve(self) -> Geom_Curve: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Copy(self) -> Geom_Geometry: ...
	def D0(self, U: float, P: gp_Pnt) -> None: ...
	def D1(self, U: float, P: gp_Pnt, V1: gp_Vec) -> None: ...
	def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
	def D3(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec: ...
	def EndPoint(self) -> gp_Pnt: ...
	def FirstParameter(self) -> float: ...
	def IsCN(self, N: int) -> bool: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def ParametricTransformation(self, T: gp_Trsf) -> float: ...
	def Period(self) -> float: ...
	def Reverse(self) -> None: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetTrim(self, U1: float, U2: float, Sense: Optional[bool] = True, theAdjustPeriodic: Optional[bool] = True) -> None: ...
	def StartPoint(self) -> gp_Pnt: ...
	def Transform(self, T: gp_Trsf) -> None: ...
	def TransformedParameter(self, U: float, T: gp_Trsf) -> float: ...

# harray1 classes
# harray2 classes
# hsequence classes

class Geom_HSequenceOfBSplineSurface(Geom_SequenceOfBSplineSurface, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: Geom_SequenceOfBSplineSurface) -> None: ...
    def Sequence(self) -> Geom_SequenceOfBSplineSurface: ...
    def Append(self, theSequence: Geom_SequenceOfBSplineSurface) -> None: ...


Geom_BSplineCurve_MaxDegree = Geom_BSplineCurve.MaxDegree
Geom_BSplineSurface_MaxDegree = Geom_BSplineSurface.MaxDegree
Geom_BezierCurve_MaxDegree = Geom_BezierCurve.MaxDegree
Geom_BezierSurface_MaxDegree = Geom_BezierSurface.MaxDegree
