/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.math.BigInteger;
import org.apache.tomcat.util.res.StringManager;

public class Asn1Parser {
    private static final StringManager sm = StringManager.getManager(Asn1Parser.class);
    private final byte[] source;
    private int pos = 0;

    public Asn1Parser(byte[] byArray) {
        this.source = byArray;
    }

    public void parseTag(int n) {
        int n2 = this.next();
        if (n2 != n) {
            throw new IllegalArgumentException(sm.getString("asn1Parser.tagMismatch", n, n2));
        }
    }

    public void parseFullLength() {
        int n = this.parseLength();
        if (n + this.pos != this.source.length) {
            throw new IllegalArgumentException(sm.getString("asn1Parser.lengthInvalid", n, this.source.length - this.pos));
        }
    }

    public int parseLength() {
        int n = this.next();
        if (n > 127) {
            int n2 = n - 128;
            n = 0;
            for (int i = 0; i < n2; ++i) {
                n <<= 8;
                n += this.next();
            }
        }
        return n;
    }

    public BigInteger parseInt() {
        this.parseTag(2);
        int n = this.parseLength();
        byte[] byArray = new byte[n];
        System.arraycopy(this.source, this.pos, byArray, 0, n);
        this.pos += n;
        return new BigInteger(byArray);
    }

    public void parseBytes(byte[] byArray) {
        System.arraycopy(this.source, this.pos, byArray, 0, byArray.length);
        this.pos += byArray.length;
    }

    private int next() {
        return this.source[this.pos++] & 0xFF;
    }
}

