/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.errorbars;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.errorbars.AErrorBarPolicyConfigurable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ErrorBarPolicyAbsoluteSummation
extends AErrorBarPolicyConfigurable {
    private double m_xError = 4.0;
    private double m_yError = 4.0;

    public ErrorBarPolicyAbsoluteSummation(double xError, double yError) throws IllegalArgumentException {
        this.setXError(xError);
    }

    public JComponent getCustomConfigurator() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        JLabel xErrorLable = new JLabel("Absolute X error ");
        panel.add((Component)xErrorLable, gbc);
        SpinnerNumberModel numberXModel = new SpinnerNumberModel(this.getXError(0.0), 0.0, 10000.0, 10.0);
        JSpinner xErrorSelector = new JSpinner(numberXModel);
        gbc.gridx = 1;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        panel.add((Component)xErrorSelector, gbc);
        gbc.gridx = 2;
        gbc.gridheight = 2;
        gbc.fill = 2;
        gbc.weightx = 0.5;
        panel.add(Box.createHorizontalGlue(), gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        JLabel yErrorLable = new JLabel("Absolute Y error ");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        panel.add((Component)yErrorLable, gbc);
        SpinnerNumberModel numberYModel = new SpinnerNumberModel(this.getYError(0.0), 0.0, 10000.0, 10.0);
        JSpinner yErrorSelector = new JSpinner(numberYModel);
        gbc.gridx = 1;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        panel.add((Component)yErrorSelector, gbc);
        xErrorSelector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
                Number number = model.getNumber();
                ErrorBarPolicyAbsoluteSummation.this.setXError(number.doubleValue());
            }
        });
        yErrorSelector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
                Number number = model.getNumber();
                ErrorBarPolicyAbsoluteSummation.this.setYError(number.doubleValue());
            }
        });
        return panel;
    }

    public final double getXError(double xValue) {
        return this.m_xError;
    }

    public final double getYError(double yValue) {
        return this.m_yError;
    }

    protected int internalGetNegativeXError(int xPixel, int yPixel, TracePoint2D original) {
        ITrace2D trace = this.getTrace();
        Chart2D chart = trace.getRenderer();
        IAxis axisX = chart.getAxisX();
        int result = axisX.translateValueToPx(original.getX() - this.m_xError);
        return result;
    }

    protected int internalGetNegativeYError(int xPixel, int yPixel, TracePoint2D original) {
        ITrace2D trace = this.getTrace();
        Chart2D chart = trace.getRenderer();
        IAxis axisY = chart.getAxisY();
        int result = axisY.translateValueToPx(original.getY() - this.m_yError);
        return result;
    }

    protected int internalGetPositiveXError(int xPixel, int yPixel, TracePoint2D original) {
        ITrace2D trace = this.getTrace();
        Chart2D chart = trace.getRenderer();
        IAxis axisX = chart.getAxisX();
        int result = axisX.translateValueToPx(original.getX() + this.m_xError);
        return result;
    }

    protected int internalGetPositiveYError(int xPixel, int yPixel, TracePoint2D original) {
        ITrace2D trace = this.getTrace();
        Chart2D chart = trace.getRenderer();
        IAxis axisY = chart.getAxisY();
        int result = axisY.translateValueToPx(original.getY() + this.m_yError);
        return result;
    }

    public final void setXError(double xError) throws IllegalArgumentException {
        boolean change;
        if (xError < 0.0) {
            throw new IllegalArgumentException("Given absolute error (" + xError + ")has to be > 0.");
        }
        boolean bl = change = this.m_xError != xError;
        if (change) {
            this.m_xError = xError;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }

    public final void setYError(double yError) throws IllegalArgumentException {
        boolean change;
        if (yError < 0.0) {
            throw new IllegalArgumentException("Given absolute error (" + yError + ")has to be > 0.");
        }
        boolean bl = change = this.m_yError != yError;
        if (change) {
            this.m_yError = yError;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }
}

