/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.util.Collection;
import java.util.TreeSet;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.metadata.Metadata;

@Singleton
@Named(value="gav")
public class GAVNameMapper
implements NameMapper {
    public static final String NAME = "gav";

    @Override
    public Collection<String> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        TreeSet<String> keys2 = new TreeSet<String>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                String key2 = "artifact:" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion();
                keys2.add(key2);
            }
        }
        if (metadatas != null) {
            for (Metadata metadata : metadatas) {
                StringBuilder key2 = new StringBuilder("metadata:");
                if (!metadata.getGroupId().isEmpty()) {
                    key2.append(metadata.getGroupId());
                    if (!metadata.getArtifactId().isEmpty()) {
                        key2.append(':').append(metadata.getArtifactId());
                        if (!metadata.getVersion().isEmpty()) {
                            key2.append(':').append(metadata.getVersion());
                        }
                    }
                }
                keys2.add(key2.toString());
            }
        }
        return keys2;
    }
}

