/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangBinary;
import com.ericsson.otp.erlang.OtpErlangBitstr;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangDouble;
import com.ericsson.otp.erlang.OtpErlangExternalFun;
import com.ericsson.otp.erlang.OtpErlangFun;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangMap;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangPort;
import com.ericsson.otp.erlang.OtpErlangRef;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class OtpInputStream
extends ByteArrayInputStream {
    public static int DECODE_INT_LISTS_AS_STRINGS = 1;
    private final int flags;

    public OtpInputStream(byte[] byArray) {
        this(byArray, 0);
    }

    public OtpInputStream(byte[] byArray, int n) {
        super(byArray);
        this.flags = n;
    }

    public OtpInputStream(byte[] byArray, int n, int n2, int n3) {
        super(byArray, n, n2);
        this.flags = n3;
    }

    public int getPos() {
        return this.pos;
    }

    public int setPos(int n) {
        int n2 = this.pos;
        int n3 = n;
        if (n > this.count) {
            n3 = this.count;
        } else if (n < 0) {
            n3 = 0;
        }
        this.pos = n3;
        return n2;
    }

    public int readN(byte[] byArray) throws OtpErlangDecodeException {
        return this.readN(byArray, 0, byArray.length);
    }

    public int readN(byte[] byArray, int n, int n2) throws OtpErlangDecodeException {
        if (n2 == 0 && this.available() == 0) {
            return 0;
        }
        int n3 = super.read(byArray, n, n2);
        if (n3 < 0) {
            throw new OtpErlangDecodeException("Cannot read from input stream");
        }
        return n3;
    }

    public int peek() throws OtpErlangDecodeException {
        return this.peek1();
    }

    public int peek1() throws OtpErlangDecodeException {
        try {
            int n = this.buf[this.pos];
            if (n < 0) {
                n += 256;
            }
            return n;
        }
        catch (Exception exception) {
            throw new OtpErlangDecodeException("Cannot read from input stream");
        }
    }

    public int peek1skip_version() throws OtpErlangDecodeException {
        int n = this.peek1();
        if (n == 131) {
            this.read1();
            n = this.peek1();
        }
        return n;
    }

    public int read1() throws OtpErlangDecodeException {
        int n = super.read();
        if (n < 0) {
            throw new OtpErlangDecodeException("Cannot read from input stream");
        }
        return n;
    }

    public int read1skip_version() throws OtpErlangDecodeException {
        int n = this.read1();
        if (n == 131) {
            n = this.read1();
        }
        return n;
    }

    public int read2BE() throws OtpErlangDecodeException {
        byte[] byArray = new byte[2];
        try {
            super.read(byArray);
        }
        catch (IOException iOException) {
            throw new OtpErlangDecodeException("Cannot read from input stream");
        }
        return (byArray[0] << 8 & 0xFF00) + (byArray[1] & 0xFF);
    }

    public int read4BE() throws OtpErlangDecodeException {
        byte[] byArray = new byte[4];
        try {
            super.read(byArray);
        }
        catch (IOException iOException) {
            throw new OtpErlangDecodeException("Cannot read from input stream");
        }
        return (byArray[0] << 24 & 0xFF000000) + (byArray[1] << 16 & 0xFF0000) + (byArray[2] << 8 & 0xFF00) + (byArray[3] & 0xFF);
    }

    public long read8BE() throws OtpErlangDecodeException {
        long l = this.read4BE();
        long l2 = this.read4BE();
        return l << 32 | l2 & 0xFFFFFFFFFFFFFFFFL;
    }

    public int read2LE() throws OtpErlangDecodeException {
        byte[] byArray = new byte[2];
        try {
            super.read(byArray);
        }
        catch (IOException iOException) {
            throw new OtpErlangDecodeException("Cannot read from input stream");
        }
        return (byArray[1] << 8 & 0xFF00) + (byArray[0] & 0xFF);
    }

    public int read4LE() throws OtpErlangDecodeException {
        byte[] byArray = new byte[4];
        try {
            super.read(byArray);
        }
        catch (IOException iOException) {
            throw new OtpErlangDecodeException("Cannot read from input stream");
        }
        return (byArray[3] << 24 & 0xFF000000) + (byArray[2] << 16 & 0xFF0000) + (byArray[1] << 8 & 0xFF00) + (byArray[0] & 0xFF);
    }

    public long readLE(int n) throws OtpErlangDecodeException {
        byte[] byArray = new byte[n];
        try {
            super.read(byArray);
        }
        catch (IOException iOException) {
            throw new OtpErlangDecodeException("Cannot read from input stream");
        }
        long l = 0L;
        int n2 = n;
        while (n2-- > 0) {
            l = l << 8 | (long)byArray[n2] & 0xFFL;
        }
        return l;
    }

    public long readBE(int n) throws OtpErlangDecodeException {
        byte[] byArray = new byte[n];
        try {
            super.read(byArray);
        }
        catch (IOException iOException) {
            throw new OtpErlangDecodeException("Cannot read from input stream");
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l = l << 8 | (long)byArray[i] & 0xFFL;
        }
        return l;
    }

    public boolean read_boolean() throws OtpErlangDecodeException {
        return Boolean.valueOf(this.read_atom());
    }

    public String read_atom() throws OtpErlangDecodeException {
        String string;
        int n = -1;
        int n2 = this.read1skip_version();
        switch (n2) {
            case 100: {
                n = this.read2BE();
                byte[] byArray = new byte[n];
                this.readN(byArray);
                try {
                    string = new String(byArray, "ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new OtpErlangDecodeException("Failed to decode ISO-8859-1 atom");
                }
                if (string.length() <= 255) break;
                string = string.substring(0, 255);
                break;
            }
            case 119: {
                n = this.read1();
            }
            case 118: {
                if (n < 0) {
                    n = this.read2BE();
                }
                byte[] byArray = new byte[n];
                this.readN(byArray);
                try {
                    string = new String(byArray, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new OtpErlangDecodeException("Failed to decode UTF-8 atom");
                }
                if (string.codePointCount(0, string.length()) <= 255) break;
                int[] nArray = OtpErlangString.stringToCodePoints(string);
                string = new String(nArray, 0, 255);
                break;
            }
            default: {
                throw new OtpErlangDecodeException("wrong tag encountered, expected 100, or 118, got " + n2);
            }
        }
        return string;
    }

    public byte[] read_binary() throws OtpErlangDecodeException {
        int n = this.read1skip_version();
        if (n != 109) {
            throw new OtpErlangDecodeException("Wrong tag encountered, expected 109, got " + n);
        }
        int n2 = this.read4BE();
        byte[] byArray = new byte[n2];
        this.readN(byArray);
        return byArray;
    }

    public byte[] read_bitstr(int[] nArray) throws OtpErlangDecodeException {
        int n = this.read1skip_version();
        if (n != 77) {
            throw new OtpErlangDecodeException("Wrong tag encountered, expected 77, got " + n);
        }
        int n2 = this.read4BE();
        byte[] byArray = new byte[n2];
        int n3 = this.read1();
        if (n3 < 0 || 7 < n3) {
            throw new OtpErlangDecodeException("Wrong tail bit count in bitstr: " + n3);
        }
        if (n2 == 0 && n3 != 0) {
            throw new OtpErlangDecodeException("Length 0 on bitstr with tail bit count: " + n3);
        }
        this.readN(byArray);
        nArray[0] = 8 - n3;
        return byArray;
    }

    public float read_float() throws OtpErlangDecodeException {
        double d = this.read_double();
        return (float)d;
    }

    public double read_double() throws OtpErlangDecodeException {
        int n = this.read1skip_version();
        switch (n) {
            case 70: {
                return Double.longBitsToDouble(this.readBE(8));
            }
            case 99: {
                byte[] byArray = new byte[31];
                this.readN(byArray);
                String string = OtpErlangString.newString(byArray);
                int n2 = string.indexOf(101, 0);
                if (n2 < 0) {
                    throw new OtpErlangDecodeException("Invalid float format: '" + string + "'");
                }
                String string2 = string.substring(n2 + 1).trim();
                if (string2.substring(0, 1).equals("+")) {
                    string2 = string2.substring(1);
                }
                int n3 = Integer.valueOf(string2);
                BigDecimal bigDecimal = new BigDecimal(string.substring(0, n2)).movePointRight(n3);
                return bigDecimal.doubleValue();
            }
        }
        throw new OtpErlangDecodeException("Wrong tag encountered, expected 70, got " + n);
    }

    public byte read_byte() throws OtpErlangDecodeException {
        byte by;
        long l = this.read_long(false);
        if (l != (long)(by = (byte)l)) {
            throw new OtpErlangDecodeException("Value does not fit in byte: " + l);
        }
        return by;
    }

    public char read_char() throws OtpErlangDecodeException {
        char c;
        long l = this.read_long(true);
        if (l != ((long)(c = (char)l) & 0xFFFFL)) {
            throw new OtpErlangDecodeException("Value does not fit in char: " + l);
        }
        return c;
    }

    public int read_uint() throws OtpErlangDecodeException {
        int n;
        long l = this.read_long(true);
        if (l != ((long)(n = (int)l) & 0xFFFFFFFFL)) {
            throw new OtpErlangDecodeException("Value does not fit in uint: " + l);
        }
        return n;
    }

    public int read_int() throws OtpErlangDecodeException {
        int n;
        long l = this.read_long(false);
        if (l != (long)(n = (int)l)) {
            throw new OtpErlangDecodeException("Value does not fit in int: " + l);
        }
        return n;
    }

    public short read_ushort() throws OtpErlangDecodeException {
        short s;
        long l = this.read_long(true);
        if (l != ((long)(s = (short)l) & 0xFFFFL)) {
            throw new OtpErlangDecodeException("Value does not fit in ushort: " + l);
        }
        return s;
    }

    public short read_short() throws OtpErlangDecodeException {
        short s;
        long l = this.read_long(false);
        if (l != (long)(s = (short)l)) {
            throw new OtpErlangDecodeException("Value does not fit in short: " + l);
        }
        return s;
    }

    public long read_ulong() throws OtpErlangDecodeException {
        return this.read_long(true);
    }

    public long read_long() throws OtpErlangDecodeException {
        return this.read_long(false);
    }

    public long read_long(boolean bl) throws OtpErlangDecodeException {
        byte[] byArray = this.read_integer_byte_array();
        return OtpInputStream.byte_array_to_long(byArray, bl);
    }

    public byte[] read_integer_byte_array() throws OtpErlangDecodeException {
        byte[] byArray;
        int n = this.read1skip_version();
        switch (n) {
            case 97: {
                byArray = new byte[]{0, (byte)this.read1()};
                break;
            }
            case 98: {
                byArray = new byte[4];
                if (this.readN(byArray) == 4) break;
                throw new OtpErlangDecodeException("Cannot read from intput stream");
            }
            case 110: 
            case 111: {
                int n2;
                int n3;
                int n4;
                if (n == 110) {
                    n4 = this.read1();
                    n3 = this.read1();
                } else {
                    n4 = this.read4BE();
                    n3 = this.read1();
                    if (n4 + 1 < 0) {
                        throw new OtpErlangDecodeException("Value of largeBig does not fit in BigInteger, arity " + n4 + " sign " + n3);
                    }
                }
                byArray = new byte[n4 + 1];
                if (this.readN(byArray, 0, n4) != n4) {
                    throw new OtpErlangDecodeException("Cannot read from intput stream");
                }
                int n5 = byArray.length;
                for (n2 = 0; n2 < n5--; ++n2) {
                    byte by = byArray[n2];
                    byArray[n2] = byArray[n5];
                    byArray[n5] = by;
                }
                if (n3 == 0) break;
                n2 = 1;
                n5 = byArray.length;
                while (n5-- > 0) {
                    n2 = (~byArray[n5] & 0xFF) + n2;
                    byArray[n5] = (byte)n2;
                    n2 >>= 8;
                }
                break;
            }
            default: {
                throw new OtpErlangDecodeException("Not valid integer tag: " + n);
            }
        }
        return byArray;
    }

    public static long byte_array_to_long(byte[] byArray, boolean bl) throws OtpErlangDecodeException {
        long l;
        switch (byArray.length) {
            case 0: {
                l = 0L;
                break;
            }
            case 2: {
                l = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
                l = (short)l;
                if (l >= 0L || !bl) break;
                throw new OtpErlangDecodeException("Value not unsigned: " + l);
            }
            case 4: {
                l = ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
                l = (int)l;
                if (l >= 0L || !bl) break;
                throw new OtpErlangDecodeException("Value not unsigned: " + l);
            }
            default: {
                int n = 0;
                byte by = byArray[n];
                if (bl) {
                    if (by < 0) {
                        throw new OtpErlangDecodeException("Value not unsigned: " + Arrays.toString(byArray));
                    }
                    while (byArray[n] == 0) {
                        ++n;
                    }
                } else if (by == 0 || by == -1) {
                    for (n = 1; n < byArray.length && byArray[n] == by; ++n) {
                    }
                    if (n < byArray.length && ((by ^ byArray[n]) & 0x80) != 0) {
                        --n;
                    }
                }
                if (byArray.length - n > 8) {
                    throw new OtpErlangDecodeException("Value does not fit in long: " + Arrays.toString(byArray));
                }
                long l2 = l = by < 0 ? -1L : 0L;
                while (n < byArray.length) {
                    l = l << 8 | (long)(byArray[n] & 0xFF);
                    ++n;
                }
                break block0;
            }
        }
        return l;
    }

    public int read_list_head() throws OtpErlangDecodeException {
        int n = 0;
        int n2 = this.read1skip_version();
        switch (n2) {
            case 106: {
                n = 0;
                break;
            }
            case 107: {
                n = this.read2BE();
                break;
            }
            case 108: {
                n = this.read4BE();
                break;
            }
            default: {
                throw new OtpErlangDecodeException("Not valid list tag: " + n2);
            }
        }
        return n;
    }

    public int read_tuple_head() throws OtpErlangDecodeException {
        int n = 0;
        int n2 = this.read1skip_version();
        switch (n2) {
            case 104: {
                n = this.read1();
                break;
            }
            case 105: {
                n = this.read4BE();
                break;
            }
            default: {
                throw new OtpErlangDecodeException("Not valid tuple tag: " + n2);
            }
        }
        return n;
    }

    public int read_nil() throws OtpErlangDecodeException {
        int n = 0;
        int n2 = this.read1skip_version();
        switch (n2) {
            case 106: {
                n = 0;
                break;
            }
            default: {
                throw new OtpErlangDecodeException("Not valid nil tag: " + n2);
            }
        }
        return n;
    }

    public OtpErlangPid read_pid() throws OtpErlangDecodeException {
        int n = this.read1skip_version();
        if (n != 103 && n != 88) {
            throw new OtpErlangDecodeException("Wrong tag encountered, expected 103 or 88, got " + n);
        }
        String string = this.read_atom();
        int n2 = this.read4BE();
        int n3 = this.read4BE();
        int n4 = n == 103 ? this.read1() : this.read4BE();
        return new OtpErlangPid(n, string, n2, n3, n4);
    }

    public OtpErlangPort read_port() throws OtpErlangDecodeException {
        int n;
        long l;
        int n2 = this.read1skip_version();
        if (n2 != 102 && n2 != 89 && n2 != 120) {
            throw new OtpErlangDecodeException("Wrong tag encountered, expected 102, 89, or 120, got " + n2);
        }
        String string = this.read_atom();
        if (n2 == 120) {
            l = this.read8BE();
            n = this.read4BE();
        } else if (n2 == 89) {
            l = this.read4BE();
            n = this.read4BE();
        } else {
            l = this.read4BE();
            n = this.read1();
        }
        return new OtpErlangPort(n2, string, l, n);
    }

    public OtpErlangRef read_ref() throws OtpErlangDecodeException {
        int n = this.read1skip_version();
        switch (n) {
            case 101: {
                String string = this.read_atom();
                int n2 = this.read4BE() & 0x3FFFF;
                int n3 = this.read1() & 3;
                return new OtpErlangRef(string, n2, n3);
            }
            case 90: 
            case 114: {
                int n4 = this.read2BE();
                if (n4 > 5) {
                    throw new OtpErlangDecodeException("Ref arity " + n4 + " too large ");
                }
                String string = this.read_atom();
                int n5 = n == 114 ? this.read1() : this.read4BE();
                int[] nArray = new int[n4];
                for (int i = 0; i < n4; ++i) {
                    nArray[i] = this.read4BE();
                }
                return new OtpErlangRef(n, string, nArray, n5);
            }
        }
        throw new OtpErlangDecodeException("Wrong tag encountered, expected ref, got " + n);
    }

    public OtpErlangFun read_fun() throws OtpErlangDecodeException {
        int n = this.read1skip_version();
        if (n == 117) {
            int n2 = this.read4BE();
            OtpErlangPid otpErlangPid = this.read_pid();
            String string = this.read_atom();
            long l = this.read_long();
            long l2 = this.read_long();
            OtpErlangObject[] otpErlangObjectArray = new OtpErlangObject[n2];
            for (int i = 0; i < n2; ++i) {
                otpErlangObjectArray[i] = this.read_any();
            }
            return new OtpErlangFun(otpErlangPid, string, l, l2, otpErlangObjectArray);
        }
        if (n == 112) {
            this.read4BE();
            int n3 = this.read1();
            byte[] byArray = new byte[16];
            this.readN(byArray);
            int n4 = this.read4BE();
            int n5 = this.read4BE();
            String string = this.read_atom();
            long l = this.read_long();
            long l3 = this.read_long();
            OtpErlangPid otpErlangPid = this.read_pid();
            OtpErlangObject[] otpErlangObjectArray = new OtpErlangObject[n5];
            for (int i = 0; i < n5; ++i) {
                otpErlangObjectArray[i] = this.read_any();
            }
            return new OtpErlangFun(otpErlangPid, string, n3, byArray, n4, l, l3, otpErlangObjectArray);
        }
        throw new OtpErlangDecodeException("Wrong tag encountered, expected fun, got " + n);
    }

    public OtpErlangExternalFun read_external_fun() throws OtpErlangDecodeException {
        int n = this.read1skip_version();
        if (n != 113) {
            throw new OtpErlangDecodeException("Wrong tag encountered, expected external fun, got " + n);
        }
        String string = this.read_atom();
        String string2 = this.read_atom();
        int n2 = (int)this.read_long();
        return new OtpErlangExternalFun(string, string2, n2);
    }

    public String read_string() throws OtpErlangDecodeException {
        int n = this.read1skip_version();
        switch (n) {
            case 107: {
                int n2 = this.read2BE();
                byte[] byArray = new byte[n2];
                this.readN(byArray);
                return OtpErlangString.newString(byArray);
            }
            case 106: {
                return "";
            }
            case 108: {
                int n3 = this.read4BE();
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = this.read_int();
                    if (OtpErlangString.isValidCodePoint(nArray[i])) continue;
                    throw new OtpErlangDecodeException("Invalid CodePoint: " + nArray[i]);
                }
                this.read_nil();
                return new String(nArray, 0, nArray.length);
            }
        }
        throw new OtpErlangDecodeException("Wrong tag encountered, expected 107 or 108, got " + n);
    }

    public OtpErlangObject read_compressed() throws OtpErlangDecodeException {
        int n = this.read1skip_version();
        if (n != 80) {
            throw new OtpErlangDecodeException("Wrong tag encountered, expected 80, got " + n);
        }
        int n2 = this.read4BE();
        byte[] byArray = new byte[n2];
        InflaterInputStream inflaterInputStream = new InflaterInputStream(this, new Inflater(), n2);
        try {
            int n3;
            int n4;
            for (n3 = 0; n3 < n2 && (n4 = inflaterInputStream.read(byArray, n3, n2 - n3)) != -1; n3 += n4) {
            }
            if (n3 != n2) {
                throw new OtpErlangDecodeException("Decompression gave " + n3 + " bytes, not " + n2);
            }
        }
        catch (IOException iOException) {
            throw new OtpErlangDecodeException("Cannot read from input stream");
        }
        OtpInputStream otpInputStream = new OtpInputStream(byArray, this.flags);
        return otpInputStream.read_any();
    }

    public OtpErlangObject read_any() throws OtpErlangDecodeException {
        int n = this.peek1skip_version();
        switch (n) {
            case 97: 
            case 98: 
            case 110: 
            case 111: {
                return new OtpErlangLong(this);
            }
            case 100: 
            case 118: 
            case 119: {
                return new OtpErlangAtom(this);
            }
            case 70: 
            case 99: {
                return new OtpErlangDouble(this);
            }
            case 90: 
            case 101: 
            case 114: {
                return new OtpErlangRef(this);
            }
            case 116: {
                return new OtpErlangMap(this);
            }
            case 89: 
            case 102: 
            case 120: {
                return new OtpErlangPort(this);
            }
            case 88: 
            case 103: {
                return new OtpErlangPid(this);
            }
            case 107: {
                return new OtpErlangString(this);
            }
            case 106: 
            case 108: {
                if ((this.flags & DECODE_INT_LISTS_AS_STRINGS) != 0) {
                    int n2 = this.getPos();
                    try {
                        return new OtpErlangString(this);
                    }
                    catch (OtpErlangDecodeException otpErlangDecodeException) {
                        this.setPos(n2);
                    }
                }
                return new OtpErlangList(this);
            }
            case 104: 
            case 105: {
                return new OtpErlangTuple(this);
            }
            case 109: {
                return new OtpErlangBinary(this);
            }
            case 77: {
                return new OtpErlangBitstr(this);
            }
            case 80: {
                return this.read_compressed();
            }
            case 112: 
            case 117: {
                return new OtpErlangFun(this);
            }
            case 113: {
                return new OtpErlangExternalFun(this);
            }
        }
        throw new OtpErlangDecodeException("Unknown data type: " + n);
    }

    public int read_map_head() throws OtpErlangDecodeException {
        int n = 0;
        int n2 = this.read1skip_version();
        switch (n2) {
            case 116: {
                n = this.read4BE();
                break;
            }
            default: {
                throw new OtpErlangDecodeException("Not valid map tag: " + n2);
            }
        }
        return n;
    }
}

