/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateGPSAltitude;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.fibs.geotag.util.Units;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class EditAltitudeTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(EditAltitudeTask.class);
    private ImageInfo imageInfo;
    private String newAltitude;
    private ImageInfo.DATA_SOURCE dataSource;

    public EditAltitudeTask(String name, ImageInfo imageInfo, String newAltitude, ImageInfo.DATA_SOURCE dataSource) {
        super(null, name);
        this.imageInfo = imageInfo;
        this.newAltitude = newAltitude;
        this.dataSource = dataSource;
    }

    @Override
    public int getCurrentProgress() {
        return 1;
    }

    @Override
    public int getMaxProgress() {
        return 1;
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        if (this.imageInfo != null) {
            Units.ALTITUDE altitudeUnit = Units.ALTITUDE.values()[Settings.get(Settings.SETTING.ALTITUDE_UNIT, 0)];
            if (this.newAltitude.length() == 0) {
                new UpdateGPSAltitude(this.imageInfo, null, this.dataSource, altitudeUnit);
            } else {
                new UpdateGPSAltitude(this.imageInfo, this.newAltitude, this.dataSource, altitudeUnit);
            }
            this.publish(this.imageInfo);
        }
        return i18n.tr("Altitude edited");
    }
}

