/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.util.IllegalFormatException;
import java.util.List;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateGPSAltitude;
import org.fibs.geotag.geonames.AltitudeHandler;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.fibs.geotag.util.Units;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class FindAltitudeTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(FindAltitudeTask.class);
    private ImagesTableModel imagesTableModel;
    private List<ImageInfo> imageInfos;
    private int currentProgress = 0;

    public FindAltitudeTask(String group, String name, ImagesTableModel imagestableModel, List<ImageInfo> imageInfos) {
        super(group, name);
        this.imagesTableModel = imagestableModel;
        this.imageInfos = imageInfos;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getMaxProgress() {
        return this.imageInfos.size();
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        int altitudesFound = 0;
        for (ImageInfo imageInfo : this.imageInfos) {
            if (this.interruptRequested()) break;
            ++this.currentProgress;
            this.setProgressMessage();
            try {
                AltitudeHandler altitudeHandler = new AltitudeHandler(imageInfo.getGpsLatitude(), imageInfo.getGpsLongitude());
                String altitude = altitudeHandler.getAltitude();
                if (altitude == null) continue;
                if (!altitude.startsWith("-32768")) {
                    new UpdateGPSAltitude(imageInfo, altitude, ImageInfo.DATA_SOURCE.GEONAMES, Units.ALTITUDE.METRES);
                    ++altitudesFound;
                }
                this.publish(imageInfo);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        String result = null;
        if (altitudesFound == 1) {
            result = i18n.tr("One altitude found");
        } else {
            try {
                result = String.format(i18n.tr("%d altitudes found"), altitudesFound);
            }
            catch (IllegalFormatException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    protected void process(List<ImageInfo> chunks) {
        for (ImageInfo imageInfo : chunks) {
            int imageRow = this.imagesTableModel.getRow(imageInfo);
            this.imagesTableModel.fireTableRowsUpdated(imageRow, imageRow);
        }
    }
}

