/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf;

import jadx.api.IJadxArgs;
import jadx.core.deobf.DeobfClsInfo;
import jadx.core.deobf.DeobfPresets;
import jadx.core.deobf.NameMapper;
import jadx.core.deobf.OverridedMethodsNode;
import jadx.core.deobf.PackageNode;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.SourceFileAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deobfuscator {
    private static final Logger LOG = LoggerFactory.getLogger(Deobfuscator.class);
    private static final boolean DEBUG = false;
    public static final String CLASS_NAME_SEPARATOR = ".";
    public static final String INNER_CLASS_SEPARATOR = "$";
    private final IJadxArgs args;
    @NotNull
    private final List<DexNode> dexNodes;
    private final DeobfPresets deobfPresets;
    private final Map<ClassInfo, DeobfClsInfo> clsMap = new HashMap<ClassInfo, DeobfClsInfo>();
    private final Map<FieldInfo, String> fldMap = new HashMap<FieldInfo, String>();
    private final Map<MethodInfo, String> mthMap = new HashMap<MethodInfo, String>();
    private final Map<MethodInfo, OverridedMethodsNode> ovrdMap = new HashMap<MethodInfo, OverridedMethodsNode>();
    private final List<OverridedMethodsNode> ovrd = new ArrayList<OverridedMethodsNode>();
    private final PackageNode rootPackage = new PackageNode("");
    private final Set<String> pkgSet = new TreeSet<String>();
    private final int maxLength;
    private final int minLength;
    private final boolean useSourceNameAsAlias;
    private int pkgIndex = 0;
    private int clsIndex = 0;
    private int fldIndex = 0;
    private int mthIndex = 0;

    public Deobfuscator(IJadxArgs args, @NotNull List<DexNode> dexNodes, File deobfMapFile) {
        this.args = args;
        this.dexNodes = dexNodes;
        this.minLength = args.getDeobfuscationMinLength();
        this.maxLength = args.getDeobfuscationMaxLength();
        this.useSourceNameAsAlias = args.useSourceNameAsClassAlias();
        this.deobfPresets = new DeobfPresets(this, deobfMapFile);
    }

    public void execute() {
        if (!this.args.isDeobfuscationForceSave()) {
            this.deobfPresets.load();
            this.initIndexes();
        }
        this.process();
        this.deobfPresets.save(this.args.isDeobfuscationForceSave());
        this.clear();
    }

    private void initIndexes() {
        this.pkgIndex = this.pkgSet.size();
        this.clsIndex = this.deobfPresets.getClsPresetMap().size();
        this.fldIndex = this.deobfPresets.getFldPresetMap().size();
        this.mthIndex = this.deobfPresets.getMthPresetMap().size();
    }

    private void preProcess() {
        for (DexNode dexNode : this.dexNodes) {
            for (ClassNode cls : dexNode.getClasses()) {
                this.doClass(cls);
            }
        }
    }

    private void process() {
        this.preProcess();
        for (DexNode dexNode : this.dexNodes) {
            for (ClassNode cls : dexNode.getClasses()) {
                this.processClass(dexNode, cls);
            }
        }
        this.postProcess();
    }

    private void postProcess() {
        int id = 1;
        for (OverridedMethodsNode o : this.ovrd) {
            Iterator<MethodInfo> it = o.getMethods().iterator();
            if (it.hasNext()) {
                MethodInfo mth = it.next();
                if (mth.isRenamed() && !mth.isAliasFromPreset()) {
                    mth.setAlias(String.format("mo%d%s", id, this.makeName(mth.getName())));
                }
                String firstMethodAlias = mth.getAlias();
                while (it.hasNext()) {
                    mth = it.next();
                    if (mth.getAlias().equals(firstMethodAlias)) continue;
                    mth.setAlias(firstMethodAlias);
                }
            }
            ++id;
        }
    }

    void clear() {
        this.deobfPresets.clear();
        this.clsMap.clear();
        this.fldMap.clear();
        this.mthMap.clear();
        this.ovrd.clear();
        this.ovrdMap.clear();
    }

    @Nullable
    private static ClassNode resolveOverridingInternal(DexNode dex, ClassNode cls, String signature, Set<MethodInfo> overrideSet, ClassNode rootClass) {
        ClassNode clsWithMth;
        ClassNode superNode;
        ArgType superClass;
        ClassNode result = null;
        for (MethodNode m : cls.getMethods()) {
            if (!m.getMethodInfo().getShortId().startsWith(signature)) continue;
            result = cls;
            if (overrideSet.contains(m.getMethodInfo())) break;
            overrideSet.add(m.getMethodInfo());
            break;
        }
        if ((superClass = cls.getSuperClass()) != null && (superNode = dex.resolveClass(superClass)) != null && (clsWithMth = Deobfuscator.resolveOverridingInternal(dex, superNode, signature, overrideSet, rootClass)) != null) {
            if (result != null && result != cls) {
                if (clsWithMth != result) {
                    LOG.warn(String.format("Multiple overriding '%s' from '%s' and '%s' in '%s'", signature, result.getFullName(), clsWithMth.getFullName(), rootClass.getFullName()));
                }
            } else {
                result = clsWithMth;
            }
        }
        for (ArgType iFaceType : cls.getInterfaces()) {
            ClassNode clsWithMth2;
            ClassNode iFaceNode = dex.resolveClass(iFaceType);
            if (iFaceNode == null || (clsWithMth2 = Deobfuscator.resolveOverridingInternal(dex, iFaceNode, signature, overrideSet, rootClass)) == null) continue;
            if (result != null && result != cls) {
                if (clsWithMth2 == result) continue;
                LOG.warn(String.format("Multiple overriding '%s' from '%s' and '%s' in '%s'", signature, result.getFullName(), clsWithMth2.getFullName(), rootClass.getFullName()));
                continue;
            }
            result = clsWithMth2;
        }
        return result;
    }

    private void resolveOverriding(DexNode dex, ClassNode cls, MethodNode mth) {
        HashSet<MethodInfo> overrideSet = new HashSet<MethodInfo>();
        Deobfuscator.resolveOverridingInternal(dex, cls, mth.getMethodInfo().makeSignature(false), overrideSet, cls);
        if (overrideSet.size() > 1) {
            OverridedMethodsNode overrideNode = null;
            for (MethodInfo _mth : overrideSet) {
                if (!this.ovrdMap.containsKey(_mth)) continue;
                overrideNode = this.ovrdMap.get(_mth);
                break;
            }
            if (overrideNode == null) {
                overrideNode = new OverridedMethodsNode(overrideSet);
                this.ovrd.add(overrideNode);
            }
            for (MethodInfo _mth : overrideSet) {
                if (this.ovrdMap.containsKey(_mth)) continue;
                this.ovrdMap.put(_mth, overrideNode);
                if (overrideNode.contains(_mth)) continue;
                overrideNode.add(_mth);
            }
        } else {
            overrideSet.clear();
            overrideSet = null;
        }
    }

    private void processClass(DexNode dex, ClassNode cls) {
        String alias;
        ClassInfo clsInfo = cls.getClassInfo();
        String fullName = this.getClassFullName(clsInfo);
        if (!fullName.equals(clsInfo.getFullName())) {
            clsInfo.rename(dex, fullName);
        }
        for (FieldNode field : cls.getFields()) {
            FieldInfo fieldInfo = field.getFieldInfo();
            alias = this.getFieldAlias(field);
            if (alias == null) continue;
            fieldInfo.setAlias(alias);
        }
        for (MethodNode mth : cls.getMethods()) {
            MethodInfo methodInfo = mth.getMethodInfo();
            alias = this.getMethodAlias(mth);
            if (alias != null) {
                methodInfo.setAlias(alias);
            }
            if (!mth.isVirtual()) continue;
            this.resolveOverriding(dex, cls, mth);
        }
    }

    public void addPackagePreset(String origPkgName, String pkgAlias) {
        PackageNode pkg = this.getPackageNode(origPkgName, true);
        pkg.setAlias(pkgAlias);
    }

    private PackageNode getPackageNode(String fullPkgName, boolean create) {
        if (fullPkgName.isEmpty() || fullPkgName.equals(CLASS_NAME_SEPARATOR)) {
            return this.rootPackage;
        }
        PackageNode result = this.rootPackage;
        do {
            String pkgName;
            int idx;
            if ((idx = fullPkgName.indexOf(CLASS_NAME_SEPARATOR)) > -1) {
                pkgName = fullPkgName.substring(0, idx);
                fullPkgName = fullPkgName.substring(idx + 1);
            } else {
                pkgName = fullPkgName;
                fullPkgName = "";
            }
            PackageNode parentNode = result;
            result = result.getInnerPackageByName(pkgName);
            if (result != null || !create) continue;
            result = new PackageNode(pkgName);
            parentNode.addInnerPackage(result);
        } while (!fullPkgName.isEmpty() && result != null);
        return result;
    }

    String getNameWithoutPackage(ClassInfo clsInfo) {
        String prefix;
        ClassInfo parentClsInfo = clsInfo.getParentClass();
        if (parentClsInfo != null) {
            DeobfClsInfo parentDeobfClsInfo = this.clsMap.get(parentClsInfo);
            prefix = parentDeobfClsInfo != null ? parentDeobfClsInfo.makeNameWithoutPkg() : this.getNameWithoutPackage(parentClsInfo);
            prefix = prefix + INNER_CLASS_SEPARATOR;
        } else {
            prefix = "";
        }
        return prefix + clsInfo.getShortName();
    }

    private void doClass(ClassNode cls) {
        ClassInfo classInfo = cls.getClassInfo();
        String pkgFullName = classInfo.getPackage();
        PackageNode pkg = this.getPackageNode(pkgFullName, true);
        this.doPkg(pkg, pkgFullName);
        String alias = this.deobfPresets.getForCls(classInfo);
        if (alias != null) {
            this.clsMap.put(classInfo, new DeobfClsInfo(this, cls, pkg, alias));
            return;
        }
        if (this.clsMap.containsKey(classInfo)) {
            return;
        }
        if (this.shouldRename(classInfo.getShortName())) {
            this.makeClsAlias(cls);
        }
    }

    public String getClsAlias(ClassNode cls) {
        DeobfClsInfo deobfClsInfo = this.clsMap.get(cls.getClassInfo());
        if (deobfClsInfo != null) {
            return deobfClsInfo.getAlias();
        }
        return this.makeClsAlias(cls);
    }

    private String makeClsAlias(ClassNode cls) {
        ClassInfo classInfo = cls.getClassInfo();
        String alias = null;
        if (this.useSourceNameAsAlias) {
            alias = this.getAliasFromSourceFile(cls);
        }
        if (alias == null) {
            String clsName = classInfo.getShortName();
            alias = String.format("C%04d%s", this.clsIndex++, this.makeName(clsName));
        }
        PackageNode pkg = this.getPackageNode(classInfo.getPackage(), true);
        this.clsMap.put(classInfo, new DeobfClsInfo(this, cls, pkg, alias));
        return alias;
    }

    @Nullable
    private String getAliasFromSourceFile(ClassNode cls) {
        SourceFileAttr sourceFileAttr = cls.get(AType.SOURCE_FILE);
        if (sourceFileAttr == null) {
            return null;
        }
        String name = sourceFileAttr.getFileName();
        if (name.endsWith(".java")) {
            name = name.substring(0, name.length() - ".java".length());
        }
        if (NameMapper.isValidIdentifier(name) && !NameMapper.isReserved(name)) {
            cls.remove(AType.SOURCE_FILE);
            return name;
        }
        return null;
    }

    @Nullable
    public String getFieldAlias(FieldNode field) {
        FieldInfo fieldInfo = field.getFieldInfo();
        String alias = this.fldMap.get(fieldInfo);
        if (alias != null) {
            return alias;
        }
        alias = this.deobfPresets.getForFld(fieldInfo);
        if (alias != null) {
            this.fldMap.put(fieldInfo, alias);
            return alias;
        }
        if (this.shouldRename(field.getName())) {
            return this.makeFieldAlias(field);
        }
        return null;
    }

    @Nullable
    public String getMethodAlias(MethodNode mth) {
        MethodInfo methodInfo = mth.getMethodInfo();
        String alias = this.mthMap.get(methodInfo);
        if (alias != null) {
            return alias;
        }
        alias = this.deobfPresets.getForMth(methodInfo);
        if (alias != null) {
            this.mthMap.put(methodInfo, alias);
            methodInfo.setAliasFromPreset(true);
            return alias;
        }
        if (this.shouldRename(mth.getName())) {
            return this.makeMethodAlias(mth);
        }
        return null;
    }

    public String makeFieldAlias(FieldNode field) {
        String alias = String.format("f%d%s", this.fldIndex++, this.makeName(field.getName()));
        this.fldMap.put(field.getFieldInfo(), alias);
        return alias;
    }

    public String makeMethodAlias(MethodNode mth) {
        String alias = String.format("m%d%s", this.mthIndex++, this.makeName(mth.getName()));
        this.mthMap.put(mth.getMethodInfo(), alias);
        return alias;
    }

    private void doPkg(PackageNode pkg, String fullName) {
        if (this.pkgSet.contains(fullName)) {
            return;
        }
        this.pkgSet.add(fullName);
        PackageNode parentPkg = pkg.getParentPackage();
        while (!parentPkg.getName().isEmpty()) {
            if (!parentPkg.hasAlias()) {
                this.doPkg(parentPkg, parentPkg.getFullName());
            }
            parentPkg = parentPkg.getParentPackage();
        }
        String pkgName = pkg.getName();
        if (!pkg.hasAlias() && this.shouldRename(pkgName)) {
            String pkgAlias = String.format("p%03d%s", this.pkgIndex++, this.makeName(pkgName));
            pkg.setAlias(pkgAlias);
        }
    }

    private boolean shouldRename(String s) {
        return s.length() > this.maxLength || s.length() < this.minLength || NameMapper.isReserved(s) || !NameMapper.isAllCharsPrintable(s);
    }

    private String makeName(String name) {
        if (name.length() > this.maxLength) {
            return "x" + Integer.toHexString(name.hashCode());
        }
        if (NameMapper.isReserved(name)) {
            return name;
        }
        if (!NameMapper.isAllCharsPrintable(name)) {
            return this.removeInvalidChars(name);
        }
        return name;
    }

    private String removeInvalidChars(String name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!NameMapper.isPrintableChar(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    private void dumpClassAlias(ClassNode cls) {
        PackageNode pkg = this.getPackageNode(cls.getPackage(), false);
        if (pkg != null) {
            if (!cls.getFullName().equals(this.getClassFullName(cls))) {
                LOG.info("Alias name for class '{}' is '{}'", (Object)cls.getFullName(), (Object)this.getClassFullName(cls));
            }
        } else {
            LOG.error("Can't find package node for '{}'", (Object)cls.getPackage());
        }
    }

    private void dumpAlias() {
        for (DexNode dexNode : this.dexNodes) {
            for (ClassNode cls : dexNode.getClasses()) {
                this.dumpClassAlias(cls);
            }
        }
    }

    private String getPackageName(String packageName) {
        PackageNode pkg = this.getPackageNode(packageName, false);
        if (pkg != null) {
            return pkg.getFullAlias();
        }
        return packageName;
    }

    private String getClassName(ClassInfo clsInfo) {
        DeobfClsInfo deobfClsInfo = this.clsMap.get(clsInfo);
        if (deobfClsInfo != null) {
            return deobfClsInfo.makeNameWithoutPkg();
        }
        return this.getNameWithoutPackage(clsInfo);
    }

    private String getClassFullName(ClassNode cls) {
        return this.getClassFullName(cls.getClassInfo());
    }

    private String getClassFullName(ClassInfo clsInfo) {
        DeobfClsInfo deobfClsInfo = this.clsMap.get(clsInfo);
        if (deobfClsInfo != null) {
            return deobfClsInfo.getFullName();
        }
        return this.getPackageName(clsInfo.getPackage()) + CLASS_NAME_SEPARATOR + this.getClassName(clsInfo);
    }

    public Map<ClassInfo, DeobfClsInfo> getClsMap() {
        return this.clsMap;
    }

    public Map<FieldInfo, String> getFldMap() {
        return this.fldMap;
    }

    public Map<MethodInfo, String> getMthMap() {
        return this.mthMap;
    }

    public PackageNode getRootPackage() {
        return this.rootPackage;
    }
}

