/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.util.List;
import org.apache.commons.jcs3.auxiliary.remote.AbstractRemoteCacheNoWaitFacade;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheFactory;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheFailoverRunner;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs3.engine.CacheStatus;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class RemoteCacheNoWaitFacade<K, V>
extends AbstractRemoteCacheNoWaitFacade<K, V> {
    private static final Log log = LogManager.getLog(RemoteCacheNoWaitFacade.class);
    private final RemoteCacheFactory cacheFactory;

    public RemoteCacheNoWaitFacade(List<RemoteCacheNoWait<K, V>> noWaits, IRemoteCacheAttributes rca, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer, RemoteCacheFactory cacheFactory) {
        super(noWaits, rca, cacheEventLogger, elementSerializer);
        this.cacheFactory = cacheFactory;
    }

    @Override
    protected void failover(RemoteCacheNoWait<K, V> rcnw) {
        log.debug("in failover for {0}", rcnw);
        if (this.getAuxiliaryCacheAttributes().getRemoteType() == RemoteType.LOCAL) {
            if (rcnw.getStatus() == CacheStatus.ERROR) {
                RemoteCacheFailoverRunner runner = new RemoteCacheFailoverRunner(this, this.cacheFactory);
                runner.setDaemon(true);
                runner.start();
                runner.notifyError();
                if (this.getCacheEventLogger() != null) {
                    this.getCacheEventLogger().logApplicationEvent("RemoteCacheNoWaitFacade", "InitiatedFailover", rcnw + " was in error.");
                }
            } else {
                log.info("The noWait is not in error");
            }
        }
    }
}

