/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class InitialInferenceState {
    private final List<InferenceVariable> myInferenceVariables;
    private final PsiElement myContext;
    private final PsiSubstitutor myInferenceSubstitutor;
    private final PsiSubstitutor mySiteSubstitutor;
    private final ArrayList<Pair<InferenceVariable[], PsiClassType>> myCaptures;
    private final InferenceSessionContainer myInferenceSessionContainer;
    private final boolean myErased;

    InitialInferenceState(Collection<VariableInfo> inferenceVariables, PsiSubstitutor topInferenceSubstitutor, PsiElement context2, PsiSubstitutor inferenceSubstitutor, PsiSubstitutor siteSubstitutor, List<Pair<InferenceVariable[], PsiClassType>> captures, boolean erased, InferenceSessionContainer inferenceSessionContainer) {
        this.myErased = erased;
        this.myInferenceVariables = new ArrayList<InferenceVariable>(inferenceVariables.size());
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (VariableInfo variableInfo : inferenceVariables) {
            if (!(variableInfo.myResolved instanceof InferenceVariable)) continue;
            this.myInferenceVariables.add((InferenceVariable)variableInfo.myResolved);
            if (!inferenceSubstitutor.getSubstitutionMap().containsValue(variableInfo.myType)) continue;
            substitutor2 = substitutor2.put(variableInfo.myVariable.getParameter(), variableInfo.mySubstituted);
            subst = subst.put(variableInfo.myVariable, variableInfo.mySubstituted);
        }
        this.myInferenceSubstitutor = substitutor2;
        this.myContext = context2;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myCaptures = new ArrayList();
        for (Pair pair : captures) {
            InferenceVariable[] newParameters = new InferenceVariable[((InferenceVariable[])pair.first).length];
            InferenceVariable[] parameters2 = (InferenceVariable[])pair.first;
            for (int i = 0; i < parameters2.length; ++i) {
                PsiType substitute2 = topInferenceSubstitutor.substitute(parameters2[i]);
                newParameters[i] = (InferenceVariable)PsiUtil.resolveClassInClassTypeOnly(substitute2);
            }
            this.myCaptures.add(Pair.create(newParameters, (PsiClassType)topInferenceSubstitutor.substitute(subst.substitute((PsiType)pair.second))));
        }
        this.myInferenceSessionContainer = inferenceSessionContainer;
    }

    InferenceSessionContainer getInferenceSessionContainer() {
        return this.myInferenceSessionContainer;
    }

    List<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    PsiSubstitutor getInferenceSubstitutor() {
        return this.myInferenceSubstitutor;
    }

    PsiSubstitutor getSiteSubstitutor() {
        return this.mySiteSubstitutor;
    }

    public ArrayList<Pair<InferenceVariable[], PsiClassType>> getCaptures() {
        return this.myCaptures;
    }

    public boolean isErased() {
        return this.myErased;
    }

    static class VariableInfo {
        final InferenceVariable myVariable;
        final PsiType mySubstituted;
        final PsiClass myResolved;
        final PsiClassType myType;

        VariableInfo(InferenceVariable variable2, PsiSubstitutor substitutor2, PsiElementFactory factory2) {
            this.myVariable = variable2;
            this.mySubstituted = substitutor2.substitute(variable2);
            this.myResolved = PsiUtil.resolveClassInClassTypeOnly(this.mySubstituted);
            this.myType = factory2.createType(variable2);
        }
    }
}

