/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class PsiClassUtil {
    private PsiClassUtil() {
    }

    public static boolean isRunnableClass(PsiClass aClass, boolean mustBePublic) {
        return PsiClassUtil.isRunnableClass(aClass, mustBePublic, true);
    }

    public static boolean isRunnableClass(PsiClass aClass, boolean mustBePublic, boolean mustNotBeAbstract) {
        if (aClass instanceof PsiAnonymousClass) {
            return false;
        }
        if (mustBePublic && !aClass.hasModifierProperty("public") && (mustNotBeAbstract || !aClass.hasModifierProperty("abstract"))) {
            return false;
        }
        if (aClass.hasModifierProperty("private")) {
            return false;
        }
        if (mustNotBeAbstract && aClass.hasModifierProperty("abstract")) {
            return false;
        }
        return aClass.getContainingClass() == null || aClass.hasModifierProperty("static");
    }

    @NotNull
    public static Comparator<PsiClass> createScopeComparator(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            PsiClassUtil.$$$reportNull$$$0(0);
        }
        Comparator comparator = (c1, c2) -> {
            VirtualFile file1 = PsiUtilCore.getVirtualFile(c1);
            VirtualFile file2 = PsiUtilCore.getVirtualFile(c2);
            if (file1 == null) {
                return file2 == null ? 0 : -1;
            }
            if (file2 == null) {
                return 1;
            }
            return scope2.compare(file2, file1);
        };
        if (comparator == null) {
            PsiClassUtil.$$$reportNull$$$0(1);
        }
        return comparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiClassUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiClassUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createScopeComparator";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

