/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTableKt;
import org.jetbrains.kotlin.backend.common.serialization.IdSignatureClashTracker;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureSerializer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000eJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0004R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "", "signaturer", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "(Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;)V", "clashTracker", "Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureClashTracker;", "(Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureClashTracker;)V", "getSignaturer", "()Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;", "table", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getTable", "()Ljava/util/Map;", "computeSignatureByDeclaration", "declaration", "isExportedDeclaration", "", "loadKnownBuiltins", "", "builtIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "ir.serialization.common"})
public abstract class GlobalDeclarationTable {
    @NotNull
    private final IdSignatureSerializer signaturer;
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    @NotNull
    private final IdSignatureClashTracker clashTracker;
    @NotNull
    private final Map<IrDeclaration, IdSignature> table;

    public GlobalDeclarationTable(@NotNull IdSignatureSerializer signaturer, @NotNull KotlinMangler.IrMangler mangler, @NotNull IdSignatureClashTracker clashTracker) {
        Intrinsics.checkNotNullParameter(signaturer, "signaturer");
        Intrinsics.checkNotNullParameter(mangler, "mangler");
        Intrinsics.checkNotNullParameter(clashTracker, "clashTracker");
        this.signaturer = signaturer;
        this.mangler = mangler;
        this.clashTracker = clashTracker;
        boolean bl = false;
        this.table = new LinkedHashMap();
    }

    @NotNull
    public final IdSignatureSerializer getSignaturer() {
        return this.signaturer;
    }

    @NotNull
    protected final Map<IrDeclaration, IdSignature> getTable() {
        return this.table;
    }

    public GlobalDeclarationTable(@NotNull IdSignatureSerializer signaturer, @NotNull KotlinMangler.IrMangler mangler) {
        Intrinsics.checkNotNullParameter(signaturer, "signaturer");
        Intrinsics.checkNotNullParameter(mangler, "mangler");
        this(signaturer, mangler, IdSignatureClashTracker.Companion.getDEFAULT_TRACKER());
    }

    protected final void loadKnownBuiltins(@NotNull IrBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Iterable $this$forEach$iv = DeclarationTableKt.getKnownBuiltins(builtIns);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            IrSymbol symbol2 = it.getSymbol();
            Map<IrDeclaration, IdSignature> map = this.getTable();
            IdSignature idSignature = symbol2.getSignature();
            Intrinsics.checkNotNull(idSignature);
            boolean bl2 = false;
            boolean bl3 = false;
            IdSignature id = idSignature;
            boolean bl4 = false;
            this.clashTracker.commit(it, id);
            bl2 = false;
            map.put(it, idSignature);
        }
    }

    @NotNull
    public IdSignature computeSignatureByDeclaration(@NotNull IrDeclaration declaration2) {
        IdSignature idSignature;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Map<IrDeclaration, IdSignature> $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        IdSignature value$iv = $this$getOrPut$iv.get(declaration2);
        if (value$iv == null) {
            boolean bl = false;
            IdSignature idSignature2 = this.getSignaturer().composePublicIdSignature(declaration2);
            boolean bl2 = false;
            boolean bl3 = false;
            IdSignature it = idSignature2;
            boolean bl4 = false;
            this.clashTracker.commit(declaration2, it);
            IdSignature answer$iv = idSignature2;
            $this$getOrPut$iv.put(declaration2, answer$iv);
            idSignature = answer$iv;
        } else {
            idSignature = value$iv;
        }
        return idSignature;
    }

    public final boolean isExportedDeclaration(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        KotlinMangler.IrMangler irMangler = this.mangler;
        boolean bl = false;
        boolean bl2 = false;
        KotlinMangler.IrMangler $this$isExportedDeclaration_u24lambda_u2d4 = irMangler;
        boolean bl3 = false;
        return $this$isExportedDeclaration_u24lambda_u2d4.isExported(declaration2);
    }
}

