/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.collectors.CheckerRunningDiagnosticCollectorVisitor;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b&\u0018\u0000 %2\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bH$J\b\u0010 \u001a\u00020!H$J\u001f\u0010\"\u001a\u00020!2\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0#\"\u00020\t\u00a2\u0006\u0002\u0010$R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "components", "", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "getComponents", "()Ljava/util/List;", "componentsInitialized", "", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "getReporter", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "visitor", "Lorg/jetbrains/kotlin/fir/analysis/collectors/CheckerRunningDiagnosticCollectorVisitor;", "getVisitor", "()Lorg/jetbrains/kotlin/fir/analysis/collectors/CheckerRunningDiagnosticCollectorVisitor;", "collectDiagnostics", "", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "firDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getCollectedDiagnostics", "initializeCollector", "", "initializeComponents", "", "([Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;)V", "Companion", "checkers"})
public abstract class AbstractDiagnosticCollector
implements SessionHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final List<AbstractDiagnosticCollectorComponent> components;
    private boolean componentsInitialized;
    @NotNull
    public static final String SUPPRESS_ALL_INFOS = "infos";
    @NotNull
    public static final String SUPPRESS_ALL_WARNINGS = "warnings";
    @NotNull
    public static final String SUPPRESS_ALL_ERRORS = "errors";

    public AbstractDiagnosticCollector(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        this.session = session2;
        this.scopeSession = scopeSession;
        boolean bl = false;
        this.components = new ArrayList();
    }

    public /* synthetic */ AbstractDiagnosticCollector(FirSession firSession, ScopeSession scopeSession, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            scopeSession = new ScopeSession();
        }
        this(firSession, scopeSession);
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @NotNull
    public final List<FirDiagnostic<?>> collectDiagnostics(@NotNull FirDeclaration firDeclaration) {
        Intrinsics.checkNotNullParameter(firDeclaration, "firDeclaration");
        if (!this.componentsInitialized) {
            throw new IllegalStateException("Components are not initialized");
        }
        this.initializeCollector();
        firDeclaration.accept(this.getVisitor(), null);
        return this.getCollectedDiagnostics();
    }

    protected abstract void initializeCollector();

    @NotNull
    protected abstract List<FirDiagnostic<?>> getCollectedDiagnostics();

    @NotNull
    public abstract DiagnosticReporter getReporter();

    @NotNull
    protected final List<AbstractDiagnosticCollectorComponent> getComponents() {
        return this.components;
    }

    @NotNull
    protected abstract CheckerRunningDiagnosticCollectorVisitor getVisitor();

    public final void initializeComponents(AbstractDiagnosticCollectorComponent ... components2) {
        Intrinsics.checkNotNullParameter(components2, "components");
        if (this.componentsInitialized) {
            throw new IllegalStateException();
        }
        AbstractDiagnosticCollector abstractDiagnosticCollector = this;
        Collection collection = abstractDiagnosticCollector.components;
        boolean bl = false;
        CollectionsKt.addAll(collection, components2);
        this.componentsInitialized = true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector$Companion;", "", "()V", "SUPPRESS_ALL_ERRORS", "", "SUPPRESS_ALL_INFOS", "SUPPRESS_ALL_WARNINGS", "getDiagnosticsSuppressedForContainer", "", "annotationContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "checkers"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<String> getDiagnosticsSuppressedForContainer(@NotNull FirAnnotationContainer annotationContainer) {
            void $this$flatMapTo$iv$iv;
            ConeClassLikeType type2;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(annotationContainer, "annotationContainer");
            Iterable $this$filter$iv = annotationContainer.getAnnotations();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                ConeClassLikeType coneClassLikeType;
                FirAnnotationCall it = (FirAnnotationCall)element$iv$iv;
                boolean bl2 = false;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef());
                ConeClassLikeType coneClassLikeType2 = coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
                if (coneClassLikeType == null) {
                    bl = false;
                } else {
                    type2 = coneClassLikeType;
                    bl = Intrinsics.areEqual(type2.getLookupTag().getClassId(), StandardClassIds.INSTANCE.getSuppress());
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List annotations2 = (List)destination$iv$iv;
            if (annotations2.isEmpty()) {
                return null;
            }
            Iterable $this$flatMap$iv = annotations2;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$flatMapTo$iv$iv2;
                void $this$flatMap$iv2;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                FirAnnotationCall annotationCall = (FirAnnotationCall)element$iv$iv;
                boolean bl = false;
                Object $this$arguments$iv = annotationCall;
                boolean $i$f$getArguments = false;
                $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$filterIsInstance = false;
                type2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv2 instanceof FirVarargArgumentsExpression)) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv2;
                boolean $i$f$flatMap2 = false;
                $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv2;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                    void $this$mapNotNullTo$iv$iv;
                    FirVarargArgumentsExpression varargArgument = (FirVarargArgumentsExpression)element$iv$iv2;
                    boolean bl3 = false;
                    Iterable $this$mapNotNull$iv = varargArgument.getArguments();
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        String string2;
                        Object element$iv$iv$iv;
                        Object element$iv$iv3 = element$iv$iv$iv = iterator2.next();
                        boolean bl4 = false;
                        FirExpression it = (FirExpression)element$iv$iv3;
                        boolean bl5 = false;
                        FirConstExpression firConstExpression = it instanceof FirConstExpression ? (FirConstExpression)it : null;
                        Object var35_36 = firConstExpression == null ? null : firConstExpression.getValue();
                        if ((var35_36 instanceof String ? (String)var35_36 : null) == null) continue;
                        string2 = string2;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        String it$iv$iv = string2;
                        boolean bl8 = false;
                        destination$iv$iv3.add(it$iv$iv);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv3;
                    CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

