/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;

class GdaJConnection {
    public Connection cnc = null;
    private HashMap<String, Savepoint> svp_map = new HashMap();
    private GdaJMeta jmeta = null;
    String driver;

    private static native void initIDs();

    public GdaJConnection(Connection connection, String string) throws Exception {
        this.cnc = connection;
        this.driver = string;
    }

    public void close() throws Exception {
        this.cnc.close();
        this.jmeta = null;
    }

    public String getServerVersion() throws Exception {
        DatabaseMetaData databaseMetaData = this.cnc.getMetaData();
        return databaseMetaData.getDatabaseProductName() + " " + databaseMetaData.getDatabaseProductVersion();
    }

    public GdaJPStmt prepareStatement(String string) throws Exception {
        PreparedStatement preparedStatement = this.cnc.prepareStatement(string);
        GdaJPStmt gdaJPStmt = new GdaJPStmt(preparedStatement);
        return gdaJPStmt;
    }

    public GdaJResultSet executeDirectSQL(String string) throws Exception {
        Statement statement = this.cnc.createStatement();
        return new GdaJResultSet(statement.executeQuery(string));
    }

    public void begin() throws Exception {
        if (!this.cnc.getAutoCommit()) {
            throw new Exception("Transaction already started");
        }
        this.cnc.setAutoCommit(false);
    }

    public void rollback() throws Exception {
        if (this.cnc.getAutoCommit()) {
            throw new Exception("No transaction started");
        }
        this.cnc.rollback();
        this.cnc.setAutoCommit(true);
    }

    public void commit() throws Exception {
        if (this.cnc.getAutoCommit()) {
            throw new Exception("No transaction started");
        }
        this.cnc.commit();
        this.cnc.setAutoCommit(true);
    }

    public void addSavepoint(String string) throws Exception {
        if (this.cnc.getAutoCommit()) {
            throw new Exception("No transaction started");
        }
        Savepoint savepoint = this.svp_map.get(string);
        if (savepoint != null) {
            throw new Exception("Savepoint '" + string + "' already exists");
        }
        savepoint = this.cnc.setSavepoint(string);
        this.svp_map.put(string, savepoint);
    }

    public void rollbackSavepoint(String string) throws Exception {
        Savepoint savepoint = null;
        if (this.cnc.getAutoCommit()) {
            throw new Exception("No transaction started");
        }
        savepoint = this.svp_map.get(string);
        if (savepoint == null) {
            throw new Exception("No savepoint '" + string + "' found");
        }
        this.cnc.rollback(savepoint);
        this.svp_map.remove(string);
    }

    public void releaseSavepoint(String string) throws Exception {
        Savepoint savepoint = null;
        if (this.cnc.getAutoCommit()) {
            throw new Exception("No transaction started");
        }
        savepoint = this.svp_map.get(string);
        if (savepoint == null) {
            throw new Exception("No savepoint '" + string + "' found");
        }
        this.cnc.releaseSavepoint(savepoint);
        this.svp_map.remove(string);
    }

    public GdaJMeta getJMeta() throws Exception {
        if (this.jmeta == null) {
            block9: {
                String string = this.driver.replace(".", "_") + "Meta";
                try {
                    Class<?> clazz = Class.forName(string);
                    Constructor<?> constructor = clazz.getConstructor(Class.forName("java.sql.Connection"));
                    this.jmeta = (GdaJMeta)constructor.newInstance(this.cnc);
                }
                catch (Exception exception) {
                    if (this.driver.contains("org.apache.derby.jdbc")) {
                        try {
                            string = "org_apache_derbyMeta";
                            Class<?> clazz = Class.forName(string);
                            Constructor<?> constructor = clazz.getConstructor(Class.forName("java.sql.Connection"));
                            this.jmeta = (GdaJMeta)constructor.newInstance(this.cnc);
                        }
                        catch (Exception exception2) {}
                    }
                    if (!this.driver.contains("sqlserver") && !this.driver.contains("com.ashna.jturbo.driver.Driver") && !this.driver.contains("com.inet.tds.TdsDriver")) break block9;
                    try {
                        string = "sqlserverMeta";
                        Class<?> clazz = Class.forName(string);
                        Constructor<?> constructor = clazz.getConstructor(Class.forName("java.sql.Connection"));
                        this.jmeta = (GdaJMeta)constructor.newInstance(this.cnc);
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
            }
            if (this.jmeta == null) {
                this.jmeta = new GdaJMeta(this.cnc);
            }
        }
        return this.jmeta;
    }

    static {
        GdaJConnection.initIDs();
    }
}

