import { ILogger } from "./ILogger";
import * as chalk from "chalk";
/**
 * Prints to the console with colors and a format.
 * @category Logging
 */
export declare class RichConsoleLogger implements ILogger {
    protected chalkDebug: chalk.Chalk;
    protected chalkInfo: chalk.Chalk;
    protected chalkWarning: chalk.Chalk;
    protected chalkError: chalk.Chalk;
    protected chalkTimestamp: chalk.Chalk;
    protected chalkModule: chalk.Chalk;
    protected getTimestamp(): string;
    debug(module: string, ...messageOrObject: any[]): void;
    error(module: string, ...messageOrObject: any[]): void;
    info(module: string, ...messageOrObject: any[]): void;
    warn(module: string, ...messageOrObject: any[]): void;
}
