/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.tool;

import javafx.event.Event;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableViewSkin;

public class TableViewColumnContextMenuHelper {
    private final TableView<?> tableView;
    private ContextMenu tableContextMenu;

    public TableViewColumnContextMenuHelper(TableView<?> tableView) {
        this.tableView = tableView;
        tableView.setTableMenuButtonVisible(true);
        tableView.skinProperty().addListener(event -> {
            tableView.tableMenuButtonVisibleProperty().addListener((observable2, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.registerListeners();
                }
            });
            if (tableView.isTableMenuButtonVisible()) {
                this.registerListeners();
            }
        });
    }

    private void registerListeners() {
        Node buttonNode = this.getMenuButton();
        assert (buttonNode != null);
        buttonNode.setOnMousePressed(event -> {
            this.showContextMenu();
            event.consume();
        });
    }

    private Node getMenuButton() {
        TableHeaderRow tableHeaderRow = this.getTableHeaderRow();
        if (tableHeaderRow == null) {
            return null;
        }
        return tableHeaderRow.getChildren().stream().filter(child -> child.getStyleClass().contains("show-hide-columns-button")).findAny().get();
    }

    private TableHeaderRow getTableHeaderRow() {
        TableViewSkin tableSkin = (TableViewSkin)this.tableView.getSkin();
        if (tableSkin == null) {
            return null;
        }
        return (TableHeaderRow)tableSkin.getChildren().stream().filter(child -> child instanceof TableHeaderRow).findAny().get();
    }

    protected void showContextMenu() {
        Node buttonNode = this.getMenuButton();
        if (this.tableContextMenu != null) {
            this.tableContextMenu.hide();
        } else {
            this.tableContextMenu = this.createContextMenu();
            this.tableContextMenu.setOnHidden(event -> {
                this.tableContextMenu = null;
            });
            this.tableContextMenu.show(buttonNode, Side.BOTTOM, 0.0, 0.0);
            assert (buttonNode != null);
            this.tableContextMenu.setX(buttonNode.localToScreen(buttonNode.getBoundsInLocal()).getMaxX() - this.tableContextMenu.getWidth());
        }
    }

    private ContextMenu createContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().add(this.createSelectAllMenuItem(contextMenu));
        contextMenu.getItems().add(this.createDeselectAllMenuItem(contextMenu));
        contextMenu.getItems().add(new SeparatorMenuItem());
        this.addColumnCustomMenuItems(contextMenu);
        return contextMenu;
    }

    private CustomMenuItem createSelectAllMenuItem(ContextMenu contextMenu) {
        Label selectAllLabel = new Label("Alle ausw\u00e4hlen");
        contextMenu.focusedProperty().addListener(event -> selectAllLabel.setPrefWidth(contextMenu.getWidth() * 0.75));
        CustomMenuItem selectAllMenuItem = new CustomMenuItem(selectAllLabel);
        selectAllMenuItem.setOnAction(this::selectAll);
        selectAllMenuItem.setHideOnClick(false);
        return selectAllMenuItem;
    }

    private void selectAll(Event event) {
        this.tableView.getColumns().forEach(column -> column.setVisible(true));
        event.consume();
    }

    private CustomMenuItem createDeselectAllMenuItem(ContextMenu contextMenu) {
        Label deselectAllLabel = new Label("Alle abw\u00e4hlen");
        contextMenu.focusedProperty().addListener(event -> deselectAllLabel.setPrefWidth(contextMenu.getWidth() * 0.75));
        CustomMenuItem deselectAllMenuItem = new CustomMenuItem(deselectAllLabel);
        deselectAllMenuItem.setOnAction(this::deselectAll);
        deselectAllMenuItem.setHideOnClick(false);
        return deselectAllMenuItem;
    }

    private void deselectAll(Event event) {
        this.tableView.getColumns().forEach(column -> column.setVisible(false));
        event.consume();
    }

    private void addColumnCustomMenuItems(ContextMenu contextMenu) {
        this.tableView.getColumns().forEach(column -> contextMenu.getItems().add(this.createColumnCustomMenuItem(contextMenu, (TableColumn<?, ?>)column)));
    }

    protected CustomMenuItem createColumnCustomMenuItem(ContextMenu contextMenu, TableColumn<?, ?> column) {
        CheckBox checkBox = new CheckBox(column.getText());
        contextMenu.focusedProperty().addListener(event -> checkBox.setPrefWidth(contextMenu.getWidth() * 0.75));
        checkBox.selectedProperty().bindBidirectional(column.visibleProperty());
        CustomMenuItem customMenuItem = new CustomMenuItem(checkBox);
        customMenuItem.getStyleClass().set(1, "check-menu-item");
        customMenuItem.setOnAction(event -> {
            checkBox.setSelected(!checkBox.isSelected());
            event.consume();
        });
        customMenuItem.setHideOnClick(false);
        return customMenuItem;
    }
}

