/*
 * Decompiled with CFR 0.152.
 */
package com.jwetherell.openmap.common;

import com.jwetherell.openmap.common.LatLonPoint;
import com.jwetherell.openmap.common.ProjMath;

public abstract class GreatCircle {
    public static final float sphericalDistance(float phi1, float lambda0, float phi, float lambda) {
        return (float)GreatCircle.sphericalDistance((double)phi1, (double)lambda0, (double)phi, (double)lambda);
    }

    public static final double sphericalDistance(double phi1, double lambda0, double phi, double lambda) {
        double pdiff = Math.sin((phi - phi1) / 2.0);
        double ldiff = Math.sin((lambda - lambda0) / 2.0);
        double rval = Math.sqrt(pdiff * pdiff + Math.cos(phi1) * Math.cos(phi) * (ldiff * ldiff));
        return 2.0 * Math.asin(rval);
    }

    public static final float sphericalAzimuth(float phi1, float lambda0, float phi, float lambda) {
        return (float)GreatCircle.sphericalAzimuth((double)phi1, (double)lambda0, (double)phi, (double)lambda);
    }

    public static final double sphericalAzimuth(double phi1, double lambda0, double phi, double lambda) {
        double ldiff = lambda - lambda0;
        double cosphi = Math.cos(phi);
        return Math.atan2(cosphi * Math.sin(ldiff), Math.cos(phi1) * Math.sin(phi) - Math.sin(phi1) * cosphi * Math.cos(ldiff));
    }

    public static final LatLonPoint sphericalBetween(double phi1, double lambda0, double c, double Az) {
        double cosphi1 = Math.cos(phi1);
        double sinphi1 = Math.sin(phi1);
        double cosAz = Math.cos(Az);
        double sinAz = Math.sin(Az);
        double sinc = Math.sin(c);
        double cosc = Math.cos(c);
        return new LatLonPoint(ProjMath.radToDeg(Math.asin(sinphi1 * cosc + cosphi1 * sinc * cosAz)), ProjMath.radToDeg(Math.atan2(sinc * sinAz, cosphi1 * cosc - sinphi1 * sinc * cosAz) + lambda0));
    }

    public static final float[] sphericalBetween(float phi1, float lambda0, float c, float Az, int n) {
        float inc;
        double cosphi1 = Math.cos(phi1);
        double sinphi1 = Math.sin(phi1);
        double cosAz = Math.cos(Az);
        double sinAz = Math.sin(Az);
        int end = n << 1;
        float[] points = new float[end + 2];
        points[0] = phi1;
        points[1] = lambda0;
        c = inc = c / (float)n;
        int i = 2;
        while (i <= end) {
            double sinc = Math.sin(c);
            double cosc = Math.cos(c);
            points[i] = (float)Math.asin(sinphi1 * cosc + cosphi1 * sinc * cosAz);
            points[i + 1] = (float)Math.atan2(sinc * sinAz, cosphi1 * cosc - sinphi1 * sinc * cosAz) + lambda0;
            i += 2;
            c += inc;
        }
        return points;
    }

    public static final double[] sphericalBetween(double phi1, double lambda0, double c, double Az, int n) {
        double inc;
        double cosphi1 = Math.cos(phi1);
        double sinphi1 = Math.sin(phi1);
        double cosAz = Math.cos(Az);
        double sinAz = Math.sin(Az);
        int end = n << 1;
        double[] points = new double[end + 2];
        points[0] = phi1;
        points[1] = lambda0;
        c = inc = c / (double)n;
        int i = 2;
        while (i <= end) {
            double sinc = Math.sin(c);
            double cosc = Math.cos(c);
            points[i] = Math.asin(sinphi1 * cosc + cosphi1 * sinc * cosAz);
            points[i + 1] = Math.atan2(sinc * sinAz, cosphi1 * cosc - sinphi1 * sinc * cosAz) + lambda0;
            i += 2;
            c += inc;
        }
        return points;
    }

    public static final float[] greatCircle(float phi1, float lambda0, float phi, float lambda, int n, boolean include_last) {
        double inc;
        int end = include_last ? n + 1 : n;
        end <<= 1;
        double cosphi = Math.cos(phi);
        double cosphi1 = Math.cos(phi1);
        double sinphi1 = Math.sin(phi1);
        double ldiff = lambda - lambda0;
        double p2diff = Math.sin((phi - phi1) / 2.0f);
        double l2diff = Math.sin(ldiff / 2.0);
        double c = 2.0 * Math.asin(Math.sqrt(p2diff * p2diff + cosphi1 * cosphi * l2diff * l2diff));
        double Az = Math.atan2(cosphi * Math.sin(ldiff), cosphi1 * Math.sin(phi) - sinphi1 * cosphi * Math.cos(ldiff));
        double cosAz = Math.cos(Az);
        double sinAz = Math.sin(Az);
        float[] points = new float[end];
        points[0] = phi1;
        points[1] = lambda0;
        c = inc = c / (double)n;
        int i = 2;
        while (i < end) {
            double sinc = Math.sin(c);
            double cosc = Math.cos(c);
            points[i] = (float)Math.asin(sinphi1 * cosc + cosphi1 * sinc * cosAz);
            points[i + 1] = (float)Math.atan2(sinc * sinAz, cosphi1 * cosc - sinphi1 * sinc * cosAz) + lambda0;
            i += 2;
            c += inc;
        }
        return points;
    }

    public static final double[] greatCircle(double phi1, double lambda0, double phi, double lambda, int n, boolean include_last) {
        double inc;
        int end = include_last ? n + 1 : n;
        end <<= 1;
        double cosphi = Math.cos(phi);
        double cosphi1 = Math.cos(phi1);
        double sinphi1 = Math.sin(phi1);
        double ldiff = lambda - lambda0;
        double p2diff = Math.sin((phi - phi1) / 2.0);
        double l2diff = Math.sin(ldiff / 2.0);
        double c = 2.0 * Math.asin(Math.sqrt(p2diff * p2diff + cosphi1 * cosphi * l2diff * l2diff));
        double Az = Math.atan2(cosphi * Math.sin(ldiff), cosphi1 * Math.sin(phi) - sinphi1 * cosphi * Math.cos(ldiff));
        double cosAz = Math.cos(Az);
        double sinAz = Math.sin(Az);
        double[] points = new double[end];
        points[0] = phi1;
        points[1] = lambda0;
        c = inc = c / (double)n;
        int i = 2;
        while (i < end) {
            double sinc = Math.sin(c);
            double cosc = Math.cos(c);
            points[i] = Math.asin(sinphi1 * cosc + cosphi1 * sinc * cosAz);
            points[i + 1] = Math.atan2(sinc * sinAz, cosphi1 * cosc - sinphi1 * sinc * cosAz) + lambda0;
            i += 2;
            c += inc;
        }
        return points;
    }

    public static final float[] earthCircle(float phi1, float lambda0, float c, float s, float e, int n) {
        return GreatCircle.earthCircle(phi1, lambda0, c, s, e, n, new float[n << 1]);
    }

    public static final float[] earthCircle(float phi1, float lambda0, float c, int n) {
        return GreatCircle.earthCircle(phi1, lambda0, c, 0.0f, (float)Math.PI * 2, n, new float[n << 1]);
    }

    public static final float[] earthCircle(float phi1, float lambda0, float c, int n, float[] ret_val) {
        return GreatCircle.earthCircle(phi1, lambda0, c, 0.0f, (float)Math.PI * 2, n, ret_val);
    }

    public static final float[] earthCircle(float phi1, float lambda0, float c, float s, float e, int n, float[] ret_val) {
        double cosphi1 = Math.cos(phi1);
        double sinphi1 = Math.sin(phi1);
        double sinc = Math.sin(c);
        double cosc = Math.cos(c);
        if (n < 2) {
            n = 2;
        }
        int end = n << 1;
        if (ret_val == null || end > ret_val.length) {
            ret_val = new float[end];
        }
        double inc = e / (float)(n - 1);
        double Az = s;
        int i = 0;
        while (i < end) {
            double cosAz = Math.cos(Az);
            double sinAz = Math.sin(Az);
            ret_val[i] = (float)Math.asin(sinphi1 * cosc + cosphi1 * sinc * cosAz);
            ret_val[i + 1] = (float)Math.atan2(sinc * sinAz, cosphi1 * cosc - sinphi1 * sinc * cosAz) + lambda0;
            i += 2;
            Az += inc;
        }
        return ret_val;
    }

    public static final double[] earthCircle(double phi1, double lambda0, double c, double s, double e, int n) {
        return GreatCircle.earthCircle(phi1, lambda0, c, s, e, n, new double[n << 1]);
    }

    public static final double[] earthCircle(double phi1, double lambda0, double c, int n) {
        return GreatCircle.earthCircle(phi1, lambda0, c, 0.0, Math.PI * 2, n, new double[n << 1]);
    }

    public static final double[] earthCircle(double phi1, double lambda0, double c, int n, double[] ret_val) {
        return GreatCircle.earthCircle(phi1, lambda0, c, 0.0, Math.PI * 2, n, ret_val);
    }

    public static final double[] earthCircle(double phi1, double lambda0, double c, double s, double e, int n, double[] ret_val) {
        double cosphi1 = Math.cos(phi1);
        double sinphi1 = Math.sin(phi1);
        double sinc = Math.sin(c);
        double cosc = Math.cos(c);
        if (n < 2) {
            n = 2;
        }
        int end = n << 1;
        if (ret_val == null || end > ret_val.length) {
            ret_val = new double[end];
        }
        double inc = e / (double)(n - 1);
        double Az = s;
        int i = 0;
        while (i < end) {
            double cosAz = Math.cos(Az);
            double sinAz = Math.sin(Az);
            ret_val[i] = Math.asin(sinphi1 * cosc + cosphi1 * sinc * cosAz);
            ret_val[i + 1] = Math.atan2(sinc * sinAz, cosphi1 * cosc - sinphi1 * sinc * cosAz) + lambda0;
            i += 2;
            Az += inc;
        }
        return ret_val;
    }
}

