/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import net.sourceforge.plantuml.code.ArobaseStringCompressor;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.AsciiEncoderHex;
import net.sourceforge.plantuml.code.CompressionHuffman;
import net.sourceforge.plantuml.code.CompressionNone;
import net.sourceforge.plantuml.code.CompressionZlib;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderImpl;

public class TranscoderSmart
implements Transcoder {
    private final Transcoder oldOne = TranscoderImpl.utf8(new AsciiEncoder(), new ArobaseStringCompressor(), new CompressionHuffman());
    private final Transcoder zlib = TranscoderImpl.utf8(new AsciiEncoder(), new ArobaseStringCompressor(), new CompressionZlib());
    private final Transcoder hexOnly = TranscoderImpl.utf8(new AsciiEncoderHex(), new ArobaseStringCompressor(), new CompressionNone());

    @Override
    public String decode(String code) throws NoPlantumlCompressionException {
        if (code.startsWith("~0")) {
            return this.zlib.decode(code.substring(2));
        }
        if (code.startsWith("~1")) {
            return this.oldOne.decode(code.substring(2));
        }
        if (code.startsWith("~h")) {
            return this.hexOnly.decode(code.substring(2));
        }
        try {
            return this.zlib.decode(code);
        }
        catch (Exception ex) {
            return this.oldOne.decode(code);
        }
    }

    @Override
    public String encode(String text) throws IOException {
        return this.zlib.encode(text);
    }
}

