/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBox;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.wbs.WElement;

abstract class WBSTextBlock
extends AbstractTextBlock {
    protected final ISkinParam skinParam;
    private final StyleBuilder styleBuilder;
    private final int level;

    public WBSTextBlock(ISkinParam skinParam, StyleBuilder styleBuilder, int level) {
        this.skinParam = skinParam;
        this.styleBuilder = styleBuilder;
        this.level = level;
    }

    protected final void drawLine(UGraphic ug, Point2D p1, Point2D p2) {
        ULine line = new ULine(p1, p2);
        if (UseStyle.useBetaStyle()) {
            this.getStyleUsed().applyStrokeAndLineColor(ug.apply(new UTranslate(p1)), this.skinParam.getIHtmlColorSet(), this.skinParam.getThemeStyle()).draw(line);
        } else {
            HColor color = ColorParam.activityBorder.getDefaultValue();
            ug.apply(new UTranslate(p1)).apply(color).draw(line);
        }
    }

    private Style getStyleUsed() {
        return this.getDefaultStyleDefinitionArrow().getMergedStyle(this.styleBuilder);
    }

    protected final void drawLine(UGraphic ug, double x1, double y1, double x2, double y2) {
        this.drawLine(ug, new Point2D.Double(x1, y1), new Point2D.Double(x2, y2));
    }

    public final StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.wbsDiagram, SName.arrow).add(SName.depth(this.level));
    }

    protected final TextBlock buildMain(WElement idea) {
        Display label = idea.getLabel();
        Style style = idea.getStyle();
        if (idea.getShape() == IdeaShape.BOX) {
            FtileBox box = FtileBox.createWbs(style, idea.withBackColor(this.skinParam), label);
            return box;
        }
        TextBlock text = label.create0(style.getFontConfiguration(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet()), style.getHorizontalAlignment(), this.skinParam, style.wrapWidth(), CreoleMode.FULL, null, null);
        return TextBlockUtils.withMargin(text, 0.0, 3.0, 1.0, 1.0);
    }
}

