/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.styledstring;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.rtf.RTFEditorKit;
import org.protege.editor.owl.ui.renderer.styledstring.Style;
import org.protege.editor.owl.ui.renderer.styledstring.StyleAttribute;
import org.protege.editor.owl.ui.renderer.styledstring.StyledStringLayout;
import org.protege.editor.owl.ui.renderer.styledstring.StyledStringMarkup;

public final class StyledString
implements CharSequence,
Comparable<StyledString> {
    public static final String EMPTY_STRING = "";
    public static final StyledString EMPTY_STYLED_STRING = new StyledString();
    private final String plainString;
    private final List<StyledStringMarkup> plainStringMarkup;
    private StyledStringLayout styledStringLayout;

    public StyledString() {
        this(EMPTY_STRING);
    }

    public StyledString(String text) {
        this(text, Collections.emptyList());
    }

    public StyledString(String text, List<StyledStringMarkup> markup) {
        this.plainString = text;
        this.plainStringMarkup = Collections.unmodifiableList(new ArrayList<StyledStringMarkup>(markup));
    }

    @Override
    public char charAt(int index) {
        return this.plainString.charAt(index);
    }

    @Override
    public StyledString subSequence(int start, int end) {
        this.checkStartAndEnd(start, end);
        return this.substring(start, end);
    }

    private void checkStartAndEnd(int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("start < 0");
        }
        if (end < 0) {
            throw new IndexOutOfBoundsException("end < 0");
        }
        if (end > this.length()) {
            throw new IndexOutOfBoundsException("end > length");
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start > end");
        }
    }

    @Override
    public int compareTo(StyledString o) {
        return this.plainString.compareTo(o.plainString);
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public boolean isEmpty() {
        return this.plainString.isEmpty();
    }

    public String getString() {
        return this.plainString;
    }

    @Override
    public int length() {
        return this.plainString.length();
    }

    public StyledString substring(int start, int end) {
        if (end < start) {
            throw new IndexOutOfBoundsException("start (" + start + ") < end (" + end + ")");
        }
        if (start == end) {
            return EMPTY_STYLED_STRING;
        }
        String substring = this.plainString.substring(start, end);
        ArrayList<StyledStringMarkup> substringMarkup = new ArrayList<StyledStringMarkup>();
        for (StyledStringMarkup markup : this.plainStringMarkup) {
            if (start >= markup.getEnd() || end <= markup.getStart()) continue;
            int substringMarkupStart = markup.getStart() < start ? start : markup.getStart();
            int substringMarkupEnd = markup.getEnd() > end ? end : markup.getEnd();
            substringMarkup.add(new StyledStringMarkup(substringMarkupStart -= start, substringMarkupEnd -= start, markup.getStyle()));
        }
        return new StyledString(substring, substringMarkup);
    }

    private StyledStringLayout getStyledStringLayout() {
        if (this.styledStringLayout == null) {
            this.styledStringLayout = new StyledStringLayout(this);
        }
        return this.styledStringLayout;
    }

    public void draw(Graphics2D g2, float x, float y) {
        this.getStyledStringLayout().draw(g2, x, y);
    }

    public AttributedString toAttributedString() {
        AttributedString as = new AttributedString(this.plainString.toString());
        for (StyledStringMarkup markup : this.plainStringMarkup) {
            int end;
            Style style = markup.getStyle();
            int start = markup.getStart();
            if (start >= (end = markup.getEnd()) || -1 >= start || start >= this.plainString.length() || 0 >= end || end > this.plainString.length()) continue;
            for (StyleAttribute styleAttribute : style.getStyleAttributes()) {
                AttributedCharacterIterator.Attribute att = styleAttribute.getAttributedStringAttribute();
                Object val = styleAttribute.getAttributesStringValue();
                as.addAttribute(att, val, start, end);
            }
        }
        return as;
    }

    public void drawVerticallyCentredInRect(Graphics2D g2, Rectangle rectangle) {
        FontRenderContext fontRenderContext = g2.getFontRenderContext();
        float height = this.getStyledStringLayout().getHeight(fontRenderContext);
        float x = rectangle.x;
        float y = (float)rectangle.y + (float)(rectangle.getHeight() - (double)height) / 2.0f;
        this.draw(g2, x, y);
    }

    public void drawHorizontallyCenteredInRect(Graphics2D g2, Rectangle rectangle) {
        FontRenderContext fontRenderContext = g2.getFontRenderContext();
        float x = (float)rectangle.x + (float)(rectangle.getWidth() - (double)this.getStyledStringLayout().getWidth(fontRenderContext)) / 2.0f;
        float y = rectangle.y;
        this.draw(g2, x, y);
    }

    public void drawCentredInRect(Graphics2D g2, Rectangle rectangle) {
        FontRenderContext fontRenderContext = g2.getFontRenderContext();
        StyledStringLayout styledStringLayout = this.getStyledStringLayout();
        float x = (float)(rectangle.getWidth() - (double)styledStringLayout.getWidth(fontRenderContext)) / 2.0f;
        float y = (float)(rectangle.getHeight() - (double)styledStringLayout.getHeight(fontRenderContext)) / 2.0f;
        this.draw(g2, x, y);
    }

    public void appendToStyledDocument(StyledDocument styledDocument) {
        try {
            styledDocument.remove(0, styledDocument.getLength());
            styledDocument.insertString(0, this.getString(), null);
            for (StyledStringMarkup markup : this.plainStringMarkup) {
                Style style = markup.getStyle();
                int length = markup.getEnd() - markup.getStart();
                SimpleAttributeSet mas = new SimpleAttributeSet();
                for (StyleAttribute styleAttribute : style.getStyleAttributes()) {
                    StyleConstants styleConstants = styleAttribute.getTextAttribute();
                    Object value = styleAttribute.getTextValue();
                    mas.addAttribute(styleConstants, value);
                }
                styledDocument.setCharacterAttributes(markup.getStart(), length, mas, false);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public List<Style> getStylesAt(int index) {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (StyledStringMarkup markup : this.plainStringMarkup) {
            if (markup.getStart() > index || index >= markup.getEnd()) continue;
            styles.add(markup.getStyle());
        }
        return styles;
    }

    public Style getMergedStyle(int index) {
        List<Style> styles = this.getStylesAt(index);
        if (styles.isEmpty()) {
            return new Style(new StyleAttribute[0]);
        }
        if (styles.size() == 1) {
            return styles.get(0);
        }
        HashMap atts = new HashMap();
        for (Style style : styles) {
            for (StyleAttribute styleAttribute : style.getStyleAttributes()) {
                atts.put(styleAttribute.getClass(), styleAttribute);
            }
        }
        return new Style(new ArrayList<StyleAttribute>(atts.values()));
    }

    private void renderIntoHTML(Writer writer) {
        StringBuilder pw = new StringBuilder();
        ArrayList<StyledStringMarkup> sortedMarkups = new ArrayList<StyledStringMarkup>(this.plainStringMarkup);
        Collections.sort(sortedMarkups);
        HashSet currentStyles = new HashSet();
        ArrayList<Integer> runLimits = new ArrayList<Integer>();
        for (int i = 0; i < this.length(); ++i) {
            HashSet iStyles = new HashSet();
            for (StyledStringMarkup markup : sortedMarkups) {
                if (markup.getStart() > i || i >= markup.getEnd()) continue;
                iStyles.add(markup.getStyle());
            }
            if (iStyles.equals(currentStyles) && this.plainString.charAt(i) != '\n') continue;
            runLimits.add(i);
            currentStyles.clear();
            currentStyles.addAll(iStyles);
        }
        runLimits.add(this.plainString.length());
        int lastLimit = 0;
        for (Integer runLimit : runLimits) {
            List<StyleAttribute> styleAttributes = this.getMergedStyle(runLimit - 1).getStyleAttributes();
            if (!styleAttributes.isEmpty()) {
                pw.append("<span style=\"");
                for (StyleAttribute styleAttribute : styleAttributes) {
                    String propName = styleAttribute.getCSSPropertyName();
                    String propValue = styleAttribute.getCSSValue();
                    pw.append(propName);
                    pw.append(": ");
                    pw.append(propValue);
                    pw.append("; ");
                }
                pw.append("\">");
            }
            String substring = this.plainString.substring(lastLimit, runLimit);
            pw.append(substring);
            if (!styleAttributes.isEmpty()) {
                pw.append("</span>");
            }
            lastLimit = runLimit;
        }
        String[] lines = pw.toString().split("\\n");
        PrintWriter p = new PrintWriter(writer);
        p.append("<div style=\"font-family: verdana,sans-serif;\">");
        int counter = 0;
        for (String line : lines) {
            ++counter;
            if (line.equals("\n")) continue;
            p.append("<div class=\"line\">\n");
            p.append(line);
            p.append("\n");
            p.append("</div>\n");
        }
        p.append("</div>");
        p.flush();
    }

    public String toPlainText() {
        return this.plainString;
    }

    public String toRTF() {
        try {
            RTFEditorKit editorKit = new RTFEditorKit();
            StyledDocument document = (StyledDocument)editorKit.createDefaultDocument();
            this.appendToStyledDocument(document);
            SimpleAttributeSet fontFamily = new SimpleAttributeSet();
            StyleConstants.setFontFamily(fontFamily, "SansSerif");
            document.setParagraphAttributes(0, document.getLength(), fontFamily, false);
            document.setCharacterAttributes(0, 4, fontFamily, false);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            editorKit.write(os, (Document)document, 0, document.getLength());
            return new String(os.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Problem rendering string into RTF", e);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public String toHTML() {
        StringWriter sw = new StringWriter();
        this.renderIntoHTML(sw);
        return sw.getBuffer().toString();
    }

    public static final class Builder {
        public static final String NEW_LINE = "\n";
        public static final String SPACE = " ";
        public static final String TAB = "\t";
        private StringBuilder buffer = new StringBuilder();
        private List<StyledStringMarkup> markup = new ArrayList<StyledStringMarkup>();

        public Builder() {
        }

        public Builder(StyledString styledString) {
            this.buffer.append(styledString.plainString);
            this.markup.addAll(styledString.plainStringMarkup);
        }

        public int mark() {
            return this.buffer.length();
        }

        public void append(String s) {
            this.buffer.append(s);
        }

        public void appendWithStyle(String s, Style style) {
            int start = this.mark();
            this.buffer.append(s);
            int end = this.mark();
            this.markup.add(new StyledStringMarkup(start, end, style));
        }

        public void appendWithAttributes(String s, StyleAttribute ... attributes) {
            int start = this.mark();
            this.buffer.append(s);
            int end = this.mark();
            Style style = new Style(attributes);
            this.markup.add(new StyledStringMarkup(start, end, style));
        }

        public void appendNewLine() {
            this.buffer.append(NEW_LINE);
        }

        public void appendSpace() {
            this.buffer.append(SPACE);
        }

        public void appendTab() {
            this.buffer.append(TAB);
        }

        public void append(Number i) {
            this.buffer.append(i);
        }

        public void appendStyledString(StyledString styledString) {
            int offset = this.mark();
            this.buffer.append(styledString.plainString);
            for (StyledStringMarkup markup : styledString.plainStringMarkup) {
                this.markup.add(new StyledStringMarkup(markup.getStart() + offset, markup.getEnd() + offset, markup.getStyle()));
            }
        }

        public void applyStyle(int from, int to, Style style) {
            this.markup.add(new StyledStringMarkup(from, to, style));
        }

        public void applyStyleAttributes(int from, int to, StyleAttribute ... styleAttributes) throws IndexOutOfBoundsException {
            if (styleAttributes.length == 0) {
                return;
            }
            if (this.buffer.length() == 0) {
                return;
            }
            if (from < 0) {
                throw new IndexOutOfBoundsException("from < 0");
            }
            if (to < 0) {
                throw new IndexOutOfBoundsException("to < 0");
            }
            if (from >= this.buffer.length()) {
                throw new IndexOutOfBoundsException("from >= mark");
            }
            if (to > this.buffer.length()) {
                throw new IndexOutOfBoundsException("to >= mark");
            }
            Style style = new Style(styleAttributes);
            this.markup.add(new StyledStringMarkup(from, to, style));
        }

        public void applyStyleAttributes(StyleAttribute ... styleAttributes) {
            this.applyStyleAttributes(0, this.mark(), styleAttributes);
        }

        public StyledString build() {
            return new StyledString(this.buffer.toString(), this.markup);
        }
    }
}

