import sys
from _typeshed import ReadableBuffer

if sys.version_info >= (3, 0):
    from hashlib import _Hash
else:
    from hashlib import _hash as _Hash

VERSION: str
XXHASH_VERSION: str

class _IntDigestHash(_Hash):
    seed: int
    digestsize: int
    def __init__(self, __string: ReadableBuffer = ..., seed: int = ...) -> None: ...
    def intdigest(self) -> int: ...
    def reset(self) -> None: ...

# python-xxhash v2.0.0 does not support the string or usedforsecurity kwargs
class xxh32(_IntDigestHash): ...
class xxh64(_IntDigestHash): ...
class xxh3_64(_IntDigestHash): ...
class xxh3_128(_IntDigestHash): ...

def xxh32_digest(input: ReadableBuffer = ..., seed: int = ...) -> bytes: ...
def xxh32_intdigest(input: ReadableBuffer = ..., seed: int = ...) -> int: ...
def xxh32_hexdigest(input: ReadableBuffer = ..., seed: int = ...) -> str: ...
def xxh64_digest(input: ReadableBuffer = ..., seed: int = ...) -> bytes: ...
def xxh64_intdigest(input: ReadableBuffer = ..., seed: int = ...) -> int: ...
def xxh64_hexdigest(input: ReadableBuffer = ..., seed: int = ...) -> str: ...
def xxh3_64_digest(input: ReadableBuffer = ..., seed: int = ...) -> bytes: ...
def xxh3_64_intdigest(input: ReadableBuffer = ..., seed: int = ...) -> int: ...
def xxh3_64_hexdigest(input: ReadableBuffer = ..., seed: int = ...) -> str: ...
def xxh3_128_digest(input: ReadableBuffer = ..., seed: int = ...) -> bytes: ...
def xxh3_128_intdigest(input: ReadableBuffer = ..., seed: int = ...) -> int: ...
def xxh3_128_hexdigest(input: ReadableBuffer = ..., seed: int = ...) -> str: ...

xxh128 = xxh3_128
xxh128_digest = xxh3_128_digest
xxh128_intdigest = xxh3_128_intdigest
xxh128_hexdigest = xxh3_128_hexdigest
