from collections import OrderedDict

from .. import Provider as ColorProvider


class Provider(ColorProvider):
    """Implement color provider for ``uk_UA`` locale.

    Sources:
    - https://uk.wikipedia.org/wiki/Список_кольорів
    """

    all_colors = OrderedDict((
        ('Абрикосовий', '#FBCEB1'),
        ('Аквамариновий', '#7FFFD4'),
        ('Алізариновий червоний', '#E32636'),
        ('Амарантовий', '#E52B50'),
        ('Амарантово-рожевий', '#F19CBB'),
        ('Аметистовий', '#9966CC'),
        ('Андроїдний зелений', '#A4C639'),
        ('Арсеновий', '#3B444B'),
        ('Атомний мандаріновий', '#FF9966'),
        ('Багряний', '#FF2400'),
        ('Баклажановий', '#990066'),
        ('Барвінковий', '#CCCCFF'),
        ('Бежевий', '#F5F5DC'),
        ('Берлінська лазур', '#003153'),
        ('Блаватний', '#6495ED'),
        ('Блакитний', '#AFEEEE'),
        ('Блакитний Брандейса', '#0070FF'),
        ('Блакитно-зелений', '#00DDDD'),
        ('Блакитно-фіолетовий', '#8A2BE2'),
        ('Блідий рожево-ліловий', '#996666'),
        ('Блідо-брунатний', '#987654'),
        ('Блідо-волошковий', '#ABCDEF'),
        ('Блідо-карміновий', '#AF4035'),
        ('Блідо-каштановий', '#DDADAF'),
        ('Блідо-пурпуровий', '#F984E5'),
        ('Блідо-пісочний', '#DABDAB'),
        ('Блідо-рожевий', '#FADADD'),
        ('Болотний', '#ACB78E'),
        ('Бронзовий', '#CD7F32'),
        ('Брунатний', '#964B00'),
        ('Брунато-малиновий', '#800000'),
        ('Будяковий', '#D8BFD8'),
        ('Бузковий', '#C8A2C8'),
        ('Бургундський', '#900020'),
        ('Бурий', '#755A57'),
        ('Бурштиновий', '#FFBF00'),
        ('Білий', '#FFFFFF'),
        ('Білий навахо', '#FFDEAD'),
        ('Бірюзовий', '#30D5C8'),
        ('Бістр', '#3D2B1F'),
        ('Вода пляжа Бонді', '#0095B6'),
        ('Вохра', '#CC7722'),
        ('Відбірний жовтий', '#FFBA00'),
        ('Візантійський', '#702963'),
        ('Гарбуз', '#FF7518'),
        ('Гарячо-рожевий', '#FC0FC0'),
        ('Геліотроп', '#DF73FF'),
        ('Глибокий фіолетовий', '#423189'),
        ('Глицінія', '#C9A0DC'),
        ('Грушевий', '#D1E231'),
        ('Гумігут', '#E49B0F'),
        ('Гірчичний', '#FFDB58'),
        ('Дерева', '#79443B'),
        ('Джинсовий', '#1560BD'),
        ('Діамантово-рожевий', '#FF55A3'),
        ('Жовтий', '#FFFF00'),
        ('Жовто-зелений', '#ADFF2F'),
        ('Жовто-персиковий', '#FADFAD'),
        ('Захисний синій', '#1E90FF'),
        ('Зелена весна', '#00FF7F'),
        ('Зелена мʼята', '#98FF98'),
        ('Зелена сосна', '#01796F'),
        ('Зелене море', '#2E8B57'),
        ('Зелений', '#00FF00'),
        ('Зелений армійський', '#4B5320'),
        ('Зелений мох', '#ADDFAD'),
        ('Зелений папороть', '#4F7942'),
        ('Зелений чай', '#D0F0C0'),
        ('Зелено-сірий чай', '#CADABA'),
        ('Зеленувато-блакитний', '#008080'),
        ('Золотаво-березовий', '#DAA520'),
        ('Золотий', '#FFD700'),
        ('Золотисто-каштановий', '#6D351A'),
        ('Індиго', '#4B0082'),
        ('Іржавий', '#B7410E'),
        ('Кардинал (колір)', '#C41E3A'),
        ('Карміновий', '#960018'),
        ('Каштановий', '#CD5C5C'),
        ('Кобальтовий', '#0047AB'),
        ('Колір жовтого шкільного автобуса', '#FFD800'),
        ('Колір засмаги', '#D2B48C'),
        ('Колір морської піни', '#FFF5EE'),
        ('Колір морської хвилі', '#00FFFF'),
        ('Кораловий', '#FF7F50'),
        ('Королівський синій', '#4169E1'),
        ('Кремовий', '#FFFDD0'),
        ('Кукурудзяний', '#FBEC5D'),
        ('Кіновар', '#FF4D00'),
        ('Лавандний', '#E6E6FA'),
        ('Лазуровий', '#007BA7'),
        ('Лазурово-синій', '#2A52BE'),
        ('Лайм', '#CCFF00'),
        ('Латунний', '#B5A642'),
        ('Лимонний', '#FDE910'),
        ('Лимонно-кремовий', '#FFFACD'),
        ('Лляний', '#EEDC82'),
        ('Лляний', '#FAF0E6'),
        ('Лососевий', '#FF8C69'),
        ('Ліловий', '#DB7093'),
        ('Малахітовий', '#0BDA51'),
        ('Малиновий', '#DC143C'),
        ('Мандариновий', '#FFCC00'),
        ('Мисливський', '#004225'),
        ('Морквяний', '#ED9121'),
        ('Мідний', '#B87333'),
        ('Міжнародний помаранчевий', '#FF4F00'),
        ('Нефритовий', '#00A86B'),
        ('Ніжно-блакитний', '#E0FFFF'),
        ('Ніжно-оливковий', '#6B8E23'),
        ('Ніжно-рожевий', '#FB607F'),
        ('Оливковий', '#808000'),
        ('Опівнічно-синій', '#003366'),
        ('Орхідея', '#DA70D6'),
        ('Палена сіена', '#E97451'),
        ('Палений оранжевий', '#CC5500'),
        ('Панг', '#C7FCEC'),
        ('Паросток папаї', '#FFEFD5'),
        ('Пастельно-зелений', '#77DD77'),
        ('Пастельно-рожевий', '#FFD1DC'),
        ('Персиковий', '#FFE5B4'),
        ('Перський синій', '#6600FF'),
        ('Помаранчевий', '#FFA500'),
        ('Помаранчево-персиковий', '#FFCC99'),
        ('Помаранчево-рожевий', '#FF9966'),
        ('Пурпурний', '#FF00FF'),
        ('Пурпуровий', '#660099'),
        ('Пшеничний', '#F5DEB3'),
        ('Пісочний колір', '#F4A460'),
        ('Рожевий', '#FFC0CB'),
        ('Рожевий Маунтбеттена', '#997A8D'),
        ('Рожево-лавандний', '#FFF0F5'),
        ('Рожево-ліловий', '#993366'),
        ('Салатовий', '#7FFF00'),
        ('Сангрія', '#92000A'),
        ('Сапфіровий', '#082567'),
        ('Світло-синій', '#007DFF'),
        ('Сепія', '#704214'),
        ('Сиваво-зелений', '#ACE1AF'),
        ('Сигнально-помаранчевий', '#FF9900'),
        ('Синя пил', '#003399'),
        ('Синя сталь', '#4682B4'),
        ('Сині яйця малинівки', '#00CCCC'),
        ('Синій', '#0000FF'),
        ('Синій (RYB)', '#0247FE'),
        ('Синій (пігмент)', '#333399'),
        ('Синій ВПС', '#5D8AA8'),
        ('Синій Клейна', '#3A75C4'),
        ('Сливовий', '#660066'),
        ('Смарагдовий', '#50C878'),
        ('Спаржевий', '#7BA05B'),
        ('Срібний', '#C0C0C0'),
        ('Старе золото', '#CFB53B'),
        ('Сіра спаржа', '#465945'),
        ('Сірий', '#808080'),
        ('Сірий шифер', '#708090'),
        ('Темний весняно-зелений', '#177245'),
        ('Темний жовто-брунатний', '#918151'),
        ('Темний зелений чай', '#BADBAD'),
        ('Темний пастельно-зелений', '#03C03C'),
        ('Темний хакі', '#BDB76B'),
        ('Темний індиго', '#310062'),
        ('Темно-аспідний сірий', '#2F4F4F'),
        ('Темно-брунатний', '#654321'),
        ('Темно-бірюзовий', '#116062'),
        ('Темно-зелений', '#013220'),
        ('Темно-зелений хакі', '#78866B'),
        ('Темно-золотий', '#B8860B'),
        ('Темно-карміновий', '#560319'),
        ('Темно-каштановий', '#986960'),
        ('Темно-кораловий', '#CD5B45'),
        ('Темно-лазурний', '#08457E'),
        ('Темно-лососевий', '#E9967A'),
        ('Темно-мандариновий', '#FFA812'),
        ('Темно-оливковий', '#556832'),
        ('Темно-персиковий', '#FFDAB9'),
        ('Темно-рожевий', '#E75480'),
        ('Темно-синій', '#000080'),
        ('Ультрамариновий', '#120A8F'),
        ('Умбра', '#734A12'),
        ('Умбра палена', '#8A3324'),
        ('Фуксія', '#FF00FF'),
        ('Фіолетовий', '#8B00FF'),
        ('Фіолетово-баклажановий', '#991199'),
        ('Фіолетово-червоний', '#C71585'),
        ('Хакі', '#C3B091'),
        ('Цинамоновий', '#7B3F00'),
        ('Циннвальдит', '#EBC2AF'),
        ('Ціан (колір)', '#00FFFF'),
        ('Ціано-блакитний', '#F0F8FF'),
        ('Червоний', '#FF0000'),
        ('Червоно-буро-помаранчевий', '#CD5700'),
        ('Червоновато-брунатний', '#CC8899'),
        ('Чорний', '#000000'),
        ('Шафрановий', '#F4C430'),
        ('Шкіра буйвола', '#F0DC82'),
        ('Шоколадний', '#D2691E'),
        ('Яскраво-бурштиновий', '#FF7E00'),
        ('Яскраво-бірюзовий', '#08E8DE'),
        ('Яскраво-зелений', '#66FF00'),
        ('Яскраво-зелений', '#40826D'),
        ('Яскраво-рожевий', '#FF007F'),
        ('Яскраво-фіолетовий', '#CD00CD'),
        ('Ясно-брунатний', '#CD853F'),
        ('Ясно-вишневий', '#DE3163'),
        ('Ясно-лазуровий', '#007FFF'),
        ('Ясно-лазуровий (веб)', '#F0FFFF'),
    ))
