/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.util;

import java.text.ParseException;

public class Version
implements Comparable {
    private final int major;
    private final int minor;
    private final int patch;
    private final String qualifier;

    public Version(String stringArray) throws ParseException {
        stringArray = stringArray.split("\\.");
        if (stringArray == null || stringArray.length == 0 || stringArray.length > 4) {
            throw new ParseException("Ill formed OSGi version", 0);
        }
        try {
            this.major = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Major part of an OSGi version should be an integer", 0);
        }
        try {
            this.minor = stringArray.length >= 2 ? Integer.parseInt(stringArray[1]) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Minor part of an OSGi version should be an integer", 0);
        }
        try {
            this.patch = stringArray.length >= 3 ? Integer.parseInt(stringArray[2]) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Patch part of an OSGi version should be an integer", 0);
        }
        this.qualifier = stringArray.length == 4 ? stringArray[3] : null;
    }

    public Version(int n, int n2, int n3, String string) {
        this.major = n;
        this.minor = n2;
        this.patch = n3;
        this.qualifier = string;
    }

    public String toString() {
        return this.numbersAsString() + (this.qualifier == null ? "" : "." + this.qualifier);
    }

    public int hashCode() {
        int n = 31 + this.major;
        n = n * 31 + this.minor;
        n = n * 31 + this.patch;
        n = n * 31 + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        object = (Version)object;
        if (this.major != ((Version)object).major) {
            return false;
        }
        if (this.minor != ((Version)object).minor) {
            return false;
        }
        if (this.patch != ((Version)object).patch) {
            return false;
        }
        return !(this.qualifier == null ? ((Version)object).qualifier != null : !this.qualifier.equals(((Version)object).qualifier));
    }

    public String numbersAsString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public Version withNudgedPatch() {
        return new Version(this.major, this.minor, this.patch + 1, null);
    }

    public int compareUnqualified(Version version) {
        int n = this.major - version.major;
        if (n != 0) {
            return n;
        }
        n = this.minor - version.minor;
        if (n != 0) {
            return n;
        }
        n = this.patch - version.patch;
        if (n != 0) {
            return n;
        }
        return 0;
    }

    public int compareTo(Object object) {
        return this.compareTo((Version)object);
    }

    public int compareTo(Version version) {
        int n = this.compareUnqualified(version);
        if (n != 0) {
            return n;
        }
        if (this.qualifier == null) {
            if (version.qualifier != null) {
                return -1;
            }
            return 0;
        }
        if (version.qualifier == null) {
            return 1;
        }
        return this.qualifier.compareTo(version.qualifier);
    }
}

