/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration;

import java.awt.event.ActionEvent;
import java.beans.PropertyDescriptor;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.DataObject;

public abstract class ConfigurationAction<T extends DataObject>
extends AbstractAction
implements Runnable {
    private static final long serialVersionUID = -7896814237715570372L;
    private String property;
    private AbstractButton button;
    private boolean listen;

    protected abstract Bean<T> getBean();

    public ConfigurationAction(String property, String name, String tooltip, String icon) {
        this.putValue("Name", name);
        this.putValue("ShortDescription", tooltip);
        this.putValue("SmallIcon", Icons.getIcon(icon));
        this.property = property;
        this.listen = true;
    }

    public void setButton(AbstractButton button) {
        this.button = button;
    }

    public void update() {
        Bean<T> bean;
        if (this.button != null && (bean = this.getBean()) != null) {
            Boolean state = (Boolean)bean.getValue(this.property);
            this.listen = false;
            this.button.setSelected(state != null && state != false);
            this.listen = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listen) {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        PropertyDescriptor pd;
        Boolean state = this.button.isSelected();
        Bean<T> bean = this.getBean();
        if (bean != null && (pd = bean.getProperty(this.property)) != null) {
            bean.setValue(pd, state);
        }
    }
}

