/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.user;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.user.UserNamePreferencesManager;
import org.protege.editor.owl.model.user.UserNameProvider;

public class DefaultUserNameProvider
implements UserNameProvider {
    public static final String SYSTEM_USER_NAME_PROPERTY = "user.name";
    private final UserNameProvider gitRepositoryUserNameProvider;
    private final UserNamePreferencesManager preferencesManager;
    private final Properties properties;

    public DefaultUserNameProvider(@Nonnull UserNameProvider gitRepositoryUserNameProvider, @Nonnull UserNamePreferencesManager preferencesManager, @Nonnull Properties properties) {
        this.gitRepositoryUserNameProvider = (UserNameProvider)Preconditions.checkNotNull((Object)gitRepositoryUserNameProvider);
        this.preferencesManager = (UserNamePreferencesManager)Preconditions.checkNotNull((Object)preferencesManager);
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties);
    }

    @Override
    public Optional<String> getUserName() {
        Optional<String> gitUserName = this.getGitUserNameIfAvailable();
        if (gitUserName.isPresent()) {
            return gitUserName;
        }
        Optional<String> userName = this.preferencesManager.getUserName();
        if (userName.isPresent()) {
            return userName;
        }
        return Optional.ofNullable(this.properties.getProperty(SYSTEM_USER_NAME_PROPERTY));
    }

    private Optional<String> getGitUserNameIfAvailable() {
        if (this.preferencesManager.isUseGitUserNameIfAvailable()) {
            return this.gitRepositoryUserNameProvider.getUserName();
        }
        return Optional.empty();
    }
}

