/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.actions;

import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.jfluid.TargetAppRunner;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.profiler.ResultsListener;
import org.graalvm.visualvm.lib.profiler.ResultsManager;
import org.graalvm.visualvm.lib.profiler.actions.Bundle;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.utilities.Delegate;
import org.graalvm.visualvm.lib.profiler.utilities.ProfilerUtils;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.CallableSystemAction;

public final class ResetResultsAction
extends CallableSystemAction {
    Listener resultListener;

    private ResetResultsAction() {
        this.putValue("Name", Bundle.LBL_ResetResultsAction());
        this.putValue("ShortDescription", Bundle.HINT_ResetResultsAction());
        this.putValue("SmallIcon", Icons.getIcon((String)"ProfilerIcons.ResetResults"));
        this.putValue("iconBase", Icons.getResource((String)"ProfilerIcons.ResetResults"));
        this.resultListener = (Listener)Lookup.getDefault().lookup(Listener.class);
        this.resultListener.setDelegate((Object)this);
        this.updateEnabledState();
    }

    public static ResetResultsAction getInstance() {
        return Singleton.INSTANCE;
    }

    public void performAction() {
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            @Override
            public void run() {
                ResultsManager.getDefault().reset();
                try {
                    TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
                    if (runner.targetJVMIsAlive()) {
                        runner.resetTimers();
                    } else {
                        runner.getProfilerClient().resetClientData();
                    }
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    // empty catch block
                }
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public String getName() {
        return Bundle.LBL_ResetResultsAction();
    }

    protected String iconResource() {
        return Icons.getResource((String)"ProfilerIcons.ResetResults");
    }

    private void updateEnabledState() {
        this.setEnabled(ResultsManager.getDefault().resultsAvailable());
    }

    private static final class Singleton {
        private static final ResetResultsAction INSTANCE = new ResetResultsAction();

        private Singleton() {
        }
    }

    public static final class Listener
    extends Delegate<ResetResultsAction>
    implements ResultsListener {
        @Override
        public void resultsAvailable() {
            if (this.getDelegate() != null) {
                ((ResetResultsAction)((Object)this.getDelegate())).updateEnabledState();
            }
        }

        @Override
        public void resultsReset() {
            if (this.getDelegate() != null) {
                ((ResetResultsAction)((Object)this.getDelegate())).updateEnabledState();
            }
        }
    }
}

